/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.core;

import com.atlassian.jira.migration.db.FileAttachmentTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.db.JiraIssueTableWithArchivedColumns;
import com.atlassian.jira.migration.export.db.core.JiraAttachmentReader;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.schema.SchemaStateProvider;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\bJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011R!\u0010\u0007\u001a\u00020\b8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/db/core/JiraAttachmentReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "schemaStateProvider", "Lcom/atlassian/pocketknife/api/querydsl/schema/SchemaStateProvider;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/pocketknife/api/querydsl/schema/SchemaStateProvider;)V", "archivedFieldExists", "", "getArchivedFieldExists$annotations", "()V", "getArchivedFieldExists", "()Z", "archivedFieldExists$delegate", "Lkotlin/Lazy;", "getAllAttachmentsIds", "", "", "getAttachmentsCountByProject", "projectId", "migrateArchivedIssues", "getAttachmentsIdsByProject", "getTotalAttachmentsSizeByProject", "Companion", "jira-migration-plugin"})
public final class JiraAttachmentReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final SchemaStateProvider schemaStateProvider;
    @NotNull
    private final Lazy archivedFieldExists$delegate;
    private static final Logger log = LoggerFactory.getLogger(JiraAttachmentReader.class);

    @Inject
    public JiraAttachmentReader(@NotNull DatabaseAccessor databaseAccessor, @NotNull SchemaStateProvider schemaStateProvider) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)schemaStateProvider, (String)"schemaStateProvider");
        this.databaseAccessor = databaseAccessor;
        this.schemaStateProvider = schemaStateProvider;
        this.archivedFieldExists$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ JiraAttachmentReader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                Object object;
                try {
                    JiraAttachmentReader.access$getLog$cp().debug("Executing db query to identify if archived field exists in Jira Issue table");
                    object = JiraAttachmentReader.access$getDatabaseAccessor$p(this.this$0).run(arg_0 -> archivedFieldExists.2.invoke$lambda$1(this.this$0, arg_0), OnRollback.NOOP);
                    Boolean it = (Boolean)object;
                    boolean bl = false;
                    JiraAttachmentReader.access$getLog$cp().debug("Successfully executed db query to identify if archived field exists in Jira Issue table");
                    object = (Boolean)object;
                }
                catch (Exception ex) {
                    JiraAttachmentReader.access$getLog$cp().error("Error while executing db query to identify if archived field exists in Jira Issue table", (Throwable)ex);
                    throw ex;
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            private static final Boolean invoke$lambda$1(JiraAttachmentReader this$0, DatabaseConnection db) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Set set = JiraAttachmentReader.access$getSchemaStateProvider$p(this$0).getSchemaState(db.getJdbcConnection(), (RelationalPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE()).getAddedColumns();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAddedColumns(...)");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    void var11_11 = it;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string2 = var11_11.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    collection.add(string2);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).contains("archived");
            }
        }));
    }

    public final boolean getArchivedFieldExists() {
        Lazy lazy = this.archivedFieldExists$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Boolean)object;
    }

    @VisibleForTesting
    public static /* synthetic */ void getArchivedFieldExists$annotations() {
    }

    @NotNull
    public final List<Long> getAllAttachmentsIds() {
        try {
            log.debug("Executing db query to fetch all attachment ids");
            Object object = this.databaseAccessor.run(JiraAttachmentReader::getAllAttachmentsIds$lambda$0, OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            log.debug("Successfully executed db query to all attachment ids");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching all attachment ids", (Throwable)ex);
            throw ex;
        }
    }

    @NotNull
    public final List<Long> getAttachmentsIdsByProject(long projectId) {
        try {
            log.debug("Executing db query to fetch all attachment ids associated with project " + projectId);
            Object object = this.databaseAccessor.run(arg_0 -> JiraAttachmentReader.getAttachmentsIdsByProject$lambda$2(projectId, arg_0), OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            log.debug("Successfully fetched all attachment ids associated with project " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching all attachment ids associated with project {}", (Object)projectId, (Object)ex);
            throw ex;
        }
    }

    public final long getAttachmentsCountByProject(long projectId, boolean migrateArchivedIssues) {
        JiraIssueTable issueTable = this.getArchivedFieldExists() ? (JiraIssueTable)new JiraIssueTableWithArchivedColumns() : JiraIssueTable.Companion.getJIRA_ISSUE_TABLE();
        try {
            log.debug("Executing db query to fetch attachment count associated with project: {} and migrateArchivedIssues: {}", (Object)projectId, (Object)migrateArchivedIssues);
            Object object = this.databaseAccessor.run(arg_0 -> JiraAttachmentReader.getAttachmentsCountByProject$lambda$4(issueTable, projectId, migrateArchivedIssues, arg_0), OnRollback.NOOP);
            Long it = (Long)object;
            boolean bl = false;
            log.debug("Successfully fetched attachment count associated with project " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return ((Number)object2).longValue();
        }
        catch (Exception ex) {
            log.error("Error while fetching attachment counts for project: {}", (Object)projectId, (Object)ex);
            throw ex;
        }
    }

    public final long getAttachmentsCountByProject(long projectId) {
        try {
            log.debug("Executing db query to fetch attachment count associated with project: " + projectId);
            Object object = this.databaseAccessor.run(arg_0 -> JiraAttachmentReader.getAttachmentsCountByProject$lambda$6(projectId, arg_0), OnRollback.NOOP);
            Long it = (Long)object;
            boolean bl = false;
            log.debug("Successfully fetched attachments count associated with project " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return ((Number)object2).longValue();
        }
        catch (Exception ex) {
            log.error("Error while fetching attachment count associated with project: {}", (Object)projectId, (Object)ex);
            throw ex;
        }
    }

    public final long getTotalAttachmentsSizeByProject(long projectId) {
        try {
            log.debug("Executing db query to fetch total attachment size associated with project: " + projectId);
            Object object = this.databaseAccessor.run(arg_0 -> JiraAttachmentReader.getTotalAttachmentsSizeByProject$lambda$8(projectId, arg_0), OnRollback.NOOP);
            Long it = (Long)object;
            boolean bl = false;
            log.debug("Successfully fetched total attachment size associated with project " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return ((Number)object2).longValue();
        }
        catch (Exception ex) {
            log.error("Error while fetching total attachment size for project: {}", (Object)projectId, (Object)ex);
            throw ex;
        }
    }

    private static final List getAllAttachmentsIds$lambda$0(DatabaseConnection db) {
        return ((SQLQuery)db.select((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getID()).from((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE())).fetch();
    }

    private static final List getAttachmentsIdsByProject$lambda$2(long $projectId, DatabaseConnection db) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getID()).from((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE())).join((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getISSUEID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).fetch();
    }

    private static final Long getAttachmentsCountByProject$lambda$4(JiraIssueTable $issueTable, long $projectId, boolean $migrateArchivedIssues, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getID()).from((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE())).join((EntityPath)$issueTable)).on((Predicate)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getISSUEID().eq((Expression)$issueTable.getID()))).where((Predicate)JiraIssueReader.Companion.belongsToProject($projectId, $issueTable, $migrateArchivedIssues))).fetchCount();
    }

    private static final Long getAttachmentsCountByProject$lambda$6(long $projectId, DatabaseConnection db) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getID()).from((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE())).join((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getISSUEID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).fetchCount();
    }

    private static final Long getTotalAttachmentsSizeByProject$lambda$8(long $projectId, DatabaseConnection db) {
        Long l = (Long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getFILESIZE().sum()).from((Expression)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE())).join((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getISSUEID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).fetchOne();
        return l == null ? 0L : l;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ DatabaseAccessor access$getDatabaseAccessor$p(JiraAttachmentReader $this) {
        return $this.databaseAccessor;
    }

    public static final /* synthetic */ SchemaStateProvider access$getSchemaStateProvider$p(JiraAttachmentReader $this) {
        return $this.schemaStateProvider;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/db/core/JiraAttachmentReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

