/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.core;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.common.PaginatedList;
import com.atlassian.jira.migration.db.IssueLinkTable;
import com.atlassian.jira.migration.db.IssueLinkTypeTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.db.JiraIssueTableWithArchivedColumns;
import com.atlassian.jira.migration.db.UserAssociationTable;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.schema.SchemaStateProvider;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\f\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J%\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012JO\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00122\b\b\u0002\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001dH\u0002J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010)\u001a\u00020\u0012J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010+\u001a\u00020\u001dJE\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010-J\u0016\u0010.\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010/\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R!\u0010\t\u001a\u00020\n8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;", "", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "schemaStateProvider", "Lcom/atlassian/pocketknife/api/querydsl/schema/SchemaStateProvider;", "(Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/pocketknife/api/querydsl/schema/SchemaStateProvider;)V", "archivedFieldExists", "", "getArchivedFieldExists$annotations", "()V", "getArchivedFieldExists", "()Z", "archivedFieldExists$delegate", "Lkotlin/Lazy;", "countAllIssuesInProject", "", "projectId", "countNewOrUpdatedIssuesInProject", "startEpochMillis", "endEpochMills", "(JLjava/lang/Long;J)J", "doesProjectContainArchivedIssues", "getAllIdsOfNewOrUpdatedIssuesInProject", "Lkotlin/sequences/Sequence;", "migrateArchivedIssues", "limitPerPage", "", "onProgression", "Lkotlin/Function0;", "", "(JLjava/lang/Long;JZILkotlin/jvm/functions/Function0;)Lkotlin/sequences/Sequence;", "getAllIssueIdsForProject", "getArchivedIssueCountForProject", "getArchivedIssueForProject", "", "offset", "limit", "getChildIssuesForIssue", "issueId", "getIdsOfAllArchivedIssuesForProject", "pageSize", "getIdsOfNewOrUpdatedIssuesInProject", "(JLjava/lang/Long;JIIZ)Ljava/util/Collection;", "getIssueCountForProject", "getMaxIssueNumber", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraIssueReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraIssueReader.kt\ncom/atlassian/jira/migration/export/db/core/JiraIssueReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1#2:395\n*E\n"})
public final class JiraIssueReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final SchemaStateProvider schemaStateProvider;
    @NotNull
    private final Lazy archivedFieldExists$delegate;
    private static final Logger log = LoggerFactory.getLogger(JiraIssueReader.class);

    @Inject
    public JiraIssueReader(@NotNull IssueManager issueManager, @NotNull DatabaseAccessor databaseAccessor, @NotNull SchemaStateProvider schemaStateProvider) {
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)schemaStateProvider, (String)"schemaStateProvider");
        this.issueManager = issueManager;
        this.databaseAccessor = databaseAccessor;
        this.schemaStateProvider = schemaStateProvider;
        this.archivedFieldExists$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ JiraIssueReader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                Object object;
                try {
                    JiraIssueReader.access$getLog$cp().debug("Executing db query to identify if archive field exists in Jira Issue table");
                    object = JiraIssueReader.access$getDatabaseAccessor$p(this.this$0).run(arg_0 -> archivedFieldExists.2.invoke$lambda$1(this.this$0, arg_0), OnRollback.NOOP);
                    Boolean it = (Boolean)object;
                    boolean bl = false;
                    JiraIssueReader.access$getLog$cp().debug("Successfully executed db query to identify if archived field exists in Jira Issue table");
                    object = (Boolean)object;
                }
                catch (Exception ex) {
                    JiraIssueReader.access$getLog$cp().error("Error while executing db query to identify if archived field exists in Jira Issue table", (Throwable)ex);
                    throw ex;
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            private static final Boolean invoke$lambda$1(JiraIssueReader this$0, DatabaseConnection db) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Set set = JiraIssueReader.access$getSchemaStateProvider$p(this$0).getSchemaState(db.getJdbcConnection(), (RelationalPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE()).getAddedColumns();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAddedColumns(...)");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    void var11_11 = it;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string2 = var11_11.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    collection.add(string2);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).contains("archived");
            }
        }));
    }

    public final boolean getArchivedFieldExists() {
        Lazy lazy = this.archivedFieldExists$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Boolean)object;
    }

    @VisibleForTesting
    public static /* synthetic */ void getArchivedFieldExists$annotations() {
    }

    public final boolean doesProjectContainArchivedIssues(long projectId) {
        return this.getArchivedIssueCountForProject(projectId) > 0L;
    }

    @NotNull
    public final Sequence<Long> getAllIssueIdsForProject(long projectId) {
        Collection collection = this.issueManager.getIssueIdsForProject(Long.valueOf(projectId));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getIssueIdsForProject(...)");
        return CollectionsKt.asSequence((Iterable)collection);
    }

    public final long getIssueCountForProject(long projectId, boolean migrateArchivedIssues) {
        JiraIssueTable issueTable = this.getArchivedFieldExists() ? (JiraIssueTable)new JiraIssueTableWithArchivedColumns() : JiraIssueTable.Companion.getJIRA_ISSUE_TABLE();
        try {
            log.debug("Executing db query to fetch issue count associated with project: {} and migrateArchivedIssues: {}", (Object)projectId, (Object)migrateArchivedIssues);
            Object object = this.databaseAccessor.run(arg_0 -> JiraIssueReader.getIssueCountForProject$lambda$0(issueTable, projectId, migrateArchivedIssues, arg_0), OnRollback.NOOP);
            Long it = (Long)object;
            boolean bl = false;
            log.debug("Successfully fetched issue count associated with project: {}", (Object)projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return ((Number)object2).longValue();
        }
        catch (Exception ex) {
            log.error("Error while fetching issue count associated with project: {}", (Object)projectId, (Object)ex);
            throw ex;
        }
    }

    @NotNull
    public final Sequence<Long> getAllIdsOfNewOrUpdatedIssuesInProject(long projectId, @Nullable Long startEpochMillis, long endEpochMills, boolean migrateArchivedIssues, int limitPerPage, @NotNull Function0<Unit> onProgression) {
        Intrinsics.checkNotNullParameter(onProgression, (String)"onProgression");
        if (!(limitPerPage > 0)) {
            boolean $i$a$-require-JiraIssueReader$getAllIdsOfNewOrUpdatedIssuesInProject$42 = false;
            String $i$a$-require-JiraIssueReader$getAllIdsOfNewOrUpdatedIssuesInProject$42 = "limitPerPage must be greater than zero";
            throw new IllegalArgumentException($i$a$-require-JiraIssueReader$getAllIdsOfNewOrUpdatedIssuesInProject$42.toString());
        }
        if (!(startEpochMillis == null || endEpochMills - startEpochMillis > 0L)) {
            boolean $i$a$-require-JiraIssueReader$getAllIdsOfNewOrUpdatedIssuesInProject$52 = false;
            String $i$a$-require-JiraIssueReader$getAllIdsOfNewOrUpdatedIssuesInProject$52 = "startEpochMillis must be before endEpochMills";
            throw new IllegalArgumentException($i$a$-require-JiraIssueReader$getAllIdsOfNewOrUpdatedIssuesInProject$52.toString());
        }
        try {
            Object[] objectArray = new Object[]{projectId, startEpochMillis, endEpochMills, migrateArchivedIssues, limitPerPage};
            log.debug("Executing db query to fetch all ids of new or updated issues in project: {} with startEpochMillis: {}, endEpochMillis: {}, migrateArchivedIssues: {}, limitPerPage: {}", objectArray);
            Object[] it = objectArray = SequencesKt.flatMap((Sequence)SequencesKt.onEach((Sequence)SequencesKt.asSequence(PaginatedList.Companion.fetchByPage(limitPerPage, (Function2)new Function2<Integer, Integer, Collection<? extends Long>>(this, projectId, startEpochMillis, endEpochMills, migrateArchivedIssues){
                final /* synthetic */ JiraIssueReader this$0;
                final /* synthetic */ long $projectId;
                final /* synthetic */ Long $startEpochMillis;
                final /* synthetic */ long $endEpochMills;
                final /* synthetic */ boolean $migrateArchivedIssues;
                {
                    this.this$0 = $receiver;
                    this.$projectId = $projectId;
                    this.$startEpochMillis = $startEpochMillis;
                    this.$endEpochMills = $endEpochMills;
                    this.$migrateArchivedIssues = $migrateArchivedIssues;
                    super(2);
                }

                @NotNull
                public final Collection<Long> invoke(int offset, int limit) {
                    return JiraIssueReader.access$getIdsOfNewOrUpdatedIssuesInProject(this.this$0, this.$projectId, this.$startEpochMillis, this.$endEpochMills, offset, limit, this.$migrateArchivedIssues);
                }
            })), (Function1)((Function1)new Function1<PaginatedList<Long>, Unit>(onProgression){
                final /* synthetic */ Function0<Unit> $onProgression;
                {
                    this.$onProgression = $onProgression;
                    super(1);
                }

                public final void invoke(@NotNull PaginatedList<Long> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.$onProgression.invoke();
                }
            })), (Function1)((Function1)new Function1<PaginatedList<Long>, Sequence<? extends Long>>(onProgression){
                final /* synthetic */ Function0<Unit> $onProgression;
                {
                    this.$onProgression = $onProgression;
                    super(1);
                }

                @NotNull
                public final Sequence<Long> invoke(@NotNull PaginatedList<Long> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)it.getFetched()), (Function1)((Function1)new Function1<Long, Unit>(this.$onProgression){
                        final /* synthetic */ Function0<Unit> $onProgression;
                        {
                            this.$onProgression = $onProgression;
                            super(1);
                        }

                        public final void invoke(long it) {
                            this.$onProgression.invoke();
                        }
                    }));
                }
            }));
            boolean bl = false;
            Object[] objectArray2 = new Object[]{projectId, startEpochMillis, endEpochMills};
            log.debug("Successfully fetched all ids of new or updated issues in project: {} with startEpochMillis: {}, endEpochMillis: {}", objectArray2);
            return objectArray;
        }
        catch (Exception ex) {
            Object[] objectArray = new Object[]{projectId, startEpochMillis, endEpochMills, ex};
            log.error("Error while fetching all ids of new or updated issues in project: {} with startEpochMillis: {}, endEpochMillis: {}", objectArray);
            throw ex;
        }
    }

    public static /* synthetic */ Sequence getAllIdsOfNewOrUpdatedIssuesInProject$default(JiraIssueReader jiraIssueReader, long l, Long l2, long l3, boolean bl, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            n = 1000;
        }
        if ((n2 & 0x20) != 0) {
            function0 = getAllIdsOfNewOrUpdatedIssuesInProject.1.INSTANCE;
        }
        return jiraIssueReader.getAllIdsOfNewOrUpdatedIssuesInProject(l, l2, l3, bl, n, (Function0<Unit>)function0);
    }

    public final long countAllIssuesInProject(long projectId) {
        return this.issueManager.getIssueCountForProject(Long.valueOf(projectId));
    }

    public final long countNewOrUpdatedIssuesInProject(long projectId, @Nullable Long startEpochMillis, long endEpochMills) {
        if (!(startEpochMillis == null || endEpochMills - startEpochMillis > 0L)) {
            boolean $i$a$-require-JiraIssueReader$countNewOrUpdatedIssuesInProject$22 = false;
            String $i$a$-require-JiraIssueReader$countNewOrUpdatedIssuesInProject$22 = "startEpochMillis must be before endEpochMills";
            throw new IllegalArgumentException($i$a$-require-JiraIssueReader$countNewOrUpdatedIssuesInProject$22.toString());
        }
        JiraIssueTable issueTable = this.getArchivedFieldExists() ? (JiraIssueTable)new JiraIssueTableWithArchivedColumns() : JiraIssueTable.Companion.getJIRA_ISSUE_TABLE();
        try {
            Object[] $i$a$-require-JiraIssueReader$countNewOrUpdatedIssuesInProject$22 = new Object[]{projectId, startEpochMillis, endEpochMills};
            log.debug("Executing db query to fetch count of new or updated issues in project: {} with startEpochMillis: {}, endEpochMillis: {}", $i$a$-require-JiraIssueReader$countNewOrUpdatedIssuesInProject$22);
            Object object = this.databaseAccessor.run(arg_0 -> JiraIssueReader.countNewOrUpdatedIssuesInProject$lambda$6(issueTable, projectId, startEpochMillis, endEpochMills, arg_0), OnRollback.NOOP);
            Long it = (Long)object;
            boolean bl = false;
            Object[] objectArray = new Object[]{projectId, startEpochMillis, endEpochMills};
            log.debug("Successfully fetched count of new or updated issues in project: {} with startEpochMillis: {}, endEpochMillis: {}", objectArray);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return ((Number)object2).longValue();
        }
        catch (Exception ex) {
            Object[] objectArray = new Object[]{projectId, startEpochMillis, endEpochMills, ex};
            log.error("Error while fetching count of new or updated issues in project: {} with startEpochMillis: {}, endEpochMillis: {}", objectArray);
            throw ex;
        }
    }

    private final Collection<Long> getIdsOfNewOrUpdatedIssuesInProject(long projectId, Long startEpochMillis, long endEpochMills, int offset, int limit, boolean migrateArchivedIssues) {
        JiraIssueTable issueTable = this.getArchivedFieldExists() ? (JiraIssueTable)new JiraIssueTableWithArchivedColumns() : JiraIssueTable.Companion.getJIRA_ISSUE_TABLE();
        try {
            Object[] objectArray = new Object[]{projectId, offset, limit};
            log.debug("Executing db query to fetch ids of new or updated issues associated with project: {} with offset: {}, limit: {}", objectArray);
            Object object = this.databaseAccessor.run(arg_0 -> JiraIssueReader.getIdsOfNewOrUpdatedIssuesInProject$lambda$8(issueTable, projectId, migrateArchivedIssues, startEpochMillis, endEpochMills, limit, offset, arg_0), OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            Object[] objectArray2 = new Object[]{projectId, offset, limit};
            log.debug("Successfully fetched ids of new or updated issues associated with project: {} with offset: {}, limit: {}", objectArray2);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Collection)object2;
        }
        catch (Exception ex) {
            Object[] objectArray = new Object[]{projectId, offset, limit, ex};
            log.error("Error while fetching ids of new or updated issues associated with project: {} with offset: {}, limit: {}", objectArray);
            throw ex;
        }
    }

    public final long getMaxIssueNumber(long projectId) {
        JiraIssueTable issueTable = new JiraIssueTable(null, 1, null);
        try {
            long l;
            log.debug("Executing db query to fetch max issue number associated with project: {}", (Object)projectId);
            Long l2 = (Long)this.databaseAccessor.run(arg_0 -> JiraIssueReader.getMaxIssueNumber$lambda$10(issueTable, projectId, arg_0), OnRollback.NOOP);
            if (l2 == null) {
                long l3;
                long it = l3 = 0L;
                boolean bl = false;
                log.debug("Successfully fetched max issue number associated with project: {}", (Object)projectId);
                l = l3;
            } else {
                l = l2;
            }
            return l;
        }
        catch (Exception ex) {
            log.error("Error while fetching max issue number associated with project: {}", (Object)projectId, (Object)ex);
            throw ex;
        }
    }

    public final long getArchivedIssueCountForProject(long projectId) {
        long l;
        if (this.getArchivedFieldExists()) {
            Object object;
            JiraIssueTableWithArchivedColumns issueTable = new JiraIssueTableWithArchivedColumns();
            try {
                log.debug("Executing db query to fetch archived issue count associated with project: {}", (Object)projectId);
                object = this.databaseAccessor.run(arg_0 -> JiraIssueReader.getArchivedIssueCountForProject$lambda$12(issueTable, projectId, arg_0), OnRollback.NOOP);
                Long it = (Long)object;
                boolean bl = false;
                log.debug("Successfully fetched archived issue count associated with project: {}", (Object)projectId);
                object = (Long)object;
            }
            catch (Exception ex) {
                log.error("Error while fetching archived issue count associated with project: {}", (Object)projectId, (Object)ex);
                throw ex;
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            l = ((Number)object2).longValue();
        } else {
            l = 0L;
        }
        return l;
    }

    @NotNull
    public final Collection<Long> getIdsOfAllArchivedIssuesForProject(long projectId, int pageSize) {
        if (!(pageSize > 0)) {
            boolean bl = false;
            String string = "pageSize must be greater than zero";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            log.debug("Looking up all archived issues for project: " + projectId);
            return SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.asSequence(PaginatedList.Companion.fetchByPage(pageSize, (Function2)new Function2<Integer, Integer, Collection<? extends Long>>(this, projectId){
                final /* synthetic */ JiraIssueReader this$0;
                final /* synthetic */ long $projectId;
                {
                    this.this$0 = $receiver;
                    this.$projectId = $projectId;
                    super(2);
                }

                @NotNull
                public final Collection<Long> invoke(int offset, int limit) {
                    return JiraIssueReader.access$getArchivedIssueForProject(this.this$0, this.$projectId, offset, limit);
                }
            })), (Function1)getIdsOfAllArchivedIssuesForProject.3.INSTANCE));
        }
        catch (Exception ex) {
            log.error("Error while fetching all ids of archived issues in project: " + projectId, (Throwable)ex);
            throw ex;
        }
    }

    public static /* synthetic */ Collection getIdsOfAllArchivedIssuesForProject$default(JiraIssueReader jiraIssueReader, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        return jiraIssueReader.getIdsOfAllArchivedIssuesForProject(l, n);
    }

    private final Collection<Long> getArchivedIssueForProject(long projectId, int offset, int limit) {
        if (!this.getArchivedFieldExists()) {
            return CollectionsKt.emptyList();
        }
        JiraIssueTableWithArchivedColumns issueTable = new JiraIssueTableWithArchivedColumns();
        try {
            log.debug("Executing db query to fetch ids archived issues associated with project: " + projectId + " with offset: " + offset + ", limit: " + limit);
            Object object = this.databaseAccessor.run(arg_0 -> JiraIssueReader.getArchivedIssueForProject$lambda$15(issueTable, projectId, limit, offset, arg_0), OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            log.debug("Successfully fetched ids of archived issues associated with project: with project: " + projectId + " with offset: " + offset + ", limit: " + limit);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Collection)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching ids of new or updated issues associated with project: with project: " + projectId + " with offset: " + offset + ", limit: " + limit, (Throwable)ex);
            throw ex;
        }
    }

    @NotNull
    public final Sequence<Long> getChildIssuesForIssue(long issueId) {
        try {
            log.debug("Executing db query to fetch child issues associated with issue: {}", (Object)issueId);
            Object object = this.databaseAccessor.run(arg_0 -> JiraIssueReader.getChildIssuesForIssue$lambda$17(issueId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched child issues associated with issue: {}", (Object)issueId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching child issues associated with issue: {}", (Object)issueId, (Object)ex);
            throw ex;
        }
    }

    private static final Long getIssueCountForProject$lambda$0(JiraIssueTable $issueTable, long $projectId, boolean $migrateArchivedIssues, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        return ((SQLQuery)((SQLQuery)db.select((Expression)$issueTable.getID()).from((Expression)$issueTable)).where((Predicate)Companion.belongsToProject($projectId, $issueTable, $migrateArchivedIssues))).fetchCount();
    }

    private static final Long countNewOrUpdatedIssuesInProject$lambda$6(JiraIssueTable $issueTable, long $projectId, Long $startEpochMillis, long $endEpochMills, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)$issueTable.getID()).distinct()).from((Expression)$issueTable)).leftJoin((EntityPath)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE())).on(Companion.associationIsWatcherOrVoterOfIssue($issueTable))).where((Predicate)Companion.belongsToProjectAndNotArchived($projectId, $issueTable).and((Predicate)Companion.issueUpdatedOrAssociatedBetween($issueTable, $startEpochMillis, $endEpochMills)))).fetchCount();
    }

    private static final List getIdsOfNewOrUpdatedIssuesInProject$lambda$8(JiraIssueTable $issueTable, long $projectId, boolean $migrateArchivedIssues, Long $startEpochMillis, long $endEpochMills, int $limit, int $offset, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)$issueTable.getID()).distinct()).from((Expression)$issueTable)).leftJoin((EntityPath)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE())).on(Companion.associationIsWatcherOrVoterOfIssue($issueTable))).where((Predicate)Companion.belongsToProject($projectId, $issueTable, $migrateArchivedIssues).and((Predicate)Companion.issueUpdatedOrAssociatedBetween($issueTable, $startEpochMillis, $endEpochMills)))).orderBy($issueTable.getID().asc())).limit((long)$limit)).offset((long)$offset)).fetch();
    }

    private static final Long getMaxIssueNumber$lambda$10(JiraIssueTable $issueTable, long $projectId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        return (Long)((SQLQuery)((SQLQuery)db.select((Expression)$issueTable.getISSUE_NUMBER().max()).from((Expression)$issueTable)).where((Predicate)$issueTable.getPROJECT().eq((Object)$projectId))).fetchOne();
    }

    private static final Long getArchivedIssueCountForProject$lambda$12(JiraIssueTableWithArchivedColumns $issueTable, long $projectId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        return (Long)((SQLQuery)((SQLQuery)db.select((Expression)$issueTable.getID().count()).from((Expression)$issueTable)).where(Companion.belongsToProjectAndIsArchived($projectId, $issueTable))).fetchOne();
    }

    private static final List getArchivedIssueForProject$lambda$15(JiraIssueTableWithArchivedColumns $issueTable, long $projectId, int $limit, int $offset, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)$issueTable.getID()).distinct()).from((Expression)$issueTable)).where(Companion.belongsToProjectAndIsArchived($projectId, $issueTable))).orderBy($issueTable.getID().asc())).limit((long)$limit)).offset((long)$offset)).fetch();
    }

    private static final Sequence getChildIssuesForIssue$lambda$17(long $issueId, DatabaseConnection db) {
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)IssueLinkTable.INSTANCE.getDESTINATION()).from((Expression)IssueLinkTable.INSTANCE)).innerJoin((EntityPath)IssueLinkTypeTable.INSTANCE)).on((Predicate)IssueLinkTypeTable.INSTANCE.getID().eq((Expression)IssueLinkTable.INSTANCE.getLINK_TYPE()))).where((Predicate)IssueLinkTypeTable.INSTANCE.getLINK_NAME().eq((Object)"Parent-Child Link").and((Predicate)IssueLinkTable.INSTANCE.getSOURCE().eq((Object)$issueId)))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    public static final /* synthetic */ Collection access$getIdsOfNewOrUpdatedIssuesInProject(JiraIssueReader $this, long projectId, Long startEpochMillis, long endEpochMills, int offset, int limit, boolean migrateArchivedIssues) {
        return $this.getIdsOfNewOrUpdatedIssuesInProject(projectId, startEpochMillis, endEpochMills, offset, limit, migrateArchivedIssues);
    }

    public static final /* synthetic */ Collection access$getArchivedIssueForProject(JiraIssueReader $this, long projectId, int offset, int limit) {
        return $this.getArchivedIssueForProject(projectId, offset, limit);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ DatabaseAccessor access$getDatabaseAccessor$p(JiraIssueReader $this) {
        return $this.databaseAccessor;
    }

    public static final /* synthetic */ SchemaStateProvider access$getSchemaStateProvider$p(JiraIssueReader $this) {
        return $this.schemaStateProvider;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0007J%\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "associationIsWatcherOrVoterOfIssue", "Lcom/querydsl/core/types/Predicate;", "issueTable", "Lcom/atlassian/jira/migration/db/JiraIssueTable;", "belongsToProject", "Lcom/querydsl/core/types/dsl/BooleanExpression;", "projectId", "", "migrateArchivedIssues", "", "belongsToProjectAndIsArchived", "Lcom/atlassian/jira/migration/db/JiraIssueTableWithArchivedColumns;", "belongsToProjectAndNotArchived", "issueUpdatedOrAssociatedBetween", "startEpochMillis", "endEpochMills", "(Lcom/atlassian/jira/migration/db/JiraIssueTable;Ljava/lang/Long;J)Lcom/querydsl/core/types/dsl/BooleanExpression;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final BooleanExpression belongsToProjectAndNotArchived(long projectId, @NotNull JiraIssueTable issueTable) {
            BooleanExpression booleanExpression;
            Intrinsics.checkNotNullParameter((Object)((Object)issueTable), (String)"issueTable");
            if (issueTable instanceof JiraIssueTableWithArchivedColumns) {
                BooleanExpression[] booleanExpressionArray = new BooleanExpression[]{((JiraIssueTableWithArchivedColumns)issueTable).getARCHIVED().isNull(), ((JiraIssueTableWithArchivedColumns)issueTable).getARCHIVED().eq((Object)"N")};
                BooleanExpression booleanExpression2 = issueTable.getPROJECT().eq((Object)projectId).and((Predicate)Expressions.anyOf((BooleanExpression[])booleanExpressionArray));
                booleanExpression = booleanExpression2;
                Intrinsics.checkNotNullExpressionValue((Object)booleanExpression2, (String)"and(...)");
            } else {
                BooleanExpression booleanExpression3 = issueTable.getPROJECT().eq((Object)projectId);
                booleanExpression = booleanExpression3;
                Intrinsics.checkNotNullExpressionValue((Object)booleanExpression3, (String)"eq(...)");
            }
            return booleanExpression;
        }

        @NotNull
        public final BooleanExpression belongsToProject(long projectId, @NotNull JiraIssueTable issueTable, boolean migrateArchivedIssues) {
            BooleanExpression booleanExpression;
            Intrinsics.checkNotNullParameter((Object)((Object)issueTable), (String)"issueTable");
            if (migrateArchivedIssues) {
                BooleanExpression booleanExpression2 = issueTable.getPROJECT().eq((Object)projectId);
                booleanExpression = booleanExpression2;
                Intrinsics.checkNotNullExpressionValue((Object)booleanExpression2, (String)"eq(...)");
            } else {
                booleanExpression = this.belongsToProjectAndNotArchived(projectId, issueTable);
            }
            return booleanExpression;
        }

        @NotNull
        public final BooleanExpression issueUpdatedOrAssociatedBetween(@NotNull JiraIssueTable issueTable, @Nullable Long startEpochMillis, long endEpochMills) {
            BooleanExpression booleanExpression;
            Intrinsics.checkNotNullParameter((Object)((Object)issueTable), (String)"issueTable");
            if (startEpochMillis != null) {
                Timestamp startInclusive = new Timestamp(startEpochMillis);
                Timestamp endInclusive = new Timestamp(endEpochMills - 1L);
                BooleanExpression booleanExpression2 = issueTable.getUPDATED().between((Comparable)startInclusive, (Comparable)endInclusive).or((Predicate)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getCREATED().between((Comparable)startInclusive, (Comparable)endInclusive));
                Intrinsics.checkNotNull((Object)booleanExpression2);
                booleanExpression = booleanExpression2;
            } else {
                Timestamp endExclusive = new Timestamp(endEpochMills);
                BooleanExpression booleanExpression3 = issueTable.getUPDATED().before((Comparable)endExclusive).or((Predicate)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getCREATED().before((Comparable)endExclusive));
                Intrinsics.checkNotNull((Object)booleanExpression3);
                booleanExpression = booleanExpression3;
            }
            return booleanExpression;
        }

        @NotNull
        public final Predicate associationIsWatcherOrVoterOfIssue(@NotNull JiraIssueTable issueTable) {
            Intrinsics.checkNotNullParameter((Object)((Object)issueTable), (String)"issueTable");
            BooleanExpression booleanExpression = issueTable.getID().eq((Expression)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getSINK_NODE_ID()).and((Predicate)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getASSOCIATION_TYPE().eq((Object)"WatchIssue").or((Predicate)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getASSOCIATION_TYPE().eq((Object)"VoteIssue")));
            Intrinsics.checkNotNullExpressionValue((Object)booleanExpression, (String)"and(...)");
            return (Predicate)booleanExpression;
        }

        @NotNull
        public final Predicate belongsToProjectAndIsArchived(long projectId, @NotNull JiraIssueTableWithArchivedColumns issueTable) {
            Intrinsics.checkNotNullParameter((Object)((Object)issueTable), (String)"issueTable");
            BooleanExpression booleanExpression = issueTable.getPROJECT().eq((Object)projectId).and((Predicate)issueTable.getARCHIVED().eq((Object)"Y"));
            Intrinsics.checkNotNullExpressionValue((Object)booleanExpression, (String)"and(...)");
            return (Predicate)booleanExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

