/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.core;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.export.db.core.RemoteLinkTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/export/db/core/RemoteLinkReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getAllRemoteLinksForProject", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/issue/link/RemoteIssueLink;", "projectId", "", "Companion", "jira-migration-plugin"})
public final class RemoteLinkReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(RemoteLinkReader.class);

    @Inject
    public RemoteLinkReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @NotNull
    public final Sequence<RemoteIssueLink> getAllRemoteLinksForProject(long projectId) {
        try {
            log.debug("Executing db query to fetch all remote links associated with project: {}", (Object)projectId);
            Object object = this.databaseAccessor.run(arg_0 -> RemoteLinkReader.getAllRemoteLinksForProject$lambda$0(projectId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched all remote links associated with project: {}", (Object)projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching all remote links associated with project: {}", (Object)projectId, (Object)ex);
            throw ex;
        }
    }

    private static final Sequence getAllRemoteLinksForProject$lambda$0(long $projectId, DatabaseConnection db) {
        Path[] pathArray = RemoteLinkTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)RemoteLinkTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).on((Predicate)RemoteLinkTable.INSTANCE.getISSUE_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()));
        pathArray = new OrderSpecifier[]{RemoteLinkTable.INSTANCE.getGLOBAL_ID().asc(), RemoteLinkTable.INSTANCE.getID().asc()};
        List list = ((SQLQuery)sQLQuery.orderBy((OrderSpecifier[])pathArray)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, RemoteIssueLink>((Object)Companion){

            @NotNull
            public final RemoteIssueLink invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildRemoteIssueLink(p0);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/export/db/core/RemoteLinkReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildRemoteIssueLink", "Lcom/atlassian/jira/issue/link/RemoteIssueLink;", "row", "Lcom/querydsl/core/Tuple;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final RemoteIssueLink buildRemoteIssueLink(@NotNull Tuple row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            return new RemoteIssueLink((Long)row.get((Expression)RemoteLinkTable.INSTANCE.getID()), (Long)row.get((Expression)RemoteLinkTable.INSTANCE.getISSUE_ID()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getGLOBAL_ID()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getTITLE()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getSUMMARY()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getURL()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getICON_URL()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getICON_TITLE()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getRELATIONSHIP()), (Boolean)row.get((Expression)RemoteLinkTable.INSTANCE.getRESOLVED()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getSTATUS_ICON_URL()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getSTATUS_ICON_TITLE()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getSTATUS_ICON_LINK()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getAPPLICATION_TYPE()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getAPPLICATION_NAME()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getSTATUS_NAME()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getSTATUS_DESCRIPTION()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getSTATUS_CATEGORY_KEY()), (String)row.get((Expression)RemoteLinkTable.INSTANCE.getSTATUS_CATEGORY_COLOR_NAME()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

