/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.core;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.migration.db.SharePermissionsTable;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/export/db/core/SharedFilterIdsReader;", "", "dbAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "fetchNonProjectSharedFilterIds", "", "", "offset", "", "limit", "fetchSharedFilterIdsForProject", "project", "Lcom/atlassian/jira/project/Project;", "fetchSharedProjectsForFilter", "filterId", "isProject", "Lcom/querydsl/core/types/dsl/BooleanExpression;", "sharePermissionsTable", "Lcom/atlassian/jira/migration/db/SharePermissionsTable;", "isSearchRequest", "isSharedToProject", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSharedFilterIdsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedFilterIdsReader.kt\ncom/atlassian/jira/migration/export/db/core/SharedFilterIdsReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n*S KotlinDebug\n*F\n+ 1 SharedFilterIdsReader.kt\ncom/atlassian/jira/migration/export/db/core/SharedFilterIdsReader\n*L\n97#1:125\n97#1:126,3\n*E\n"})
public final class SharedFilterIdsReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor dbAccessor;
    private static final Logger log = LoggerFactory.getLogger(SharedFilterIdsReader.class);

    @Inject
    public SharedFilterIdsReader(@NotNull DatabaseAccessor dbAccessor) {
        Intrinsics.checkNotNullParameter((Object)dbAccessor, (String)"dbAccessor");
        this.dbAccessor = dbAccessor;
    }

    @NotNull
    public final List<Long> fetchNonProjectSharedFilterIds(int offset, int limit) {
        try {
            log.debug("Executing db query to fetch non project shared filter IDs [offset=" + offset + ", limit=" + limit + ']');
            Object object = this.dbAccessor.run(arg_0 -> SharedFilterIdsReader.fetchNonProjectSharedFilterIds$lambda$0(this, offset, limit, arg_0), OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            log.debug("Successfully fetched non project shared filter IDs [offset=" + offset + ", limit=" + limit + ']');
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching non project shared filter IDs [offset=" + offset + ", limit=" + limit + ']', (Throwable)ex);
            throw ex;
        }
    }

    @NotNull
    public final List<Long> fetchSharedFilterIdsForProject(@NotNull Project project, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            log.debug("Executing db query to fetch shared filter ids associated with project " + project.getKey() + " and project id " + project.getId() + " with offset=" + offset + ", limit=" + limit);
            Object object = this.dbAccessor.run(arg_0 -> SharedFilterIdsReader.fetchSharedFilterIdsForProject$lambda$2(this, project, offset, limit, arg_0), OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            log.debug("Successfully fetched shared filter ids associated with project " + project.getKey() + " and project id " + project.getId() + " with offset=" + offset + ", limit=" + limit);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (Exception ex) {
            log.error("Executing db query to fetch shared filter ids associated with project " + project.getKey() + " and project id " + project.getId() + " with offset=" + offset + ", limit=" + limit, (Throwable)ex);
            throw ex;
        }
    }

    @NotNull
    public final List<Long> fetchSharedProjectsForFilter(long filterId) {
        try {
            log.debug("Executing db query to fetch shared projects for filter ID " + filterId);
            Object object = this.dbAccessor.run(arg_0 -> SharedFilterIdsReader.fetchSharedProjectsForFilter$lambda$5(this, filterId, arg_0), OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            log.debug("Successfully fetched shared projects for filter ID " + filterId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching shared projects for filter ID " + filterId, (Throwable)ex);
            throw ex;
        }
    }

    private final BooleanExpression isSearchRequest(SharePermissionsTable sharePermissionsTable) {
        BooleanExpression booleanExpression = sharePermissionsTable.getENTITYTYPE().eq((Object)SearchRequest.ENTITY_TYPE.getName());
        Intrinsics.checkNotNullExpressionValue((Object)booleanExpression, (String)"eq(...)");
        return booleanExpression;
    }

    private final BooleanExpression isProject(SharePermissionsTable sharePermissionsTable) {
        BooleanExpression booleanExpression = sharePermissionsTable.getSHARETYPE().eq((Object)ShareType.Name.PROJECT.get());
        Intrinsics.checkNotNullExpressionValue((Object)booleanExpression, (String)"eq(...)");
        return booleanExpression;
    }

    private final BooleanExpression isSharedToProject(SharePermissionsTable sharePermissionsTable, Project project) {
        BooleanExpression booleanExpression = sharePermissionsTable.getPARAM1().eq((Object)String.valueOf(project.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)booleanExpression, (String)"eq(...)");
        return booleanExpression;
    }

    private static final List fetchNonProjectSharedFilterIds$lambda$0(SharedFilterIdsReader this$0, int $offset, int $limit, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE().getENTITYID()).distinct()).from((Expression)SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE())).where((Predicate)this$0.isSearchRequest(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE()).and((Predicate)this$0.isProject(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE()).not()))).orderBy(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE().getENTITYID().asc())).offset((long)$offset)).limit((long)$limit)).fetch();
    }

    private static final List fetchSharedFilterIdsForProject$lambda$2(SharedFilterIdsReader this$0, Project $project, int $offset, int $limit, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE().getENTITYID()).distinct()).from((Expression)SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE())).where((Predicate)this$0.isSearchRequest(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE()).and((Predicate)this$0.isProject(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE())).and((Predicate)this$0.isSharedToProject(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE(), $project)))).orderBy(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE().getENTITYID().asc())).offset((long)$offset)).limit((long)$limit)).fetch();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchSharedProjectsForFilter$lambda$5(SharedFilterIdsReader this$0, long $filterId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE().getPARAM1()).distinct()).from((Expression)SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE())).where((Predicate)this$0.isSearchRequest(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE()).and((Predicate)this$0.isProject(SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE())).and((Predicate)SharePermissionsTable.Companion.getSHARE_PERMISSIONS_TABLE().getENTITYID().eq((Object)$filterId)))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(Long.parseLong((String)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/db/core/SharedFilterIdsReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

