/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.core;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.db.UserAssociationTable;
import com.atlassian.jira.migration.export.db.core.UserAssociationData;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/export/db/core/UserAssociationReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getAllUserAssociationsForProject", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/export/db/core/UserAssociationData;", "projectId", "", "Companion", "jira-migration-plugin"})
public final class UserAssociationReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(UserAssociationReader.class);
    @NotNull
    private static final String ISSUE_SINK_NODE_ENTITY = "Issue";
    @NotNull
    public static final String VOTER_ASSOCIATION_TYPE = "VoteIssue";
    @NotNull
    public static final String WATCHER_ASSOCIATION_TYPE = "WatchIssue";

    @Inject
    public UserAssociationReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @NotNull
    public final Sequence<UserAssociationData> getAllUserAssociationsForProject(long projectId) {
        try {
            log.debug("Executing db query to fetch all user associations for project " + projectId);
            Object object = this.databaseAccessor.run(arg_0 -> UserAssociationReader.getAllUserAssociationsForProject$lambda$0(projectId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched all user associations for project " + projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching all user associations for project " + projectId, (Throwable)ex);
            throw ex;
        }
    }

    private static final Sequence getAllUserAssociationsForProject$lambda$0(long $projectId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getSOURCE_NAME(), UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getSINK_NODE_ID(), UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getASSOCIATION_TYPE()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE())).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getSINK_NODE_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId).and((Predicate)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getSINK_NODE_ENTITY().eq((Object)ISSUE_SINK_NODE_ENTITY)))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, UserAssociationData>((Object)Companion){

            @Nullable
            public final UserAssociationData invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return com.atlassian.jira.migration.export.db.core.UserAssociationReader$Companion.access$buildUserAssociationData((Companion)this.receiver, p0);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/db/core/UserAssociationReader$Companion;", "", "()V", "ISSUE_SINK_NODE_ENTITY", "", "VOTER_ASSOCIATION_TYPE", "WATCHER_ASSOCIATION_TYPE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildUserAssociationData", "Lcom/atlassian/jira/migration/export/db/core/UserAssociationData;", "row", "Lcom/querydsl/core/Tuple;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        private final UserAssociationData buildUserAssociationData(Tuple row) {
            Object object;
            try {
                boolean bl = false;
                Object object2 = row.get((Expression)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getSOURCE_NAME());
                Intrinsics.checkNotNull((Object)object2);
                String string = (String)object2;
                Object object3 = row.get((Expression)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getSINK_NODE_ID());
                Intrinsics.checkNotNull((Object)object3);
                long l = ((Number)object3).longValue();
                Object object4 = row.get((Expression)UserAssociationTable.Companion.getUSER_ASSOCIATION_TABLE().getASSOCIATION_TYPE());
                Intrinsics.checkNotNull((Object)object4);
                object = Result.constructor-impl((Object)new UserAssociationData(string, l, (String)object4));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            return (UserAssociationData)(Result.isFailure-impl((Object)object) ? null : object);
        }

        public static final /* synthetic */ UserAssociationData access$buildUserAssociationData(Companion $this, Tuple row) {
            return $this.buildUserAssociationData(row);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

