/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.schema.DialectProvider;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000f\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"MIN_AFFECTED_DB_VER", "", "ORACLE_PARAM_LIMIT", "bigIn", "Lcom/querydsl/core/types/dsl/BooleanExpression;", "T", "Lcom/querydsl/core/types/dsl/SimpleExpression;", "collection", "", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "clobToVarchar", "Lcom/querydsl/core/types/dsl/StringExpression;", "Lcom/querydsl/core/types/dsl/StringPath;", "useLiteralsInsteadOfQueryParameters", "Lcom/querydsl/sql/SQLQuery;", "jira-migration-plugin"})
public final class QuerydslHelpersKt {
    private static final int MIN_AFFECTED_DB_VER = 9;
    private static final int ORACLE_PARAM_LIMIT = 1000;

    @NotNull
    public static final StringExpression clobToVarchar(@NotNull StringPath $this$clobToVarchar, @NotNull DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$this$clobToVarchar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        if (db.getDialectConfig().getDatabaseInfo().getSupportedDatabase() == DialectProvider.SupportedDatabase.ORACLE) {
            StringTemplate stringTemplate = Expressions.stringTemplate((String)("dbms_lob.substr(" + $this$clobToVarchar.getMetadata().getName() + ", 4000, 1)"), (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)stringTemplate, (String)"stringTemplate(...)");
            return (StringExpression)stringTemplate;
        }
        if (db.getDialectConfig().getDatabaseInfo().getSupportedDatabase() == DialectProvider.SupportedDatabase.SQLSERVER && db.getDialectConfig().getDatabaseInfo().getDatabaseMajorVersion() >= 9) {
            StringTemplate stringTemplate = Expressions.stringTemplate((String)("CAST (" + $this$clobToVarchar.getMetadata().getName() + " AS NVARCHAR(MAX))"), (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)stringTemplate, (String)"stringTemplate(...)");
            return (StringExpression)stringTemplate;
        }
        return (StringExpression)$this$clobToVarchar;
    }

    @NotNull
    public static final <T> BooleanExpression bigIn(@NotNull SimpleExpression<T> $this$bigIn, @NotNull Collection<? extends T> collection, @NotNull DatabaseConnection db) {
        BooleanExpression booleanExpression;
        Intrinsics.checkNotNullParameter($this$bigIn, (String)"<this>");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        if (db.getDialectConfig().getDatabaseInfo().getSupportedDatabase() == DialectProvider.SupportedDatabase.ORACLE && collection.size() > 999) {
            List chunks = CollectionsKt.chunked((Iterable)CollectionsKt.toList((Iterable)collection), (int)998);
            BooleanExpression booleanExpression2 = $this$bigIn.in((Collection)chunks.get(0));
            Intrinsics.checkNotNullExpressionValue((Object)booleanExpression2, (String)"in(...)");
            BooleanExpression inClause = booleanExpression2;
            int n = chunks.size();
            for (int i = 1; i < n; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)inClause.or((Predicate)$this$bigIn.in((Collection)chunks.get(i))), (String)"or(...)");
            }
            booleanExpression = inClause;
        } else {
            BooleanExpression booleanExpression3 = $this$bigIn.in(collection);
            Intrinsics.checkNotNull((Object)booleanExpression3);
            booleanExpression = booleanExpression3;
        }
        return booleanExpression;
    }

    @NotNull
    public static final <T> SQLQuery<T> useLiteralsInsteadOfQueryParameters(@NotNull SQLQuery<T> $this$useLiteralsInsteadOfQueryParameters) {
        Intrinsics.checkNotNullParameter($this$useLiteralsInsteadOfQueryParameters, (String)"<this>");
        $this$useLiteralsInsteadOfQueryParameters.setUseLiterals(true);
        return $this$useLiteralsInsteadOfQueryParameters;
    }
}

