/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.servicedesk.approval;

import com.atlassian.jira.migration.export.db.servicedesk.approval.ApprovalData;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApproverConfigurationData;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApproverDecisionData;
import com.atlassian.jira.migration.export.db.servicedesk.approval.IssueStatusTable;
import com.atlassian.jira.migration.export.db.servicedesk.approval.schema.QApproval;
import com.atlassian.jira.migration.export.db.servicedesk.approval.schema.QApprover;
import com.atlassian.jira.migration.export.db.servicedesk.approval.schema.QApproverDecision;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getAllApprovalsByIssueId", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalData;", "issueId", "", "getApprovalById", "Lcom/querydsl/core/Tuple;", "approvalId", "", "getApproverConfigurationsForApproval", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApproverConfigurationData;", "getApproverDecisionsForApproval", "Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApproverDecisionData;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nApprovalReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApprovalReader.kt\ncom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1603#2,9:158\n1855#2:167\n1856#2:169\n1612#2:170\n1603#2,9:171\n1855#2:180\n1856#2:183\n1612#2:184\n1549#2:185\n1620#2,2:186\n1622#2:189\n1#3:168\n1#3:181\n1#3:182\n1#3:188\n*S KotlinDebug\n*F\n+ 1 ApprovalReader.kt\ncom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalReader\n*L\n75#1:158,9\n75#1:167\n75#1:169\n75#1:170\n99#1:171,9\n99#1:180\n99#1:183\n99#1:184\n133#1:185\n133#1:186,2\n133#1:189\n75#1:168\n99#1:182\n*E\n"})
public final class ApprovalReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public ApprovalReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @Nullable
    public final Tuple getApprovalById(int approvalId) {
        return (Tuple)this.databaseAccessor.run(arg_0 -> ApprovalReader.getApprovalById$lambda$0(approvalId, arg_0), OnRollback.NOOP);
    }

    @NotNull
    public final List<ApproverConfigurationData> getApproverConfigurationsForApproval(int approvalId) {
        Object object = this.databaseAccessor.run(arg_0 -> ApprovalReader.getApproverConfigurationsForApproval$lambda$2(approvalId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @NotNull
    public final List<ApproverDecisionData> getApproverDecisionsForApproval(int approvalId) {
        Object object = this.databaseAccessor.run(arg_0 -> ApprovalReader.getApproverDecisionsForApproval$lambda$5(approvalId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @NotNull
    public final Set<ApprovalData> getAllApprovalsByIssueId(long issueId) {
        Object object = this.databaseAccessor.run(arg_0 -> ApprovalReader.getAllApprovalsByIssueId$lambda$8(issueId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Set)object;
    }

    private static final Tuple getApprovalById$lambda$0(int $approvalId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{QApproval.INSTANCE.getID(), QApproval.INSTANCE.getAPPROVE_CONDITION_TYPE(), QApproval.INSTANCE.getAPPROVE_CONDITION_VALUE(), QApproval.INSTANCE.getCOMPLETED_DATE(), QApproval.INSTANCE.getDECISION(), QApproval.INSTANCE.getSYSTEM_DECIDED()};
        return (Tuple)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)QApproval.INSTANCE)).where((Predicate)QApproval.INSTANCE.getID().eq((Object)$approvalId))).fetchOne();
    }

    /*
     * WARNING - void declaration
     */
    private static final List getApproverConfigurationsForApproval$lambda$2(int $approvalId, DatabaseConnection db) {
        void $this$mapNotNullTo$iv$iv;
        Expression[] expressionArray = new Expression[]{QApprover.INSTANCE.getID(), QApprover.INSTANCE.getTYPE(), QApprover.INSTANCE.getVALUE()};
        List list = ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)QApprover.INSTANCE)).where((Predicate)QApprover.INSTANCE.getAPPROVAL_ID().eq((Object)$approvalId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple tuple = (Tuple)element$iv$iv;
            boolean bl2 = false;
            Object object = tuple.get((Expression)QApprover.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            Object object2 = tuple.get((Expression)QApprover.INSTANCE.getTYPE());
            Intrinsics.checkNotNull((Object)object2);
            String string = (String)object2;
            Object object3 = tuple.get((Expression)QApprover.INSTANCE.getVALUE());
            Intrinsics.checkNotNull((Object)object3);
            ApproverConfigurationData it$iv$iv = new ApproverConfigurationData(n, string, (String)object3);
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final List getApproverDecisionsForApproval$lambda$5(int $approvalId, DatabaseConnection db) {
        void $this$mapNotNullTo$iv$iv;
        Expression[] expressionArray = new Expression[]{QApproverDecision.INSTANCE.getID(), QApproverDecision.INSTANCE.getDECISION(), QApproverDecision.INSTANCE.getUSER_KEY(), QApproverDecision.INSTANCE.getSENT_DATE()};
        List list = ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)QApproverDecision.INSTANCE)).where((Predicate)QApproverDecision.INSTANCE.getAPPROVAL_ID().eq((Object)$approvalId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Instant instant;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple tuple = (Tuple)element$iv$iv;
            boolean bl2 = false;
            Object object = tuple.get((Expression)QApproverDecision.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            Object object2 = tuple.get((Expression)QApproverDecision.INSTANCE.getDECISION());
            Intrinsics.checkNotNull((Object)object2);
            String string = (String)object2;
            Object object3 = tuple.get((Expression)QApproverDecision.INSTANCE.getUSER_KEY());
            Intrinsics.checkNotNull((Object)object3);
            String string2 = (String)object3;
            Object object4 = tuple.get((Expression)QApproverDecision.INSTANCE.getSENT_DATE());
            Intrinsics.checkNotNull((Object)object4);
            Long l = (Long)object4;
            String string3 = string2;
            String string4 = string;
            int n2 = n;
            boolean bl3 = false;
            Object object5 = tuple.get((Expression)QApproverDecision.INSTANCE.getSENT_DATE());
            Intrinsics.checkNotNull((Object)object5);
            Instant instant2 = Instant.ofEpochMilli(((Number)object5).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"let(...)");
            String string5 = string3;
            String string6 = string4;
            int n3 = n2;
            ApproverDecisionData it$iv$iv = new ApproverDecisionData(n3, string6, string5, instant);
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set getAllApprovalsByIssueId$lambda$8(long $issueId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        Expression[] expressionArray = new Expression[]{QApproval.INSTANCE.getID(), QApproval.INSTANCE.getISSUE_ID(), QApproval.INSTANCE.getAPPROVE_CONDITION_TYPE(), QApproval.INSTANCE.getAPPROVE_CONDITION_VALUE(), QApproval.INSTANCE.getCOMPLETED_DATE(), QApproval.INSTANCE.getCREATED_DATE(), QApproval.INSTANCE.getDECISION(), QApproval.INSTANCE.getNAME(), QApproval.INSTANCE.getSTATUS_ID(), QApproval.INSTANCE.getSYSTEM_DECIDED()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)QApproval.INSTANCE)).innerJoin((EntityPath)IssueStatusTable.INSTANCE)).on((Predicate)IssueStatusTable.INSTANCE.getID().eq((Expression)QApproval.INSTANCE.getSTATUS_ID()))).where((Predicate)QApproval.INSTANCE.getISSUE_ID().eq((Object)$issueId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)list);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Instant instant;
            Instant instant2;
            void tuple;
            Tuple tuple2 = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = tuple.get((Expression)QApproval.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object);
            int n = ((Number)object).intValue();
            Object object2 = tuple.get((Expression)QApproval.INSTANCE.getISSUE_ID());
            Intrinsics.checkNotNull((Object)object2);
            long l = ((Number)object2).longValue();
            Object object3 = tuple.get((Expression)QApproval.INSTANCE.getAPPROVE_CONDITION_TYPE());
            Intrinsics.checkNotNull((Object)object3);
            String string = (String)object3;
            Object object4 = tuple.get((Expression)QApproval.INSTANCE.getAPPROVE_CONDITION_VALUE());
            Intrinsics.checkNotNull((Object)object4);
            String string2 = (String)object4;
            if ((Long)tuple.get((Expression)QApproval.INSTANCE.getCOMPLETED_DATE()) != null) {
                String string3 = string2;
                String string4 = string;
                long l2 = l;
                int n2 = n;
                boolean bl2 = false;
                Object object5 = tuple.get((Expression)QApproval.INSTANCE.getCOMPLETED_DATE());
                Intrinsics.checkNotNull((Object)object5);
                Instant instant3 = Instant.ofEpochMilli(((Number)object5).longValue());
                n = n2;
                l = l2;
                string = string4;
                string2 = string3;
                instant2 = instant3;
            } else {
                instant2 = null;
            }
            Object object6 = tuple.get((Expression)QApproval.INSTANCE.getCREATED_DATE());
            Intrinsics.checkNotNull((Object)object6);
            Intrinsics.checkNotNullExpressionValue((Object)Instant.ofEpochMilli(((Number)object6).longValue()), (String)"ofEpochMilli(...)");
            String string5 = (String)tuple.get((Expression)QApproval.INSTANCE.getDECISION());
            Object object7 = tuple.get((Expression)QApproval.INSTANCE.getNAME());
            Intrinsics.checkNotNull((Object)object7);
            String string6 = (String)object7;
            Object object8 = tuple.get((Expression)QApproval.INSTANCE.getSTATUS_ID());
            Intrinsics.checkNotNull((Object)object8);
            Boolean bl3 = (Boolean)tuple.get((Expression)QApproval.INSTANCE.getSYSTEM_DECIDED());
            int n3 = ((Number)object8).intValue();
            String string7 = string6;
            String string8 = string5;
            Instant instant4 = instant2;
            String string9 = string2;
            String string10 = string;
            long l3 = l;
            int n4 = n;
            collection.add(new ApprovalData(n4, l3, string10, string9, instant4, instant, string8, string7, n3, bl3));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

