/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.servicedesk.lingo;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoTranslationData;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoTranslationField;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoTranslationsWrapper;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LogicalId;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.Tables;
import com.atlassian.jira.migration.export.db.servicedesk.notification.LingoCategory;
import com.atlassian.jira.migration.export.db.servicedesk.notification.LingoRevision;
import com.atlassian.jira.migration.export.servicedesk.requesttype.RequestTypeExporterUtils;
import com.atlassian.jira.project.Project;
import com.atlassian.migration.jira.servicedesk.lingo.TranslationFieldUpdate;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002JV\u0010\r\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000e0\u000e2\u0006\u0010\n\u001a\u00020\u000b2&\u0010\u0011\u001a\"\u0012\u0004\u0012\u00020\u000f\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000e0\u000eH\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\bH\u0002J6\u0010\u0017\u001a\"\u0012\u0004\u0012\u00020\u000f\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000e0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\bH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "requestTypeExporterUtils", "Lcom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeExporterUtils;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeExporterUtils;)V", "filterInvalidRequestTypeFields", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationField;", "project", "Lcom/atlassian/jira/project/Project;", "requestTypeFields", "getFiltersTranslationsMap", "", "", "Lcom/atlassian/migration/jira/servicedesk/lingo/TranslationFieldUpdate$Entity;", "lingoToTranslationFieldMap", "getLingoTranslationForProject", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationsWrapper;", "getLingoTranslationWrapper", "lingoTranslations", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationData;", "groupByLanguageAndEntityType", "readLingoTranslationForProject", "projectId", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nLingoTranslationReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LingoTranslationReader.kt\ncom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationReader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,272:1\n135#2,9:273\n215#2:282\n125#2:283\n152#2,3:284\n216#2:288\n144#2:289\n1#3:287\n1#3:347\n1855#4:290\n1855#4,2:291\n1856#4:293\n1477#4:294\n1502#4,3:295\n1505#4,3:305\n1238#4,2:310\n1549#4:312\n1620#4,3:313\n1477#4:316\n1502#4,3:317\n1505#4,3:327\n1241#4:330\n766#4:331\n857#4,2:332\n766#4:334\n857#4,2:335\n1603#4,9:337\n1855#4:346\n1856#4:348\n1612#4:349\n372#5,7:298\n453#5:308\n403#5:309\n372#5,7:320\n*S KotlinDebug\n*F\n+ 1 LingoTranslationReader.kt\ncom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationReader\n*L\n120#1:273,9\n120#1:282\n121#1:283\n121#1:284,3\n120#1:288\n120#1:289\n120#1:287\n97#1:347\n137#1:290\n139#1:291,2\n137#1:293\n155#1:294\n155#1:295,3\n155#1:305,3\n156#1:310,2\n157#1:312\n157#1:313,3\n165#1:316\n165#1:317,3\n165#1:327,3\n156#1:330\n173#1:331\n173#1:332,2\n89#1:334\n89#1:335,2\n97#1:337,9\n97#1:346\n97#1:348\n97#1:349\n155#1:298,7\n156#1:308\n156#1:309\n165#1:320,7\n*E\n"})
public final class LingoTranslationReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final RequestTypeExporterUtils requestTypeExporterUtils;
    @NotNull
    private static final String SERVER_LOGICAL_ID_PREFIX = "jsds";
    @NotNull
    private static final Map<String, TranslationFieldUpdate.Entity> logicalIdToEntityTypeMap;
    private static final int MIN_LOGICAL_ID_FIELDS = 3;
    private static final Logger log;

    @Inject
    public LingoTranslationReader(@NotNull DatabaseAccessor databaseAccessor, @NotNull RequestTypeExporterUtils requestTypeExporterUtils) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)requestTypeExporterUtils, (String)"requestTypeExporterUtils");
        this.databaseAccessor = databaseAccessor;
        this.requestTypeExporterUtils = requestTypeExporterUtils;
    }

    @NotNull
    public final List<LingoTranslationsWrapper> getLingoTranslationForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Long l = project.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        List<LingoTranslationData> translationData = this.readLingoTranslationForProject(((Number)l).longValue());
        return this.getLingoTranslationWrapper(project, translationData);
    }

    private final List<LingoTranslationData> readLingoTranslationForProject(long projectId) {
        Object object = this.databaseAccessor.run(arg_0 -> LingoTranslationReader.readLingoTranslationForProject$lambda$2(projectId, arg_0), LingoTranslationReader::readLingoTranslationForProject$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LingoTranslationsWrapper> getLingoTranslationWrapper(Project project, List<LingoTranslationData> lingoTranslations) {
        void $this$mapNotNullTo$iv$iv;
        Map<String, Map<TranslationFieldUpdate.Entity, List<LingoTranslationField>>> filteredMap;
        Map<String, Map<TranslationFieldUpdate.Entity, List<LingoTranslationField>>> lingoToTranslationFieldMap = this.groupByLanguageAndEntityType(lingoTranslations);
        Map<String, Map<TranslationFieldUpdate.Entity, List<LingoTranslationField>>> $this$mapNotNull$iv = filteredMap = this.getFiltersTranslationsMap(project, lingoToTranslationFieldMap);
        boolean $i$f$mapNotNull = false;
        Map<String, Map<TranslationFieldUpdate.Entity, List<LingoTranslationField>>> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Map fieldUpdates;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String languageTag = (String)entry.getKey();
            Map $this$map$iv = fieldUpdates = (Map)entry.getValue();
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Long l = project.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                collection.add(new LingoTranslationsWrapper(((Number)l).longValue(), languageTag, (List)it.getValue()));
            }
            List it$iv$iv = (List)destination$iv$iv2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    private final Map<String, Map<TranslationFieldUpdate.Entity, List<LingoTranslationField>>> getFiltersTranslationsMap(Project project, Map<String, ? extends Map<TranslationFieldUpdate.Entity, ? extends List<LingoTranslationField>>> lingoToTranslationFieldMap) {
        HashMap filteredMap = new HashMap();
        Iterable $this$forEach$iv = lingoToTranslationFieldMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            HashMap entityToFieldsList = new HashMap();
            Map<TranslationFieldUpdate.Entity, ? extends List<LingoTranslationField>> map = lingoToTranslationFieldMap.get(key);
            if (map != null && (map = map.keySet()) != null) {
                Iterable $this$forEach$iv2 = (Iterable)((Object)map);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    TranslationFieldUpdate.Entity entityType = (TranslationFieldUpdate.Entity)element$iv2;
                    boolean bl2 = false;
                    List entityTypeFieldsList = (List)MapsKt.getValue((Map)((Map)MapsKt.getValue(lingoToTranslationFieldMap, (Object)key)), (Object)entityType);
                    if (entityType == TranslationFieldUpdate.Entity.REQUEST_TYPE_FIELD) {
                        List<LingoTranslationField> validFieldsList = this.filterInvalidRequestTypeFields(project, entityTypeFieldsList);
                        ((Map)entityToFieldsList).put(entityType, validFieldsList);
                        continue;
                    }
                    Map map2 = entityToFieldsList;
                    TranslationFieldUpdate.Entity entity = entityType;
                    Intrinsics.checkNotNull((Object)entity);
                    map2.put(entity, entityTypeFieldsList);
                }
            }
            ((Map)filteredMap).put(key, entityToFieldsList);
        }
        return filteredMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<TranslationFieldUpdate.Entity, List<LingoTranslationField>>> groupByLanguageAndEntityType(List<LingoTranslationData> lingoTranslations) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = lingoTranslations;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            LingoTranslationData it = (LingoTranslationData)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getLanguageTag();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$groupByTo$iv$iv2;
            void $this$groupBy$iv2;
            LingoTranslationField it;
            void $this$mapTo$iv$iv;
            void it2;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it2.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LingoTranslationData lingoTranslationData = (LingoTranslationData)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(new LingoTranslationField(((LingoTranslationData)((Object)it)).getLingoTranslationId(), ((LingoTranslationData)((Object)it)).getCreatedDate(), ((LingoTranslationData)((Object)it)).getContent(), ((LingoTranslationData)((Object)it)).getLogicalId()));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$groupBy2 = false;
            $this$mapTo$iv$iv = $this$groupBy$iv2;
            destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                it = (LingoTranslationField)element$iv$iv;
                boolean bl5 = false;
                TranslationFieldUpdate.Entity key$iv$iv2 = it.getLogicalId().getEntityType();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                if (value$iv$iv$iv2 == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv2;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object object = destination$iv$iv2;
            map2.put(k, object);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LingoTranslationField> filterInvalidRequestTypeFields(Project project, List<LingoTranslationField> requestTypeFields) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = requestTypeFields;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LingoTranslationField it = (LingoTranslationField)element$iv$iv;
            boolean bl = false;
            int n = it.getLogicalId().getEntityId();
            String string = it.getLogicalId().getFieldId();
            Intrinsics.checkNotNull((Object)string);
            if (!this.requestTypeExporterUtils.isValidField(project, n, string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List readLingoTranslationForProject$lambda$2(long $projectId, DatabaseConnection db) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Expression[] expressionArray = new Expression[]{Tables.INSTANCE.getLINGO().getID(), Tables.INSTANCE.getLINGO_REVISION().getID(), Tables.INSTANCE.getLINGO_TRANSLATION().getID(), Tables.INSTANCE.getLINGO_TRANSLATION().getLOCALE(), Tables.INSTANCE.getLINGO_TRANSLATION().getCONTENT(), Tables.INSTANCE.getLINGO_TRANSLATION().getCREATED_TIMESTAMP(), Tables.INSTANCE.getLINGO().getLOGICAL_ID()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)Tables.INSTANCE.getLINGO())).innerJoin((EntityPath)Tables.INSTANCE.getLINGO_REVISION())).on((Predicate)Tables.INSTANCE.getLINGO_REVISION().getLINGO_ID().eq((Expression)Tables.INSTANCE.getLINGO().getID()))).innerJoin((EntityPath)Tables.INSTANCE.getLINGO_TRANSLATION())).on((Predicate)Tables.INSTANCE.getLINGO_TRANSLATION().getLINGO_REVISION_ID().eq((Expression)Tables.INSTANCE.getLINGO_REVISION().getID()))).where((Predicate)Tables.INSTANCE.getLINGO().getPROJECT_ID().eq((Object)$projectId))).where((Predicate)Tables.INSTANCE.getLINGO().getLOGICAL_ID().isNotNull())).where((Predicate)LingoRevision.INSTANCE.getID().eq((Expression)((SQLQuery)db.select((Expression)LingoRevision.INSTANCE.getID().max()).from((Expression)LingoRevision.INSTANCE)).where((Predicate)LingoRevision.INSTANCE.getLINGO_ID().eq((Expression)LingoCategory.INSTANCE.getID()))))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean isParsable;
            Tuple tuple = (Tuple)element$iv$iv;
            boolean bl = false;
            Object object = tuple.get((Expression)Tables.INSTANCE.getLINGO().getLOGICAL_ID());
            Intrinsics.checkNotNull((Object)object);
            String logicalId = (String)object;
            boolean bl2 = isParsable = LingoTranslationReader.Companion.isLogicalIdValid(logicalId) && LingoTranslationReader.Companion.areLogicalIdFieldsValid(logicalId);
            if (!isParsable) {
                log.warn("Unable to parse " + logicalId + ". Skipping this Lingo.");
            }
            if (!isParsable) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple tuple = (Tuple)element$iv$iv;
            boolean bl3 = false;
            Object object = tuple.get((Expression)Tables.INSTANCE.getLINGO_TRANSLATION().getID());
            Intrinsics.checkNotNull((Object)object);
            long l = ((Number)object).longValue();
            Object object2 = tuple.get((Expression)Tables.INSTANCE.getLINGO().getLOGICAL_ID());
            Intrinsics.checkNotNull((Object)object2);
            LogicalId logicalId = LingoTranslationReader.Companion.getLogicalId((String)object2);
            Object object3 = tuple.get((Expression)Tables.INSTANCE.getLINGO_TRANSLATION().getLOCALE());
            Intrinsics.checkNotNull((Object)object3);
            String string = (String)object3;
            Object object4 = tuple.get((Expression)Tables.INSTANCE.getLINGO_TRANSLATION().getCREATED_TIMESTAMP());
            Intrinsics.checkNotNull((Object)object4);
            Instant instant = Instant.ofEpochMilli(((Number)object4).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
            Object object5 = tuple.get((Expression)Tables.INSTANCE.getLINGO_TRANSLATION().getCONTENT());
            Intrinsics.checkNotNull((Object)object5);
            LingoTranslationData it$iv$iv = new LingoTranslationData(l, logicalId, string, instant, (String)object5, $projectId);
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void readLingoTranslationForProject$lambda$3() {
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"requestType", (Object)TranslationFieldUpdate.Entity.REQUEST_TYPE), TuplesKt.to((Object)"requestTypeField", (Object)TranslationFieldUpdate.Entity.REQUEST_TYPE_FIELD), TuplesKt.to((Object)"requestTypeGroup", (Object)TranslationFieldUpdate.Entity.REQUEST_TYPE_GROUP), TuplesKt.to((Object)"portal", (Object)TranslationFieldUpdate.Entity.PORTAL), TuplesKt.to((Object)"announcement", (Object)TranslationFieldUpdate.Entity.ANNOUNCEMENT)};
        logicalIdToEntityTypeMap = MapsKt.mapOf((Pair[])pairArray);
        log = LoggerFactory.getLogger(LingoTranslationReader.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u001e\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0002J \u0010\u0016\u001a\u0004\u0018\u00010\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0016\u0010\u0019\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationReader$Companion;", "", "()V", "MIN_LOGICAL_ID_FIELDS", "", "SERVER_LOGICAL_ID_PREFIX", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logicalIdToEntityTypeMap", "", "Lcom/atlassian/migration/jira/servicedesk/lingo/TranslationFieldUpdate$Entity;", "areLogicalIdFieldsValid", "", "logicalId", "getEntityIdFromLogicalId", "logicalIdFields", "", "entityType", "getEntityTypeFromLogicalId", "", "getFieldIdFromLogicalId", "getLogicalId", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LogicalId;", "getTypeFromLogicalId", "isLogicalIdValid", "logicalIdStringToFields", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final LogicalId getLogicalId(String logicalId) {
            List logicalIdFields = CollectionsKt.toMutableList((Collection)this.logicalIdStringToFields(logicalId));
            TranslationFieldUpdate.Entity entity = this.getEntityTypeFromLogicalId(logicalIdFields);
            Intrinsics.checkNotNull((Object)entity);
            TranslationFieldUpdate.Entity entityType = entity;
            int entityId = this.getEntityIdFromLogicalId(logicalIdFields, entityType);
            String fieldId = this.getFieldIdFromLogicalId(logicalIdFields, entityType);
            String type = this.getTypeFromLogicalId(logicalIdFields);
            return new LogicalId(entityType, entityId, type, fieldId);
        }

        private final boolean isLogicalIdValid(String logicalId) {
            return StringUtils.contains((CharSequence)logicalId, (CharSequence)LingoTranslationReader.SERVER_LOGICAL_ID_PREFIX);
        }

        private final boolean areLogicalIdFieldsValid(String logicalId) {
            boolean bl;
            TranslationFieldUpdate.Entity entityType;
            List<String> logicalIdFields = this.logicalIdStringToFields(logicalId);
            if (logicalIdFields.size() < 3) {
                return false;
            }
            TranslationFieldUpdate.Entity entity = entityType = this.getEntityTypeFromLogicalId(logicalIdFields);
            switch (entity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[entity.ordinal()]) {
                case -1: {
                    bl = false;
                    break;
                }
                case 1: {
                    if (StringsKt.toIntOrNull((String)logicalIdFields.get(2)) != null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = StringsKt.toIntOrNull((String)logicalIdFields.get(1)) != null;
                }
            }
            return bl;
        }

        private final List<String> logicalIdStringToFields(String logicalId) {
            String string = logicalId.substring(StringsKt.indexOf$default((CharSequence)logicalId, (String)LingoTranslationReader.SERVER_LOGICAL_ID_PREFIX, (int)0, (boolean)false, (int)6, null) + 4 + 1, logicalId.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{"."};
            return StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }

        private final TranslationFieldUpdate.Entity getEntityTypeFromLogicalId(List<String> logicalIdFields) {
            return (TranslationFieldUpdate.Entity)logicalIdToEntityTypeMap.get(logicalIdFields.get(0));
        }

        private final int getEntityIdFromLogicalId(List<String> logicalIdFields, TranslationFieldUpdate.Entity entityType) {
            return WhenMappings.$EnumSwitchMapping$0[entityType.ordinal()] == 1 ? Integer.parseInt(logicalIdFields.get(2)) : Integer.parseInt(logicalIdFields.get(1));
        }

        private final String getTypeFromLogicalId(List<String> logicalIdFields) {
            return (String)CollectionsKt.last(logicalIdFields);
        }

        private final String getFieldIdFromLogicalId(List<String> logicalIdFields, TranslationFieldUpdate.Entity entityType) {
            return WhenMappings.$EnumSwitchMapping$0[entityType.ordinal()] == 2 ? logicalIdFields.get(2) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TranslationFieldUpdate.Entity.values().length];
                try {
                    nArray[TranslationFieldUpdate.Entity.ANNOUNCEMENT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TranslationFieldUpdate.Entity.REQUEST_TYPE_FIELD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

