/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.servicedesk.lingo;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.DefaultLanguageAndCreatedTimestamp;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoProjectLanguage;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.Tables;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/ProjectLanguageReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getAllLanguagesForProject", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoProjectLanguage;", "project", "Lcom/atlassian/jira/project/Project;", "getDefaultLanguageAndTimestampForProject", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/DefaultLanguageAndCreatedTimestamp;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectLanguageReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectLanguageReader.kt\ncom/atlassian/jira/migration/export/db/servicedesk/lingo/ProjectLanguageReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1#2:86\n1549#3:87\n1620#3,3:88\n*S KotlinDebug\n*F\n+ 1 ProjectLanguageReader.kt\ncom/atlassian/jira/migration/export/db/servicedesk/lingo/ProjectLanguageReader\n*L\n73#1:87\n73#1:88,3\n*E\n"})
public final class ProjectLanguageReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(ProjectLanguageReader.class);

    @Inject
    public ProjectLanguageReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @Nullable
    public final DefaultLanguageAndCreatedTimestamp getDefaultLanguageAndTimestampForProject(@NotNull Project project) {
        LingoProjectLanguage lingoProjectLanguage;
        Object object;
        Instant createdTimestamp;
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Tuple queryResult = (Tuple)this.databaseAccessor.run(arg_0 -> ProjectLanguageReader.getDefaultLanguageAndTimestampForProject$lambda$0(project, arg_0), ProjectLanguageReader::getDefaultLanguageAndTimestampForProject$lambda$1);
        Object object2 = queryResult;
        if (object2 != null && (object2 = (Long)object2.get((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION().getCREATED_TIMESTAMP())) != null) {
            Object it = object2;
            boolean bl = false;
            instant = Instant.ofEpochMilli((Long)it);
        } else {
            instant = createdTimestamp = null;
        }
        if ((object = queryResult) != null && (object = (String)object.get((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION().getDEFAULT_LANGUAGE())) != null) {
            Object languageTag = object;
            boolean bl = false;
            Locale locale = Locale.forLanguageTag((String)languageTag);
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(...)");
            lingoProjectLanguage = new LingoProjectLanguage(locale, true);
        } else {
            lingoProjectLanguage = null;
        }
        LingoProjectLanguage defaultLanguage = lingoProjectLanguage;
        return createdTimestamp != null && defaultLanguage != null ? new DefaultLanguageAndCreatedTimestamp(defaultLanguage, createdTimestamp) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LingoProjectLanguage> getAllLanguagesForProject(@NotNull Project project) {
        List list;
        List languages;
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            list2 = (List)this.databaseAccessor.run(arg_0 -> ProjectLanguageReader.getAllLanguagesForProject$lambda$4(project, arg_0), ProjectLanguageReader::getAllLanguagesForProject$lambda$5);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Could not fetch all languages for projectId [" + project.getId() + ']');
            list2 = null;
        }
        List list3 = languages = list2;
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tuple tuple = (Tuple)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Locale locale = Locale.forLanguageTag(String.valueOf(it.get((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE().getLOCALE())));
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(...)");
                Object object = it.get((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE().getACTIVE());
                Intrinsics.checkNotNull((Object)object);
                collection.add(new LingoProjectLanguage(locale, (Boolean)object));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Tuple getDefaultLanguageAndTimestampForProject$lambda$0(Project $project, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Expression[] expressionArray = new Expression[]{Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION().getDEFAULT_LANGUAGE(), Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION().getCREATED_TIMESTAMP()};
        return (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION())).join((EntityPath)Tables.INSTANCE.getPROJECT_LANGUAGE_CONFIG())).on((Predicate)Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION().getPROJECT_LANG_CONFIG_ID().eq((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE_CONFIG().getID()))).where((Predicate)Tables.INSTANCE.getPROJECT_LANGUAGE_CONFIG().getPROJECT_ID().eq((Object)$project.getId()))).orderBy(Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION().getID().desc())).limit(1L)).fetchOne();
    }

    private static final void getDefaultLanguageAndTimestampForProject$lambda$1() {
    }

    private static final List getAllLanguagesForProject$lambda$4(Project $project, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Expression[] expressionArray = new Expression[]{Tables.INSTANCE.getPROJECT_LANGUAGE().getLOCALE(), Tables.INSTANCE.getPROJECT_LANGUAGE().getACTIVE()};
        return ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE())).where((Predicate)Tables.INSTANCE.getPROJECT_LANGUAGE().getPROJECT_LANG_REV_ID().eq(((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION().getID().max()).from((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION())).join((EntityPath)Tables.INSTANCE.getPROJECT_LANGUAGE_CONFIG())).on((Predicate)Tables.INSTANCE.getPROJECT_LANGUAGE_REVISION().getPROJECT_LANG_CONFIG_ID().eq((Expression)Tables.INSTANCE.getPROJECT_LANGUAGE_CONFIG().getID()))).where((Predicate)Tables.INSTANCE.getPROJECT_LANGUAGE_CONFIG().getPROJECT_ID().eq((Object)$project.getId()))).fetchOne()))).fetch();
    }

    private static final void getAllLanguagesForProject$lambda$5() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/ProjectLanguageReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

