/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.servicedesk.report;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.report.Report;
import com.atlassian.jira.migration.export.db.servicedesk.report.ReportReaderKt;
import com.atlassian.jira.migration.export.db.servicedesk.report.Series;
import com.atlassian.jira.migration.export.db.servicedesk.report.SeriesDataType;
import com.atlassian.jira.migration.export.db.servicedesk.report.Tables;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/db/servicedesk/report/ReportReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getAllReportsWithoutSeriesForServicedesk", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/report/Report;", "serviceDesk", "Lcom/atlassian/servicedesk/api/ServiceDesk;", "getAllSeriesForReportBatch", "Lcom/atlassian/jira/migration/export/db/servicedesk/report/Series;", "reports", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nReportReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportReader.kt\ncom/atlassian/jira/migration/export/db/servicedesk/report/ReportReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1603#2,9:102\n1855#2:111\n1856#2:113\n1612#2:114\n1549#2:115\n1620#2,3:116\n1603#2,9:119\n1855#2:128\n1856#2:130\n1612#2:131\n1#3:112\n1#3:129\n*S KotlinDebug\n*F\n+ 1 ReportReader.kt\ncom/atlassian/jira/migration/export/db/servicedesk/report/ReportReader\n*L\n37#1:102,9\n37#1:111\n37#1:113\n37#1:114\n56#1:115\n56#1:116,3\n66#1:119,9\n66#1:128\n66#1:130\n66#1:131\n37#1:112\n66#1:129\n*E\n"})
public final class ReportReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(ReportReader.class);

    @Inject
    public ReportReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Report> getAllReportsWithoutSeriesForServicedesk(@NotNull ServiceDesk serviceDesk) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)serviceDesk, (String)"serviceDesk");
        List queryResult = (List)this.databaseAccessor.run(arg_0 -> ReportReader.getAllReportsWithoutSeriesForServicedesk$lambda$0(serviceDesk, arg_0), ReportReader::getAllReportsWithoutSeriesForServicedesk$lambda$1);
        Intrinsics.checkNotNull((Object)queryResult);
        Iterable $this$mapNotNull$iv = queryResult;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Report it$iv$iv;
            Report report;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple it = (Tuple)element$iv$iv;
            boolean bl2 = false;
            try {
                Object object = it.get((Expression)Tables.INSTANCE.getREPORT().getID());
                Intrinsics.checkNotNull((Object)object);
                long l = ((Number)object).intValue();
                Object object2 = it.get((Expression)Tables.INSTANCE.getREPORT().getSERVICE_DESK_ID());
                if (object2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                long l2 = ((Number)object2).intValue();
                Object object3 = it.get((Expression)Tables.INSTANCE.getREPORT().getNAME());
                if (object3 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"checkNotNull(...)");
                String string = (String)object3;
                Object object4 = it.get((Expression)Tables.INSTANCE.getREPORT().getTARGET());
                if (object4 == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"checkNotNull(...)");
                long l3 = ((Number)object4).longValue();
                Object object5 = it.get((Expression)Tables.INSTANCE.getREPORT().getCREATED_DATE());
                if (object5 == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalStateException(string3.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"checkNotNull(...)");
                Date date = ReportReaderKt.toDateObject((Timestamp)object5);
                Object object6 = it.get((Expression)Tables.INSTANCE.getREPORT().getUPDATED_DATE());
                if (object6 == null) {
                    String string4 = "Required value was null.";
                    throw new IllegalStateException(string4.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"checkNotNull(...)");
                report = new Report(l, l2, string, l3, null, date, ReportReaderKt.toDateObject((Timestamp)object6));
            }
            catch (IllegalStateException ex) {
                log.info("Couldn't fetch report [" + it.get((Expression)Tables.INSTANCE.getREPORT().getID()) + "]. One or more attributes were found to be null");
                report = null;
            }
            if (report == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Series> getAllSeriesForReportBatch(@NotNull List<Report> reports) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(reports, (String)"reports");
        Iterable $this$map$iv = reports;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Report report = (Report)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)it.getId());
        }
        List reportIds = (List)destination$iv$iv;
        List queryResult = (List)this.databaseAccessor.run(arg_0 -> ReportReader.getAllSeriesForReportBatch$lambda$4(reportIds, arg_0), ReportReader::getAllSeriesForReportBatch$lambda$5);
        Intrinsics.checkNotNull((Object)queryResult);
        Iterable $this$mapNotNull$iv = queryResult;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Series it$iv$iv;
            Series series;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple it = (Tuple)element$iv$iv;
            boolean bl2 = false;
            try {
                Object object = it.get((Expression)Tables.INSTANCE.getSERIES().getSERIES_DATA_TYPE());
                if (object == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"checkNotNull(...)");
                String seriesDataTypeKey = (String)object;
                SeriesDataType seriesType = SeriesDataType.Companion.getSeriesDataTypeFromKeyString(seriesDataTypeKey);
                Object object2 = it.get((Expression)Tables.INSTANCE.getSERIES().getID());
                Intrinsics.checkNotNull((Object)object2);
                long l = ((Number)object2).intValue();
                Object object3 = it.get((Expression)Tables.INSTANCE.getSERIES().getREPORT_ID());
                if (object3 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                long l2 = ((Number)object3).intValue();
                Object object4 = it.get((Expression)Tables.INSTANCE.getSERIES().getSERIES_LABEL());
                if (object4 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"checkNotNull(...)");
                String string = (String)object4;
                Object object5 = it.get((Expression)Tables.INSTANCE.getSERIES().getJQL());
                if (object5 == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"checkNotNull(...)");
                String string3 = (String)object5;
                Object object6 = it.get((Expression)Tables.INSTANCE.getSERIES().getCOLOR());
                if (object6 == null) {
                    String string4 = "Required value was null.";
                    throw new IllegalStateException(string4.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"checkNotNull(...)");
                String string5 = (String)object6;
                Long l3 = (Long)it.get((Expression)Tables.INSTANCE.getSERIES().getTIME_METRIC_ID());
                Integer n = (Integer)it.get((Expression)Tables.INSTANCE.getSERIES().getGOAL_ID());
                Long l4 = n != null ? Long.valueOf(n.intValue()) : null;
                Object object7 = it.get((Expression)Tables.INSTANCE.getSERIES().getCREATED_DATE());
                if (object7 == null) {
                    String string6 = "Required value was null.";
                    throw new IllegalStateException(string6.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"checkNotNull(...)");
                Date date = ReportReaderKt.toDateObject((Timestamp)object7);
                Object object8 = it.get((Expression)Tables.INSTANCE.getSERIES().getUPDATED_DATE());
                if (object8 == null) {
                    String string7 = "Required value was null.";
                    throw new IllegalStateException(string7.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"checkNotNull(...)");
                series = new Series(l, l2, string, string3, string5, l3, l4, date, ReportReaderKt.toDateObject((Timestamp)object8), seriesType);
            }
            catch (IllegalStateException ex) {
                log.info("Couldn't fetch series [" + it.get((Expression)Tables.INSTANCE.getSERIES().getID()) + "]. One or more attributes were found to be null");
                series = null;
            }
            catch (IllegalArgumentException ex) {
                log.info("Couldn't fetch series [" + it.get((Expression)Tables.INSTANCE.getSERIES().getID()) + "]. Invalid series type key found: [" + (String)it.get((Expression)Tables.INSTANCE.getSERIES().getSERIES_DATA_TYPE()) + ']');
                series = null;
            }
            if (series == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private static final List getAllReportsWithoutSeriesForServicedesk$lambda$0(ServiceDesk $serviceDesk, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$serviceDesk, (String)"$serviceDesk");
        Expression[] expressionArray = new Expression[]{Tables.INSTANCE.getREPORT().getID(), Tables.INSTANCE.getREPORT().getSERVICE_DESK_ID(), Tables.INSTANCE.getREPORT().getNAME(), Tables.INSTANCE.getREPORT().getTARGET(), Tables.INSTANCE.getREPORT().getCREATED_DATE(), Tables.INSTANCE.getREPORT().getUPDATED_DATE()};
        return ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)Tables.INSTANCE.getREPORT())).where((Predicate)Tables.INSTANCE.getREPORT().getSERVICE_DESK_ID().eq((Object)$serviceDesk.getId()))).fetch();
    }

    private static final void getAllReportsWithoutSeriesForServicedesk$lambda$1() {
    }

    private static final List getAllSeriesForReportBatch$lambda$4(List $reportIds, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$reportIds, (String)"$reportIds");
        Path[] pathArray = Tables.INSTANCE.getSERIES().all();
        return ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)Tables.INSTANCE.getSERIES())).where((Predicate)Tables.INSTANCE.getSERIES().getREPORT_ID().in((Collection)$reportIds))).fetch();
    }

    private static final void getAllSeriesForReportBatch$lambda$5() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/db/servicedesk/report/ReportReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

