/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.software;

import com.atlassian.jira.migration.export.db.software.CardLayoutFieldData;
import com.atlassian.jira.migration.export.db.software.CardLayoutTable;
import com.atlassian.migration.jira.classic.software.rapidview.CardLayoutMode;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/export/db/software/CardLayoutReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "forRapidView", "", "Lcom/atlassian/jira/migration/export/db/software/CardLayoutFieldData;", "rapidViewId", "", "mapMode", "Lcom/atlassian/migration/jira/classic/software/rapidview/CardLayoutMode;", "modeName", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCardLayoutReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardLayoutReader.kt\ncom/atlassian/jira/migration/export/db/software/CardLayoutReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1549#2:78\n1620#2,3:79\n*S KotlinDebug\n*F\n+ 1 CardLayoutReader.kt\ncom/atlassian/jira/migration/export/db/software/CardLayoutReader\n*L\n34#1:78\n34#1:79,3\n*E\n"})
public final class CardLayoutReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(CardLayoutReader.class);

    @Inject
    public CardLayoutReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @NotNull
    public final List<CardLayoutFieldData> forRapidView(long rapidViewId) {
        try {
            log.debug("Executing db query to fetch card layout fields associated with rapid view " + rapidViewId);
            Object object = this.databaseAccessor.run(arg_0 -> CardLayoutReader.forRapidView$lambda$1(rapidViewId, this, arg_0), CardLayoutReader::forRapidView$lambda$2);
            List it = (List)object;
            boolean bl = false;
            log.debug("Successfully fetched card layout fields associated with rapid view " + rapidViewId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (Exception ex) {
            log.error("Error while fetching card layout fields associated with rapid view " + rapidViewId, (Throwable)ex);
            throw ex;
        }
    }

    private final CardLayoutMode mapMode(String modeName) {
        CardLayoutMode cardLayoutMode;
        String string = modeName;
        if (Intrinsics.areEqual((Object)string, (Object)"workMode")) {
            cardLayoutMode = CardLayoutMode.WORK;
        } else if (Intrinsics.areEqual((Object)string, (Object)"planMode")) {
            cardLayoutMode = CardLayoutMode.PLAN;
        } else {
            throw new IllegalArgumentException("Invalid Card Layout mode " + modeName);
        }
        return cardLayoutMode;
    }

    /*
     * WARNING - void declaration
     */
    private static final List forRapidView$lambda$1(long $rapidViewId, CardLayoutReader this$0, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = CardLayoutTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)CardLayoutTable.INSTANCE)).where((Predicate)CardLayoutTable.INSTANCE.getRAPID_VIEW_ID().eq((Object)$rapidViewId))).orderBy(CardLayoutTable.INSTANCE.getPOS().asc())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.get((Expression)CardLayoutTable.INSTANCE.getFIELD_ID());
            Intrinsics.checkNotNull((Object)object);
            String string = (String)object;
            Object object2 = it.get((Expression)CardLayoutTable.INSTANCE.getPOS());
            Intrinsics.checkNotNull((Object)object2);
            int n = ((Number)object2).intValue();
            Object object3 = it.get((Expression)CardLayoutTable.INSTANCE.getMODE_NAME());
            Intrinsics.checkNotNull((Object)object3);
            collection.add(new CardLayoutFieldData(string, n, this$0.mapMode((String)object3)));
        }
        return (List)destination$iv$iv;
    }

    private static final void forRapidView$lambda$2() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/db/software/CardLayoutReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

