/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.software;

import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.ShowEpics;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.jira.migration.db.SearchRequestTable;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.jira.migration.export.db.software.RapidViewReader;
import com.atlassian.jira.migration.export.db.software.RapidViewTable;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J(\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\n\"\u0004\b\u0000\u0010\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/export/db/software/RapidViewReaderImpl;", "Lcom/atlassian/jira/migration/export/db/software/RapidViewReader;", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "fetchAllRapidViewsIds", "", "", "fetchRapidViews", "Lcom/atlassian/greenhopper/model/rapid/RapidView;", "offset", "", "limit", "fetchRapidViewsByIds", "rapidViewIds", "fetchRapidViewsIdWithNonExistentIssueSource", "handleQueryException", "T", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorMessage", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRapidViewReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RapidViewReader.kt\ncom/atlassian/jira/migration/export/db/software/RapidViewReaderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1549#2:175\n1620#2,3:176\n1549#2:179\n1620#2,3:180\n*S KotlinDebug\n*F\n+ 1 RapidViewReader.kt\ncom/atlassian/jira/migration/export/db/software/RapidViewReaderImpl\n*L\n60#1:175\n60#1:176,3\n100#1:179\n100#1:180,3\n*E\n"})
public final class RapidViewReaderImpl
implements RapidViewReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Logger log;

    @Inject
    public RapidViewReaderImpl(@NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.databaseAccessor = databaseAccessor;
        this.migrationFeatures = migrationFeatures;
        Logger logger2 = LoggerFactory.getLogger(RapidViewReaderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    private final <T> List<T> handleQueryException(Exception e, String errorMessage2) {
        if (this.migrationFeatures.getSkipPreflightCheckExportErrors()) {
            this.log.warn(errorMessage2);
            return CollectionsKt.emptyList();
        }
        this.log.error(errorMessage2, (Throwable)e);
        throw e;
    }

    @Override
    @NotNull
    public List<RapidView> fetchRapidViews(int offset, int limit) {
        Object object;
        try {
            this.log.debug("Executing db query to fetch rapid views with offset: {} and limit {}", (Object)offset, (Object)limit);
            Object object2 = this.databaseAccessor.run(arg_0 -> RapidViewReaderImpl.fetchRapidViews$lambda$0(offset, limit, arg_0), OnRollback.NOOP);
            List it = (List)object2;
            boolean bl = false;
            this.log.debug("Successfully fetched rapid views with offset: {} and limit {}", (Object)offset, (Object)limit);
            object = object2;
            Intrinsics.checkNotNull((Object)object);
            object = (List)object;
        }
        catch (Exception e) {
            object = this.handleQueryException(e, "Error fetching RapidViews: " + e.getMessage() + ", passing emptyList");
        }
        return object;
    }

    @Override
    @NotNull
    public List<Long> fetchAllRapidViewsIds() {
        Object object;
        try {
            this.log.debug("Executing db query to fetch all rapid view ids");
            Object object2 = this.databaseAccessor.run(RapidViewReaderImpl::fetchAllRapidViewsIds$lambda$2, OnRollback.NOOP);
            List it = (List)object2;
            boolean bl = false;
            this.log.debug("Successfully fetched all rapid view ids");
            object = object2;
            Intrinsics.checkNotNull((Object)object);
            object = (List)object;
        }
        catch (Exception e) {
            object = this.handleQueryException(e, "Error fetching RapidViewIds: " + e.getMessage() + ", passing emptyList");
        }
        return object;
    }

    @Override
    @NotNull
    public List<RapidView> fetchRapidViewsByIds(@NotNull List<Long> rapidViewIds) {
        Object object;
        Intrinsics.checkNotNullParameter(rapidViewIds, (String)"rapidViewIds");
        try {
            this.log.debug("Executing db query to fetch all rapid views with ids: {}", rapidViewIds);
            Object object2 = this.databaseAccessor.run(arg_0 -> RapidViewReaderImpl.fetchRapidViewsByIds$lambda$5(rapidViewIds, arg_0), RapidViewReaderImpl::fetchRapidViewsByIds$lambda$6);
            List it = (List)object2;
            boolean bl = false;
            this.log.debug("Successfully fetched all rapid view with ids: {}", rapidViewIds);
            object = object2;
            Intrinsics.checkNotNull((Object)object);
            object = (List)object;
        }
        catch (Exception e) {
            object = this.handleQueryException(e, "Error fetching RapidViews by Ids: " + e.getMessage() + ", passing emptyList");
        }
        return object;
    }

    @Override
    @NotNull
    public List<Long> fetchRapidViewsIdWithNonExistentIssueSource() {
        Object object;
        try {
            this.log.debug("Executing db query to fetch all rapid view ids with non existent issue sources");
            Object object2 = this.databaseAccessor.run(RapidViewReaderImpl::fetchRapidViewsIdWithNonExistentIssueSource$lambda$8, RapidViewReaderImpl::fetchRapidViewsIdWithNonExistentIssueSource$lambda$9);
            List it = (List)object2;
            boolean bl = false;
            this.log.debug("Successfully fetched all rapid view ids with non existent issue sources");
            object = object2;
            Intrinsics.checkNotNull((Object)object);
            object = (List)object;
        }
        catch (Exception e) {
            object = this.handleQueryException(e, "Error fetching RapidViews with non existent issue source: " + e.getMessage() + ", passing emptyList");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchRapidViews$lambda$0(int $offset, int $limit, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = RapidViewTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).distinct()).from((Expression)RapidViewTable.INSTANCE)).orderBy(RapidViewTable.INSTANCE.getID().asc())).offset((long)$offset)).limit((long)$limit)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = Companion;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Companion)object).buildRapidView((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final List fetchAllRapidViewsIds$lambda$2(DatabaseConnection db) {
        ProjectableSQLQuery projectableSQLQuery = db.select((Expression)RapidViewTable.INSTANCE.getID()).from((Expression)RapidViewTable.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)projectableSQLQuery, (String)"from(...)");
        return QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)projectableSQLQuery).fetch();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchRapidViewsByIds$lambda$5(List $rapidViewIds, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$rapidViewIds, (String)"$rapidViewIds");
        Path[] pathArray = RapidViewTable.INSTANCE.all();
        ProjectableSQLQuery projectableSQLQuery = db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)RapidViewTable.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)projectableSQLQuery, (String)"from(...)");
        Iterable iterable = ((SQLQuery)QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)projectableSQLQuery).where((Predicate)RapidViewTable.INSTANCE.getID().in((Collection)$rapidViewIds))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(companion.buildRapidView((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void fetchRapidViewsByIds$lambda$6() {
    }

    private static final List fetchRapidViewsIdWithNonExistentIssueSource$lambda$8(DatabaseConnection db) {
        ProjectableSQLQuery projectableSQLQuery = db.select((Expression)RapidViewTable.INSTANCE.getID()).from((Expression)RapidViewTable.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)projectableSQLQuery, (String)"from(...)");
        return ((SQLQuery)((SQLQuery)((SQLQuery)QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)projectableSQLQuery).leftJoin((EntityPath)SearchRequestTable.Companion.getSEARCH_REQUEST_TABLE())).on((Predicate)RapidViewTable.INSTANCE.getSAVED_FILTER_ID().eq((Expression)SearchRequestTable.Companion.getSEARCH_REQUEST_TABLE().getID()))).where((Predicate)SearchRequestTable.Companion.getSEARCH_REQUEST_TABLE().getID().isNull())).fetch();
    }

    private static final void fetchRapidViewsIdWithNonExistentIssueSource$lambda$9() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/export/db/software/RapidViewReaderImpl$Companion;", "", "()V", "buildRapidView", "Lcom/atlassian/greenhopper/model/rapid/RapidView;", "row", "Lcom/querydsl/core/Tuple;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RapidView buildRapidView(@NotNull Tuple row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            RapidView.RapidViewBuilder rapidViewBuilder = RapidView.builder().id((Long)row.get((Expression)RapidViewTable.INSTANCE.getID())).name((String)row.get((Expression)RapidViewTable.INSTANCE.getNAME())).savedFilterId((Long)row.get((Expression)RapidViewTable.INSTANCE.getSAVED_FILTER_ID())).cardColorStrategy(CardColorStrategy.lookup((String)((String)row.get((Expression)RapidViewTable.INSTANCE.getCARD_COLOR_STRATEGY())))).oldDoneIssuesCutoff((RapidView.OldDoneIssuesCutoff)RapidView.OldDoneIssuesCutoff.fromValue((String)((String)row.get((Expression)RapidViewTable.INSTANCE.getOLD_DONE_ISSUES_CUTOFF()))).orElse(null)).owner((String)row.get((Expression)RapidViewTable.INSTANCE.getOWNER_USER_NAME()));
            Boolean bl = (Boolean)row.get((Expression)RapidViewTable.INSTANCE.getSHOW_DAYS_IN_COLUMN());
            if (bl == null) {
                bl = false;
            }
            RapidView.RapidViewBuilder rapidViewBuilder2 = rapidViewBuilder.showDaysInColumn(bl.booleanValue());
            Boolean bl2 = (Boolean)row.get((Expression)RapidViewTable.INSTANCE.getSHOW_EPIC_AS_PANEL());
            if (bl2 == null) {
                bl2 = false;
            }
            RapidView.RapidViewBuilder rapidViewBuilder3 = rapidViewBuilder2.showEpicAsPanel(ShowEpics.getValueFrom((Boolean)bl2));
            Boolean bl3 = (Boolean)row.get((Expression)RapidViewTable.INSTANCE.getSPRINTS_ENABLED());
            if (bl3 == null) {
                bl3 = false;
            }
            RapidView rapidView = rapidViewBuilder3.sprintSupportEnabled(bl3.booleanValue()).swimlaneStrategy(SwimlaneStrategy.lookup((String)((String)row.get((Expression)RapidViewTable.INSTANCE.getSWIMLANE_STRATEGY())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)rapidView, (String)"build(...)");
            return rapidView;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

