/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.db.software;

import com.atlassian.jira.migration.export.db.software.NonWorkingDayTable;
import com.atlassian.jira.migration.export.db.software.WorkingDaysTable;
import com.atlassian.migration.jira.classic.software.rapidview.WorkingDaysConfig;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/export/db/software/WorkingDaysConfigReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "forRapidView", "Lcom/atlassian/migration/jira/classic/software/rapidview/WorkingDaysConfig;", "rapidViewId", "", "loadNonWorkingDays", "", "Ljava/time/LocalDate;", "workingDaysId", "mapDate", "iso8601Date", "", "mapTimeZone", "Ljava/time/ZoneId;", "timeZoneId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nWorkingDaysConfigReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkingDaysConfigReader.kt\ncom/atlassian/jira/migration/export/db/software/WorkingDaysConfigReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n1#2:137\n1603#3,9:127\n1855#3:136\n1856#3:138\n1612#3:139\n*S KotlinDebug\n*F\n+ 1 WorkingDaysConfigReader.kt\ncom/atlassian/jira/migration/export/db/software/WorkingDaysConfigReader\n*L\n76#1:137\n76#1:127,9\n76#1:136\n76#1:138\n76#1:139\n*E\n"})
public final class WorkingDaysConfigReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(WorkingDaysConfigReader.class);

    @Inject
    public WorkingDaysConfigReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @VisibleForTesting
    @Nullable
    public final WorkingDaysConfig forRapidView(long rapidViewId) {
        try {
            log.debug("Executing db query to fetch working days config associated with rapid view " + rapidViewId);
            Object object = this.databaseAccessor.run(arg_0 -> WorkingDaysConfigReader.forRapidView$lambda$1(rapidViewId, this, arg_0), WorkingDaysConfigReader::forRapidView$lambda$2);
            WorkingDaysConfig it = (WorkingDaysConfig)object;
            boolean bl = false;
            log.debug("Successfully fetched working days config associated with rapid view " + rapidViewId);
            return (WorkingDaysConfig)object;
        }
        catch (Exception ex) {
            log.error("Error while fetching working days config associated with rapid view " + rapidViewId, (Throwable)ex);
            throw ex;
        }
    }

    private final Set<LocalDate> loadNonWorkingDays(long workingDaysId) {
        log.debug("Executing db query to fetch non working days with working day id: " + workingDaysId);
        Object object = this.databaseAccessor.run(arg_0 -> WorkingDaysConfigReader.loadNonWorkingDays$lambda$5(workingDaysId, this, arg_0), WorkingDaysConfigReader::loadNonWorkingDays$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Set)object;
    }

    private final LocalDate mapDate(String iso8601Date) {
        LocalDate localDate;
        String string = iso8601Date;
        if (string != null) {
            String it = string;
            boolean bl = false;
            localDate = LocalDate.parse(it, DateTimeFormatter.ISO_LOCAL_DATE);
        } else {
            localDate = null;
        }
        return localDate;
    }

    private final ZoneId mapTimeZone(String timeZoneId) {
        String string = timeZoneId;
        return (Intrinsics.areEqual((Object)string, (Object)"defaultTimeZoneId") ? true : string == null) ? null : ZoneId.of(timeZoneId);
    }

    private static final WorkingDaysConfig forRapidView$lambda$1(long $rapidViewId, WorkingDaysConfigReader this$0, DatabaseConnection db) {
        WorkingDaysConfig workingDaysConfig;
        Tuple rec;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = WorkingDaysTable.INSTANCE.all();
        Tuple tuple = rec = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)WorkingDaysTable.INSTANCE)).where((Predicate)WorkingDaysTable.INSTANCE.getRAPID_VIEW_ID().eq((Object)$rapidViewId))).fetchOne();
        if (tuple != null) {
            Tuple it = tuple;
            boolean bl = false;
            Object object = it.get((Expression)WorkingDaysTable.INSTANCE.getMONDAY());
            Intrinsics.checkNotNull((Object)object);
            boolean bl2 = (Boolean)object;
            Object object2 = it.get((Expression)WorkingDaysTable.INSTANCE.getTUESDAY());
            Intrinsics.checkNotNull((Object)object2);
            boolean bl3 = (Boolean)object2;
            Object object3 = it.get((Expression)WorkingDaysTable.INSTANCE.getWEDNESDAY());
            Intrinsics.checkNotNull((Object)object3);
            boolean bl4 = (Boolean)object3;
            Object object4 = it.get((Expression)WorkingDaysTable.INSTANCE.getTHURSDAY());
            Intrinsics.checkNotNull((Object)object4);
            boolean bl5 = (Boolean)object4;
            Object object5 = it.get((Expression)WorkingDaysTable.INSTANCE.getFRIDAY());
            Intrinsics.checkNotNull((Object)object5);
            boolean bl6 = (Boolean)object5;
            Object object6 = it.get((Expression)WorkingDaysTable.INSTANCE.getSATURDAY());
            Intrinsics.checkNotNull((Object)object6);
            boolean bl7 = (Boolean)object6;
            Object object7 = it.get((Expression)WorkingDaysTable.INSTANCE.getSUNDAY());
            Intrinsics.checkNotNull((Object)object7);
            boolean bl8 = (Boolean)object7;
            ZoneId zoneId = this$0.mapTimeZone((String)it.get((Expression)WorkingDaysTable.INSTANCE.getTIMEZONE()));
            Object object8 = it.get((Expression)WorkingDaysTable.INSTANCE.getID());
            Intrinsics.checkNotNull((Object)object8);
            workingDaysConfig = new WorkingDaysConfig(bl2, bl3, bl4, bl5, bl6, bl7, bl8, zoneId, this$0.loadNonWorkingDays(((Number)object8).longValue()));
        } else {
            workingDaysConfig = null;
        }
        return workingDaysConfig;
    }

    private static final void forRapidView$lambda$2() {
    }

    /*
     * WARNING - void declaration
     */
    private static final Set loadNonWorkingDays$lambda$5(long $workingDaysId, WorkingDaysConfigReader this$0, DatabaseConnection db) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = NonWorkingDayTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)NonWorkingDayTable.INSTANCE)).where((Predicate)NonWorkingDayTable.INSTANCE.getWORKING_DAYS_ID().eq((Object)$workingDaysId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LocalDate it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple it = (Tuple)element$iv$iv;
            boolean bl2 = false;
            if (this$0.mapDate((String)it.get((Expression)NonWorkingDayTable.INSTANCE.getISO8601_DATE())) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final void loadNonWorkingDays$lambda$6() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/db/software/WorkingDaysConfigReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

