/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.dbexport;

import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.migration.export.core.issue.ChangeHistoryData;
import com.atlassian.jira.migration.export.core.issue.JiraChangeHistory;
import com.atlassian.jira.migration.export.db.core.ChangeHistoryEntity;
import com.atlassian.jira.migration.export.db.core.ChangeHistoryReader;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/dbexport/ChangeHistoryDirectExport;", "", "changeHistoryReader", "Lcom/atlassian/jira/migration/export/db/core/ChangeHistoryReader;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/db/core/ChangeHistoryReader;Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "exportHistory", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "OrderDependentChangeHistoryStateAggregateAndExporter", "jira-migration-plugin"})
public final class ChangeHistoryDirectExport {
    @NotNull
    private final ChangeHistoryReader changeHistoryReader;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public ChangeHistoryDirectExport(@NotNull ChangeHistoryReader changeHistoryReader, @NotNull ExportService exportService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)changeHistoryReader, (String)"changeHistoryReader");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.changeHistoryReader = changeHistoryReader;
        this.exportService = exportService;
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportHistory(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        boolean shouldMigrateArchivedIssues = MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getMigrateArchivedIssues());
        AutoCloseable autoCloseable = new OrderDependentChangeHistoryStateAggregateAndExporter(ctx, this.exportService);
        Throwable throwable = null;
        try {
            OrderDependentChangeHistoryStateAggregateAndExporter stateAggregator = (OrderDependentChangeHistoryStateAggregateAndExporter)autoCloseable;
            boolean bl = false;
            Long l = ctx.getProject().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            this.changeHistoryReader.iterateChangeHistoryItemsForProjectOrderByGroupId(((Number)l).longValue(), (Function1<? super ChangeHistoryEntity, Unit>)((Function1)new Function1<ChangeHistoryEntity, Unit>((Object)stateAggregator){

                public final void invoke(@NotNull ChangeHistoryEntity p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((OrderDependentChangeHistoryStateAggregateAndExporter)this.receiver).addAndExport(p0);
                }
            }), shouldMigrateArchivedIssues);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/dbexport/ChangeHistoryDirectExport$OrderDependentChangeHistoryStateAggregateAndExporter;", "Ljava/lang/AutoCloseable;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/jira/migration/export/service/ExportService;)V", "existingChangeGroup", "Lcom/atlassian/jira/migration/export/core/issue/ChangeHistoryData;", "addAndExport", "", "newChangeHistory", "Lcom/atlassian/jira/migration/export/db/core/ChangeHistoryEntity;", "close", "jira-migration-plugin"})
    private static final class OrderDependentChangeHistoryStateAggregateAndExporter
    implements AutoCloseable {
        @NotNull
        private final ExportContext ctx;
        @NotNull
        private final ExportService exportService;
        @Nullable
        private ChangeHistoryData existingChangeGroup;

        public OrderDependentChangeHistoryStateAggregateAndExporter(@NotNull ExportContext ctx, @NotNull ExportService exportService) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
            this.ctx = ctx;
            this.exportService = exportService;
        }

        public final void addAndExport(@NotNull ChangeHistoryEntity newChangeHistory) {
            Intrinsics.checkNotNullParameter((Object)newChangeHistory, (String)"newChangeHistory");
            ChangeHistoryEntity $this$addAndExport_u24lambda_u240 = newChangeHistory;
            boolean bl = false;
            ChangeHistoryData newChangeGroup = new ChangeHistoryData($this$addAndExport_u24lambda_u240.getGroupId(), $this$addAndExport_u24lambda_u240.getIssueId(), $this$addAndExport_u24lambda_u240.getProjectId(), $this$addAndExport_u24lambda_u240.getIssueType(), $this$addAndExport_u24lambda_u240.getAuthorKey(), $this$addAndExport_u24lambda_u240.getCreated(), CollectionsKt.listOf((Object)new ChangeItemBean($this$addAndExport_u24lambda_u240.getFieldtype(), $this$addAndExport_u24lambda_u240.getField(), $this$addAndExport_u24lambda_u240.getOldvalue(), $this$addAndExport_u24lambda_u240.getOldstring(), $this$addAndExport_u24lambda_u240.getNewvalue(), $this$addAndExport_u24lambda_u240.getNewstring())));
            this.ctx.prepareissueUpdatedByCache(newChangeGroup.getIssueId(), newChangeGroup.getCreated(), newChangeGroup.getAuthorKey());
            if (this.existingChangeGroup == null) {
                this.existingChangeGroup = newChangeGroup;
            } else {
                ChangeHistoryData changeHistoryData = this.existingChangeGroup;
                Intrinsics.checkNotNull((Object)changeHistoryData);
                if (changeHistoryData.getId() == newChangeGroup.getId()) {
                    ChangeHistoryData changeHistoryData2 = this.existingChangeGroup;
                    Intrinsics.checkNotNull((Object)changeHistoryData2);
                    this.existingChangeGroup = changeHistoryData2.aggregate(newChangeGroup);
                } else {
                    ExportOrThrow exportOrThrow = this.exportService;
                    ChangeHistoryData changeHistoryData3 = this.existingChangeGroup;
                    Intrinsics.checkNotNull((Object)changeHistoryData3);
                    ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, this.ctx, JiraChangeHistory.Companion.fromChangeHistoryData(changeHistoryData3), false, 4, null);
                    this.existingChangeGroup = newChangeGroup;
                }
            }
        }

        @Override
        public void close() {
            block0: {
                ChangeHistoryData changeHistoryData = this.existingChangeGroup;
                if (changeHistoryData == null) break block0;
                ChangeHistoryData it = changeHistoryData;
                boolean bl = false;
                ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, this.ctx, JiraChangeHistory.Companion.fromChangeHistoryData(it), false, 4, null);
            }
        }
    }
}

