/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.mapper.DBComment;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.UsersExportService;
import com.atlassian.jira.migration.export.utils.TextSanitizer;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.workers.attachments.TextFieldConverterService;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.core.text.TextDocument;
import com.atlassian.migration.jira.core.Comment;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.projectrole.ProjectRole;
import java.sql.Timestamp;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0004J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001bH\u0004J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/export/directexport/AbstractCommentExport;", "", "textFieldConverterService", "Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "usersExportService", "Lcom/atlassian/jira/migration/export/service/UsersExportService;", "(Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/service/UsersExportService;)V", "getMigrationFeatures", "()Lcom/atlassian/jira/migration/features/MigrationFeatures;", "getTextFieldConverterService", "()Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;", "getUsersExportService", "()Lcom/atlassian/jira/migration/export/service/UsersExportService;", "exportComment", "Lcom/atlassian/migration/base/IdentifiableEntity;", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "comment", "Lcom/atlassian/jira/migration/export/directexport/mapper/DBComment;", "exportJiraComments", "mapBody", "Lcom/atlassian/migration/core/text/TextDocument;", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "truncateMessage", "", "mapUser", "Lcom/atlassian/migration/base/mri/MRI;", "user", "mapVisibility", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractCommentExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCommentExport.kt\ncom/atlassian/jira/migration/export/directexport/AbstractCommentExport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public abstract class AbstractCommentExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextFieldConverterService textFieldConverterService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final UsersExportService usersExportService;
    @NotNull
    private static final Logger log;

    public AbstractCommentExport(@NotNull TextFieldConverterService textFieldConverterService, @NotNull MigrationFeatures migrationFeatures, @NotNull UsersExportService usersExportService) {
        Intrinsics.checkNotNullParameter((Object)textFieldConverterService, (String)"textFieldConverterService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)usersExportService, (String)"usersExportService");
        this.textFieldConverterService = textFieldConverterService;
        this.migrationFeatures = migrationFeatures;
        this.usersExportService = usersExportService;
    }

    @NotNull
    public final TextFieldConverterService getTextFieldConverterService() {
        return this.textFieldConverterService;
    }

    @NotNull
    public final MigrationFeatures getMigrationFeatures() {
        return this.migrationFeatures;
    }

    @NotNull
    public final UsersExportService getUsersExportService() {
        return this.usersExportService;
    }

    @NotNull
    public abstract IdentifiableEntity exportComment(@NotNull DirectExportContext var1, @NotNull DBComment var2);

    @NotNull
    protected final IdentifiableEntity exportJiraComments(@NotNull DirectExportContext ctx, @NotNull DBComment comment) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        MRI mRI = ctx.generateMri(Comment.Companion.getEntityType(), comment.getId());
        MRI mRI2 = ctx.generateMri(Issue.Companion.getEntityType(), comment.getIssueId());
        TextDocument textDocument = this.mapBody(ctx.getProjectExportContext(), comment, "issue " + comment.getIssueId() + " comment " + comment.getId());
        MRI mRI3 = this.mapUser(ctx, comment.getAuthor());
        MRI mRI4 = this.mapUser(ctx, comment.getUpdateAuthor());
        Instant instant = comment.getCreated().toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        Timestamp timestamp = comment.getUpdated();
        return (IdentifiableEntity)new Comment(mRI, mRI2, textDocument, mRI3, mRI4, instant, timestamp != null ? timestamp.toInstant() : null, this.mapVisibility(ctx, comment), null, null, 768, null);
    }

    @NotNull
    protected final TextDocument mapBody(@NotNull ExportContext ctx, @NotNull DBComment entity, @Nullable String truncateMessage) {
        String content;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String it = content = this.migrationFeatures.getEnableConvertBigTextFields() ? this.textFieldConverterService.convertToAttachment(ctx, entity.getBody(), entity.getIssueId(), "Comment") : TextSanitizer.sanitizedText$default(TextSanitizer.INSTANCE, entity.getBody(), log, truncateMessage, 0, 8, null);
        boolean bl = false;
        this.usersExportService.extractUserRefs(ctx, it);
        return (TextDocument)new TextDocument.Wiki(it);
    }

    public static /* synthetic */ TextDocument mapBody$default(AbstractCommentExport abstractCommentExport, ExportContext exportContext, DBComment dBComment, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: mapBody");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return abstractCommentExport.mapBody(exportContext, dBComment, string);
    }

    @Nullable
    protected final MRI mapVisibility(@NotNull DirectExportContext ctx, @NotNull DBComment comment) {
        String string;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                string = comment.getGroupLevel();
                if (string == null) break block5;
                String it = string;
                boolean bl = false;
                DirectExportContext.addGroupToExportContext$default(ctx, new GroupRefModel(it, "Comment ", String.valueOf(comment.getId())).getGroupName(), false, 2, null);
                MRI mRI = this.usersExportService.groupRef(new GroupRefModel(it, "Comment ", String.valueOf(comment.getId())));
                string = mRI;
                if (mRI != null) break block6;
            }
            Long l = comment.getProjectroleId();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                string = ctx.generateMriAndTrack(ProjectRole.Companion.getEntityType(), comment.getProjectroleId());
            } else {
                string = null;
            }
        }
        return string;
    }

    @Nullable
    protected final MRI mapUser(@NotNull DirectExportContext ctx, @Nullable String user) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        UserRef userRef = UserRef.Companion.fromString(user);
        if (userRef != null) {
            UserRef userRef2 = userRef;
            boolean bl = false;
            MRI mri = ctx.getUserMRI(user);
            if (mri == null) {
                MRI userRefMri = this.usersExportService.userRef(ctx.getProjectExportContext(), userRef2);
                String string = user;
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    ctx.trackUser(it, userRefMri);
                }
                mRI = userRefMri;
            } else {
                mRI = mri;
            }
        } else {
            mRI = null;
        }
        return mRI;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(AbstractCommentExport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/export/directexport/AbstractCommentExport$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

