/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApprovalData;
import com.atlassian.jira.migration.export.directexport.DirectExport;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.db.reader.IssueDirectReader;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.approval.ApprovalService;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.project.Project;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/export/directexport/ApprovalDirectExport;", "Lcom/atlassian/jira/migration/export/directexport/DirectExport;", "jsdExportUtil", "Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "issueDirectReader", "Lcom/atlassian/jira/migration/export/directexport/db/reader/IssueDirectReader;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "approvalService", "Lcom/atlassian/jira/migration/export/servicedesk/approval/ApprovalService;", "(Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/directexport/db/reader/IssueDirectReader;Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/servicedesk/approval/ApprovalService;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "jiraProject", "Lcom/atlassian/jira/project/Project;", "exportApprovals", "issueId", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nApprovalDirectExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApprovalDirectExport.kt\ncom/atlassian/jira/migration/export/directexport/ApprovalDirectExport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1855#2,2:48\n1855#2,2:50\n*S KotlinDebug\n*F\n+ 1 ApprovalDirectExport.kt\ncom/atlassian/jira/migration/export/directexport/ApprovalDirectExport\n*L\n31#1:48,2\n39#1:50,2\n*E\n"})
public final class ApprovalDirectExport
extends DirectExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsdExportUtil jsdExportUtil;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final IssueDirectReader issueDirectReader;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ApprovalService approvalService;
    private static final Logger log = LoggerFactory.getLogger(ApprovalDirectExport.class);

    @Inject
    public ApprovalDirectExport(@NotNull JsdExportUtil jsdExportUtil, @NotNull MigrationFeatures migrationFeatures, @NotNull IssueDirectReader issueDirectReader, @NotNull ExportService exportService, @NotNull ApprovalService approvalService) {
        Intrinsics.checkNotNullParameter((Object)jsdExportUtil, (String)"jsdExportUtil");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)issueDirectReader, (String)"issueDirectReader");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)approvalService, (String)"approvalService");
        this.jsdExportUtil = jsdExportUtil;
        this.migrationFeatures = migrationFeatures;
        this.issueDirectReader = issueDirectReader;
        this.exportService = exportService;
        this.approvalService = approvalService;
    }

    @Override
    public void export(@NotNull DirectExportContext ctx, @NotNull Project jiraProject) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraProject, (String)"jiraProject");
        if (this.jsdExportUtil.isJsdProjectEligibleForMigration(ctx.getProjectExportContext())) {
            log.info("Direct export Approval started for : " + jiraProject.getKey());
            boolean shouldMigrateArchivedIssues = MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getProjectExportContext().getMigrateArchivedIssues());
            Long l = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            Iterable $this$forEach$iv = this.issueDirectReader.fetchIssueIdsForApproval(((Number)l).longValue(), shouldMigrateArchivedIssues);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long issueId = ((Number)element$iv).longValue();
                boolean bl = false;
                this.exportApprovals(ctx, issueId);
            }
            log.info("Direct export Approval finished for : " + jiraProject.getKey());
        }
    }

    private final void exportApprovals(DirectExportContext ctx, long issueId) {
        Iterable $this$forEach$iv = this.approvalService.getApprovalsByIssueId(issueId);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ApprovalData approval = (ApprovalData)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx.originalContext(), approval, false, 4, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/directexport/ApprovalDirectExport$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

