/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.migration.export.directexport.AbstractCommentExport;
import com.atlassian.jira.migration.export.directexport.DirectExport;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.db.reader.CommentsDirectReader;
import com.atlassian.jira.migration.export.directexport.mapper.DBComment;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.jiraservice.JiraGroupManager;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.migration.base.IdentifiableEntity;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/directexport/CommentsDirectExport;", "Lcom/atlassian/jira/migration/export/directexport/DirectExport;", "commentsDirectReader", "Lcom/atlassian/jira/migration/export/directexport/db/reader/CommentsDirectReader;", "commentExport", "Lcom/atlassian/jira/migration/export/directexport/AbstractCommentExport;", "jiraGroupManager", "Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;", "projectRoleManager", "Lcom/atlassian/jira/security/roles/ProjectRoleManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/directexport/db/reader/CommentsDirectReader;Lcom/atlassian/jira/migration/export/directexport/AbstractCommentExport;Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;Lcom/atlassian/jira/security/roles/ProjectRoleManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "jiraProject", "Lcom/atlassian/jira/project/Project;", "hasValidVisibility", "", "commentData", "Lcom/atlassian/jira/migration/export/directexport/mapper/DBComment;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCommentsDirectExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentsDirectExport.kt\ncom/atlassian/jira/migration/export/directexport/CommentsDirectExport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class CommentsDirectExport
extends DirectExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommentsDirectReader commentsDirectReader;
    @NotNull
    private final AbstractCommentExport commentExport;
    @NotNull
    private final JiraGroupManager jiraGroupManager;
    @NotNull
    private final ProjectRoleManager projectRoleManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private static final Logger log;

    @Inject
    public CommentsDirectExport(@NotNull CommentsDirectReader commentsDirectReader, @NotNull AbstractCommentExport commentExport, @NotNull JiraGroupManager jiraGroupManager, @NotNull ProjectRoleManager projectRoleManager, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)commentsDirectReader, (String)"commentsDirectReader");
        Intrinsics.checkNotNullParameter((Object)commentExport, (String)"commentExport");
        Intrinsics.checkNotNullParameter((Object)jiraGroupManager, (String)"jiraGroupManager");
        Intrinsics.checkNotNullParameter((Object)projectRoleManager, (String)"projectRoleManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.commentsDirectReader = commentsDirectReader;
        this.commentExport = commentExport;
        this.jiraGroupManager = jiraGroupManager;
        this.projectRoleManager = projectRoleManager;
        this.migrationFeatures = migrationFeatures;
    }

    @Override
    public void export(@NotNull DirectExportContext ctx, @NotNull Project jiraProject) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraProject, (String)"jiraProject");
        log.info("Direct export Comments started for : " + jiraProject.getKey());
        boolean shouldMigrateArchivedIssues = MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getProjectExportContext().getMigrateArchivedIssues());
        Long l = jiraProject.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        this.commentsDirectReader.fetchComments(((Number)l).longValue(), shouldMigrateArchivedIssues, (Function1<? super DBComment, Unit>)((Function1)new Function1<DBComment, Unit>(this, ctx){
            final /* synthetic */ CommentsDirectExport this$0;
            final /* synthetic */ DirectExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            public final void invoke(@NotNull DBComment it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (CommentsDirectExport.access$hasValidVisibility(this.this$0, it)) {
                    IdentifiableEntity exportComment = CommentsDirectExport.access$getCommentExport$p(this.this$0).exportComment(this.$ctx, it);
                    this.$ctx.put(exportComment.getId(), exportComment);
                }
            }
        }));
        log.info("Direct export Comments finished for : " + jiraProject.getKey());
    }

    private final boolean hasValidVisibility(DBComment commentData) {
        boolean bl;
        String string = commentData.getGroupLevel();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = this.jiraGroupManager.isValidGroup(it);
        } else {
            Long l = commentData.getRoleLevel();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                bl = JiraExtensionsKt.isValidRole(this.projectRoleManager, it);
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasValidVisibility(CommentsDirectExport $this, DBComment commentData) {
        return $this.hasValidVisibility(commentData);
    }

    public static final /* synthetic */ AbstractCommentExport access$getCommentExport$p(CommentsDirectExport $this) {
        return $this.commentExport;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(CommentsDirectExport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/directexport/CommentsDirectExport$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

