/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.migration.export.core.customfield.jsd.JsdCustomFieldValueParser;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.mapper.DBIssue;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.CustomFieldUtils;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.reports.ProblemType;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.customfield.CustomFieldOption;
import com.atlassian.migration.jira.core.customfield.CustomFieldValue;
import com.atlassian.migration.jira.core.customfield.IdReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001fJ\u001e\u0010!\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/export/directexport/CustomFieldValueDirectExportHelper;", "", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "customFieldUtils", "Lcom/atlassian/jira/migration/export/utils/CustomFieldUtils;", "jsdCustomFieldValueParser", "Lcom/atlassian/jira/migration/export/core/customfield/jsd/JsdCustomFieldValueParser;", "issueTypeManager", "Lcom/atlassian/jira/config/IssueTypeManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/migration/export/utils/CustomFieldUtils;Lcom/atlassian/jira/migration/export/core/customfield/jsd/JsdCustomFieldValueParser;Lcom/atlassian/jira/config/IssueTypeManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/service/ExportService;)V", "addToUnsupportedEntitiesContext", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "issue", "Lcom/atlassian/jira/migration/export/directexport/mapper/DBIssue;", "customField", "Lcom/atlassian/jira/issue/fields/CustomField;", "handleUnsupportedField", "isDevelopmentSummary", "", "customFieldName", "", "isSupportedAppVendorCF", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "removeCustomFieldValueIfNotExported", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue;", "customFieldValue", "shouldExportCustomField", "shouldRemoveIdReference", "idReference", "Lcom/atlassian/migration/jira/core/customfield/IdReference;", "shouldSkipJSDCustomFieldExport", "shouldSkipSpecificCustomFieldExport", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomFieldValueDirectExportHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomFieldValueDirectExportHelper.kt\ncom/atlassian/jira/migration/export/directexport/CustomFieldValueDirectExportHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n819#3:135\n847#3,2:136\n*S KotlinDebug\n*F\n+ 1 CustomFieldValueDirectExportHelper.kt\ncom/atlassian/jira/migration/export/directexport/CustomFieldValueDirectExportHelper\n*L\n100#1:135\n100#1:136,2\n*E\n"})
public final class CustomFieldValueDirectExportHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final CustomFieldUtils customFieldUtils;
    @NotNull
    private final JsdCustomFieldValueParser jsdCustomFieldValueParser;
    @NotNull
    private final IssueTypeManager issueTypeManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private static final Logger log;

    @Inject
    public CustomFieldValueDirectExportHelper(@NotNull ExportFilters exportFilters, @NotNull CustomFieldUtils customFieldUtils, @NotNull JsdCustomFieldValueParser jsdCustomFieldValueParser, @NotNull IssueTypeManager issueTypeManager, @NotNull MigrationFeatures migrationFeatures, @NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)customFieldUtils, (String)"customFieldUtils");
        Intrinsics.checkNotNullParameter((Object)jsdCustomFieldValueParser, (String)"jsdCustomFieldValueParser");
        Intrinsics.checkNotNullParameter((Object)issueTypeManager, (String)"issueTypeManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportFilters = exportFilters;
        this.customFieldUtils = customFieldUtils;
        this.jsdCustomFieldValueParser = jsdCustomFieldValueParser;
        this.issueTypeManager = issueTypeManager;
        this.migrationFeatures = migrationFeatures;
        this.exportService = exportService;
    }

    public final boolean shouldExportCustomField(@NotNull DirectExportContext ctx, @NotNull DBIssue issue2, @NotNull CustomField customField) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
        return this.exportFilters.isSupportedField(ctx.originalContext(), (Field)customField) && !this.shouldSkipSpecificCustomFieldExport(customField, issue2) && !this.isSupportedAppVendorCF(ctx, customField) && this.shouldSkipJSDCustomFieldExport(ctx, customField);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSkipSpecificCustomFieldExport(CustomField customField, DBIssue issue2) {
        if (!Intrinsics.areEqual((Object)"com.pyxis.greenhopper.jira:gh-sprint", (Object)customField.getCustomFieldType().getKey())) return false;
        IssueType issueType = this.issueTypeManager.getIssueType(issue2.getIssueTypeId());
        if (issueType == null) return false;
        boolean bl = issueType.isSubTask();
        if (!bl) return false;
        return true;
    }

    private final boolean isSupportedAppVendorCF(DirectExportContext ctx, CustomField customField) {
        ExportContext exportContext = ctx.originalContext();
        String string = customField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = customField.getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
        return this.customFieldUtils.isSupportedAppVendorCF(exportContext, string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSkipJSDCustomFieldExport(DirectExportContext ctx, CustomField customField) {
        if (!Intrinsics.areEqual((Object)ctx.getProject().getProjectTypeKey().getKey(), (Object)"service_desk")) return true;
        ExportContext exportContext = ctx.originalContext();
        String string = customField.getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        if (this.jsdCustomFieldValueParser.shouldSkipJsdCustomFieldValue(exportContext, string)) return false;
        return true;
    }

    public final void handleUnsupportedField(@NotNull ExportContext ctx, @NotNull DBIssue issue2, @NotNull CustomField customField) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
        if (!this.shouldSkipSpecificCustomFieldExport(customField, issue2)) {
            String string = customField.getCustomFieldType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!this.isDevelopmentSummary(string)) {
                if (this.migrationFeatures.getEnableAggregateUnsupportedCustomFieldValue()) {
                    this.addToUnsupportedEntitiesContext(ctx, issue2, customField);
                } else {
                    String problemTypeAndDetails = (Object)((Object)ProblemType.CUSTOM_FIELD_VALUE) + ':' + customField.getCustomFieldType().getName();
                    ExportContext.handleUnsupported$default(ctx, String.valueOf(issue2.getId()), ctx.getProject().getKey() + '-' + issue2.getIssueNumber(), problemTypeAndDetails, customField.getName(), null, null, 48, null);
                }
            }
        }
    }

    private final void addToUnsupportedEntitiesContext(ExportContext ctx, DBIssue issue2, CustomField customField) {
        String projectId = String.valueOf(issue2.getProject());
        if (!ctx.existsUnsupportedCFInProject(projectId, customField)) {
            ctx.addUnsupportedCFToProject(projectId, customField);
            ExportContext.handleUnsupported$default(ctx, projectId, "", (Object)((Object)ProblemType.CUSTOM_FIELD_VALUE) + ':' + customField.getCustomFieldType().getName(), customField.getName(), null, 1, 16, null);
        } else {
            String string = customField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ctx.addCountToExistedUnsupported(projectId, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CustomFieldValue removeCustomFieldValueIfNotExported(@NotNull ExportContext ctx, @NotNull CustomFieldValue customFieldValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)customFieldValue, (String)"customFieldValue");
        if (this.migrationFeatures.getDisableMissingCustomFieldOptionFix()) {
            return customFieldValue;
        }
        CustomFieldValue customFieldValue2 = customFieldValue;
        if (customFieldValue2 instanceof CustomFieldValue.IdReferenceFieldValue) {
            CustomFieldValue customFieldValue3 = customFieldValue;
            CustomFieldValue.IdReferenceFieldValue it = (CustomFieldValue.IdReferenceFieldValue)customFieldValue3;
            boolean bl = false;
            object = !this.shouldRemoveIdReference(ctx, it.getValue()) ? customFieldValue3 : null;
        } else if (customFieldValue2 instanceof CustomFieldValue.IdReferenceListFieldValue) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Iterable iterable = ((CustomFieldValue.IdReferenceListFieldValue)customFieldValue).getValue();
            MRI mRI = null;
            CustomFieldValue.IdReferenceListFieldValue idReferenceListFieldValue = (CustomFieldValue.IdReferenceListFieldValue)customFieldValue;
            boolean $i$f$filterNot = false;
            void bl = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                IdReference it = (IdReference)element$iv$iv;
                boolean bl2 = false;
                if (this.shouldRemoveIdReference(ctx, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            object = (CustomFieldValue)CustomFieldValue.IdReferenceListFieldValue.copy$default((CustomFieldValue.IdReferenceListFieldValue)idReferenceListFieldValue, mRI, (List)list, (int)1, null);
        } else if (customFieldValue2 instanceof CustomFieldValue.IdReferenceCascadeFieldValue) {
            CustomFieldValue.IdReferenceCascadeFieldValue processCustomFieldValue;
            CustomFieldValue.IdReferenceCascadeFieldValue idReferenceCascadeFieldValue;
            IdReference idReference;
            CustomFieldValue.IdReferenceCascadeFieldValue idReferenceCascadeFieldValue2 = (CustomFieldValue.IdReferenceCascadeFieldValue)customFieldValue;
            MRI mRI = null;
            IdReference idReference2 = null;
            IdReference idReference3 = ((CustomFieldValue.IdReferenceCascadeFieldValue)customFieldValue).getChild();
            if (idReference3 != null) {
                IdReference destination$iv$iv = idReference3;
                IdReference idReference4 = idReference2;
                MRI mRI2 = mRI;
                CustomFieldValue.IdReferenceCascadeFieldValue idReferenceCascadeFieldValue3 = idReferenceCascadeFieldValue2;
                boolean bl = false;
                IdReference idReference5 = ((CustomFieldValue.IdReferenceCascadeFieldValue)customFieldValue).getChild();
                Intrinsics.checkNotNull((Object)idReference5);
                IdReference idReference6 = this.shouldRemoveIdReference(ctx, idReference5) ? null : ((CustomFieldValue.IdReferenceCascadeFieldValue)customFieldValue).getChild();
                idReferenceCascadeFieldValue2 = idReferenceCascadeFieldValue3;
                mRI = mRI2;
                idReference2 = idReference4;
                idReference = idReference6;
            } else {
                idReference = null;
            }
            CustomFieldValue.IdReferenceCascadeFieldValue it = idReferenceCascadeFieldValue = (processCustomFieldValue = CustomFieldValue.IdReferenceCascadeFieldValue.copy$default((CustomFieldValue.IdReferenceCascadeFieldValue)idReferenceCascadeFieldValue2, mRI, idReference2, idReference, (int)3, null));
            boolean bl = false;
            object = (CustomFieldValue)(!this.shouldRemoveIdReference(ctx, ((CustomFieldValue.IdReferenceCascadeFieldValue)customFieldValue).getParent()) ? idReferenceCascadeFieldValue : null);
        } else {
            object = customFieldValue;
        }
        return object;
    }

    private final boolean shouldRemoveIdReference(ExportContext ctx, IdReference idReference) {
        boolean shouldRemove;
        boolean bl = shouldRemove = Intrinsics.areEqual((Object)CustomFieldOption.Companion.getEntityType().getType(), (Object)idReference.getId().getEntityType()) && !this.exportService.checkExported(ctx, CustomFieldOption.Companion.getEntityType(), idReference.getId().getEntityId()).isExported();
        if (shouldRemove) {
            log.warn("Removing reference for customFieldOption: {}", (Object)idReference.getId().getEntityId());
        }
        return shouldRemove;
    }

    private final boolean isDevelopmentSummary(String customFieldName) {
        return Intrinsics.areEqual((Object)customFieldName, (Object)"Development Summary");
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(CustomFieldValueDirectExportHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/directexport/CustomFieldValueDirectExportHelper$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

