/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.migration.export.core.issue.V2IssueCustomFieldValueExportMapper;
import com.atlassian.jira.migration.export.db.advancedroadmaps.ProjectVersionDataReader;
import com.atlassian.jira.migration.export.db.core.ComponentReader;
import com.atlassian.jira.migration.export.directexport.CustomFieldDirectExport;
import com.atlassian.jira.migration.export.directexport.DirectExport;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.IssueValidator;
import com.atlassian.jira.migration.export.directexport.db.reader.IssueDirectReader;
import com.atlassian.jira.migration.export.directexport.mapper.DBIssue;
import com.atlassian.jira.migration.export.directexport.mapper.DBIssueWithCustomFieldValues;
import com.atlassian.jira.migration.export.directexport.utils.IssueExportUtils;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.framework.ProjectExportContext;
import com.atlassian.jira.migration.export.model.TextDocumentType;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.UsersExportService;
import com.atlassian.jira.migration.export.utils.TextSanitizer;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.log.MessageEntityIdentifier;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.migration.workers.attachments.TextFieldConverterService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.DurationFormatterProvider;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.core.text.TextDocument;
import com.atlassian.migration.jira.classic.issuesecurity.IssueSecurityLevel;
import com.atlassian.migration.jira.classic.issuestatus.IssueStatus;
import com.atlassian.migration.jira.classic.issuetype.IssueType;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.IssueTimeTracking;
import com.atlassian.migration.jira.core.Priority;
import com.atlassian.migration.jira.core.Resolution;
import com.atlassian.migration.jira.core.customfield.CustomFieldValue;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 Y2\u00020\u0001:\u0001YBo\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\n\u0010%\u001a\u00060&j\u0002`'H\u0016J\u0019\u0010(\u001a\u0004\u0018\u00010\u001e2\b\u0010)\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u0010*J$\u0010+\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010,\u001a\u00020-H\u0002J\"\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010!\u001a\u00020\"2\n\u0010%\u001a\u00060&j\u0002`'J:\u00102\u001a\u0004\u0018\u0001032\u0006\u0010!\u001a\u00020\"2\u0006\u00104\u001a\u00020 2\b\u00105\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u001eH\u0002J\u001e\u0010;\u001a\u0004\u0018\u00010\u001e2\u0006\u0010<\u001a\u00020 2\n\u0010%\u001a\u00060&j\u0002`'H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\u001e2\u0006\u0010>\u001a\u00020 H\u0002J\u001a\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020B2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010C\u001a\u00020\u001e2\b\u0010D\u001a\u0004\u0018\u00010\u001eH\u0002J\u001e\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010!\u001a\u00020\"2\u0006\u0010H\u001a\u00020IH\u0007J\u0010\u0010J\u001a\u00020K2\u0006\u0010H\u001a\u00020BH\u0007J\u001c\u0010L\u001a\u0004\u0018\u00010@2\u0006\u0010!\u001a\u00020\"2\b\u0010M\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010N\u001a\u00020@2\u0006\u0010O\u001a\u00020BH\u0002J\u0010\u0010P\u001a\u00020@2\u0006\u0010Q\u001a\u00020 H\u0002J\u001e\u0010R\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020-J(\u0010S\u001a\u00020T2\u0006\u0010A\u001a\u00020B2\u0006\u0010H\u001a\u00020T2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J'\u0010U\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0006\u0012\u0004\u0018\u00010 0V2\b\u0010W\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u0010XR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/atlassian/jira/migration/export/directexport/IssueDirectExport;", "Lcom/atlassian/jira/migration/export/directexport/DirectExport;", "issueDirectReader", "Lcom/atlassian/jira/migration/export/directexport/db/reader/IssueDirectReader;", "issueValidator", "Lcom/atlassian/jira/migration/export/directexport/IssueValidator;", "issueTypeManager", "Lcom/atlassian/jira/config/IssueTypeManager;", "issueCustomFieldValueExportMapper", "Lcom/atlassian/jira/migration/export/core/issue/V2IssueCustomFieldValueExportMapper;", "textFieldConverterService", "Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "usersExportService", "Lcom/atlassian/jira/migration/export/service/UsersExportService;", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "durationFormatterProvider", "Lcom/atlassian/jira/util/DurationFormatterProvider;", "customFieldDirectExport", "Lcom/atlassian/jira/migration/export/directexport/CustomFieldDirectExport;", "issueExportUtils", "Lcom/atlassian/jira/migration/export/directexport/utils/IssueExportUtils;", "projectVersionDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ProjectVersionDataReader;", "componentReader", "Lcom/atlassian/jira/migration/export/db/core/ComponentReader;", "(Lcom/atlassian/jira/migration/export/directexport/db/reader/IssueDirectReader;Lcom/atlassian/jira/migration/export/directexport/IssueValidator;Lcom/atlassian/jira/config/IssueTypeManager;Lcom/atlassian/jira/migration/export/core/issue/V2IssueCustomFieldValueExportMapper;Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/service/UsersExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/util/DurationFormatterProvider;Lcom/atlassian/jira/migration/export/directexport/CustomFieldDirectExport;Lcom/atlassian/jira/migration/export/directexport/utils/IssueExportUtils;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ProjectVersionDataReader;Lcom/atlassian/jira/migration/export/db/core/ComponentReader;)V", "defaultPriority", "", "projectId", "", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "export", "", "jiraProject", "Lcom/atlassian/jira/project/Project;", "Lcom/atlassian/jira/migration/export/directexport/JiraProject;", "exportDurationField", "duration", "(Ljava/lang/Long;)Ljava/lang/String;", "exportIssueWithCustomField", "migrateArchivedIssues", "", "exportIssueWithCustomValues", "Lcom/atlassian/migration/base/IdentifiableEntity;", "DBIssueWithCustomFieldValues", "Lcom/atlassian/jira/migration/export/directexport/mapper/DBIssueWithCustomFieldValues;", "exportTextDocumentProperty", "Lcom/atlassian/migration/core/text/TextDocument;", "issueId", "source", "truncateMsg", "docType", "Lcom/atlassian/jira/migration/export/model/TextDocumentType;", "extractPriority", "priority", "getIssueKey", "issueNum", "getOptionPriority", "configurationContextFieldScheme", "getPriority", "Lcom/atlassian/migration/base/mri/MRI;", "dbIssue", "Lcom/atlassian/jira/migration/export/directexport/mapper/DBIssue;", "handleSummary", "summary", "mapCustomFields", "", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue;", "issue", "Lcom/atlassian/jira/issue/Issue;", "mapTimeTrackingFields", "Lcom/atlassian/migration/jira/core/IssueTimeTracking;", "mapUser", "user", "mriForEntity", "entity", "mriForKey", "entityKey", "prepareDirectExportContext", "setArchivedFields", "Lcom/atlassian/migration/jira/core/Issue;", "truncateToMinutes", "Lkotlin/Pair;", "seconds", "(Ljava/lang/Long;)Lkotlin/Pair;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueDirectExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueDirectExport.kt\ncom/atlassian/jira/migration/export/directexport/IssueDirectExport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1#2:353\n*E\n"})
public final class IssueDirectExport
extends DirectExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IssueDirectReader issueDirectReader;
    @NotNull
    private final IssueValidator issueValidator;
    @NotNull
    private final IssueTypeManager issueTypeManager;
    @NotNull
    private final V2IssueCustomFieldValueExportMapper issueCustomFieldValueExportMapper;
    @NotNull
    private final TextFieldConverterService textFieldConverterService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final UsersExportService usersExportService;
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    @NotNull
    private final DurationFormatterProvider durationFormatterProvider;
    @NotNull
    private final CustomFieldDirectExport customFieldDirectExport;
    @NotNull
    private final IssueExportUtils issueExportUtils;
    @NotNull
    private final ProjectVersionDataReader projectVersionDataReader;
    @NotNull
    private final ComponentReader componentReader;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String BLANK_SUMMARY = "";
    @NotNull
    private static final Locale ukLocale;

    @Inject
    public IssueDirectExport(@NotNull IssueDirectReader issueDirectReader, @NotNull IssueValidator issueValidator, @NotNull IssueTypeManager issueTypeManager, @NotNull V2IssueCustomFieldValueExportMapper issueCustomFieldValueExportMapper, @NotNull TextFieldConverterService textFieldConverterService, @NotNull MigrationFeatures migrationFeatures, @NotNull UsersExportService usersExportService, @NotNull EntityIdentifierGenerator entityIdentifierGenerator, @NotNull DurationFormatterProvider durationFormatterProvider, @NotNull CustomFieldDirectExport customFieldDirectExport, @NotNull IssueExportUtils issueExportUtils, @NotNull ProjectVersionDataReader projectVersionDataReader, @NotNull ComponentReader componentReader) {
        Intrinsics.checkNotNullParameter((Object)issueDirectReader, (String)"issueDirectReader");
        Intrinsics.checkNotNullParameter((Object)issueValidator, (String)"issueValidator");
        Intrinsics.checkNotNullParameter((Object)issueTypeManager, (String)"issueTypeManager");
        Intrinsics.checkNotNullParameter((Object)issueCustomFieldValueExportMapper, (String)"issueCustomFieldValueExportMapper");
        Intrinsics.checkNotNullParameter((Object)textFieldConverterService, (String)"textFieldConverterService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)usersExportService, (String)"usersExportService");
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        Intrinsics.checkNotNullParameter((Object)durationFormatterProvider, (String)"durationFormatterProvider");
        Intrinsics.checkNotNullParameter((Object)customFieldDirectExport, (String)"customFieldDirectExport");
        Intrinsics.checkNotNullParameter((Object)issueExportUtils, (String)"issueExportUtils");
        Intrinsics.checkNotNullParameter((Object)projectVersionDataReader, (String)"projectVersionDataReader");
        Intrinsics.checkNotNullParameter((Object)componentReader, (String)"componentReader");
        this.issueDirectReader = issueDirectReader;
        this.issueValidator = issueValidator;
        this.issueTypeManager = issueTypeManager;
        this.issueCustomFieldValueExportMapper = issueCustomFieldValueExportMapper;
        this.textFieldConverterService = textFieldConverterService;
        this.migrationFeatures = migrationFeatures;
        this.usersExportService = usersExportService;
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.durationFormatterProvider = durationFormatterProvider;
        this.customFieldDirectExport = customFieldDirectExport;
        this.issueExportUtils = issueExportUtils;
        this.projectVersionDataReader = projectVersionDataReader;
        this.componentReader = componentReader;
    }

    @Override
    public void export(@NotNull DirectExportContext ctx, @NotNull Project jiraProject) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraProject, (String)"jiraProject");
        log.info("Direct export Issue started for : " + jiraProject.getKey());
        boolean shouldMigrateArchivedIssues = MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getProjectExportContext().getMigrateArchivedIssues());
        Long l = jiraProject.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        this.prepareDirectExportContext(((Number)l).longValue(), ctx, shouldMigrateArchivedIssues);
        this.exportIssueWithCustomField(ctx, jiraProject, shouldMigrateArchivedIssues);
        log.info("Direct export Issue finished for : " + jiraProject.getKey());
    }

    private final void exportIssueWithCustomField(DirectExportContext ctx, Project jiraProject, boolean migrateArchivedIssues) {
        Long l = jiraProject.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        this.issueDirectReader.visitIssueWithCustomFieldsOrderByIssueId(((Number)l).longValue(), migrateArchivedIssues, (Function1<? super DBIssueWithCustomFieldValues, Unit>)((Function1)new Function1<DBIssueWithCustomFieldValues, Unit>(this, ctx, jiraProject){
            final /* synthetic */ IssueDirectExport this$0;
            final /* synthetic */ DirectExportContext $ctx;
            final /* synthetic */ Project $jiraProject;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$jiraProject = $jiraProject;
                super(1);
            }

            public final void invoke(@NotNull DBIssueWithCustomFieldValues it) {
                block2: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    MRI mri = IssueDirectExport.access$mriForEntity(this.this$0, it.getIssue());
                    Object object2 = this.this$0;
                    DirectExportContext directExportContext = this.$ctx;
                    Object object3 = this.$jiraProject;
                    try {
                        IssueDirectExport $this$invoke_u24lambda_u240 = object2;
                        boolean bl = false;
                        IssueDirectExport.access$getIssueValidator$p($this$invoke_u24lambda_u240).issueTypeValidator(directExportContext, IssueDirectExport.access$getIssueTypeManager$p($this$invoke_u24lambda_u240).getIssueType(it.getIssue().getIssueTypeId()), mri);
                        IdentifiableEntity exportIssue = $this$invoke_u24lambda_u240.exportIssueWithCustomValues(it, directExportContext, (Project)object3);
                        $this$invoke_u24lambda_u240.put(directExportContext, exportIssue.getId(), exportIssue);
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object2 = object;
                    directExportContext = this.$ctx;
                    object3 = this.this$0;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable == null) break block2;
                    Object it2 = object = throwable;
                    boolean bl = false;
                    directExportContext.originalContext().handleExportFailure(mri, (Throwable)it2, directExportContext.originalContext().getMigrationId() + ": Exporting entity " + EntityIdentifierGenerator.generate$default(IssueDirectExport.access$getEntityIdentifierGenerator$p((IssueDirectExport)object3), mri, null, null, 6, null) + " failed");
                }
            }
        }));
    }

    @NotNull
    public final IdentifiableEntity exportIssueWithCustomValues(@NotNull DBIssueWithCustomFieldValues DBIssueWithCustomFieldValues2, @NotNull DirectExportContext ctx, @NotNull Project jiraProject) {
        MRI mRI;
        MRI mRI2;
        Intrinsics.checkNotNullParameter((Object)DBIssueWithCustomFieldValues2, (String)"DBIssueWithCustomFieldValues");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraProject, (String)"jiraProject");
        DBIssue dbIssue = DBIssueWithCustomFieldValues2.getIssue();
        String issueKey = this.getIssueKey(dbIssue.getIssueNumber(), jiraProject);
        MRI mRI3 = this.mriForEntity(dbIssue);
        MRI mRI4 = MriExtensionsKt.mri$default(com.atlassian.migration.jira.classic.Project.Companion.getEntityType(), dbIssue.getProject(), null, 2, null);
        MRI mRI5 = ctx.generateMriAndTrack(IssueType.Companion.getEntityType(), dbIssue.getIssueTypeId());
        MRI mRI6 = ctx.generateMriAndTrack(IssueStatus.Companion.getEntityType(), dbIssue.getStatus());
        long l = dbIssue.getIssueNumber();
        Long l2 = dbIssue.getWatchers();
        long l3 = l2 != null ? l2 : 0L;
        Long l4 = dbIssue.getVoters();
        long l5 = l4 != null ? l4 : 0L;
        Long l6 = dbIssue.getSecurityLevel();
        if (l6 != null) {
            long it = ((Number)l6).longValue();
            boolean bl = false;
            mRI2 = ctx.generateMriAndTrack(IssueSecurityLevel.Companion.getEntityType(), it);
        } else {
            mRI2 = null;
        }
        MRI mRI7 = mRI2;
        Instant instant = dbIssue.getCreated();
        Instant instant2 = dbIssue.getUpdated();
        MRI mRI8 = this.mapUser(ctx, dbIssue.getReporter());
        MRI mRI9 = this.mapUser(ctx, dbIssue.getCreator());
        Pair<Timestamp, String> pair = ctx.originalContext().getIssueUpdatedBy().get(dbIssue.getId());
        MRI mRI10 = this.mapUser(ctx, pair != null ? (String)pair.getSecond() : null);
        MRI mRI11 = this.mapUser(ctx, dbIssue.getAssignee());
        String string = this.handleSummary(dbIssue.getSummary());
        TextDocument textDocument = IssueDirectExport.exportTextDocumentProperty$default(this, ctx, dbIssue.getId(), dbIssue.getDescription(), "issue " + issueKey + " description", null, 16, null);
        Object object = ctx.getLabels().get(dbIssue.getId());
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object object2 = object;
        List<CustomFieldValue> list = this.customFieldDirectExport.exportCustomFieldValues(ctx, DBIssueWithCustomFieldValues2);
        MRI mRI12 = this.getPriority(dbIssue, ctx);
        Timestamp timestamp = dbIssue.getDueDate();
        Instant instant3 = timestamp != null ? timestamp.toInstant() : null;
        Comparable<Date> comparable = dbIssue.getDueDate();
        LocalDate localDate = comparable != null && (comparable = ((Timestamp)comparable).toLocalDateTime()) != null ? ((LocalDateTime)comparable).toLocalDate() : null;
        IssueTimeTracking issueTimeTracking = this.mapTimeTrackingFields(dbIssue);
        Timestamp timestamp2 = dbIssue.getResolved();
        Instant instant4 = timestamp2 != null ? timestamp2.toInstant() : null;
        String string2 = dbIssue.getResolution();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            mRI = ctx.generateMriAndTrack(Resolution.Companion.getEntityType(), it);
        } else {
            mRI = null;
        }
        MRI mRI13 = mRI;
        List<MRI> list2 = ctx.getMrisForEntity(ctx.getComponentMRI(dbIssue.getId()));
        List<MRI> list3 = ctx.getMrisForEntity(ctx.getAffectVersionsMRI(dbIssue.getId()));
        List<MRI> list4 = ctx.getMrisForEntity(ctx.getFixVersionsMRI(dbIssue.getId()));
        TextDocument textDocument2 = IssueDirectExport.exportTextDocumentProperty$default(this, ctx, dbIssue.getId(), dbIssue.getEnvironment(), "issue " + issueKey + " description", null, 16, null);
        Long l7 = dbIssue.getTimeSpentInSecond();
        Object object3 = ctx.getMovedIssueKey().get(dbIssue.getId());
        if (object3 == null || (object3 = ArraysKt.toSet((Object[])object3)) == null) {
            object3 = SetsKt.emptySet();
        }
        Object object4 = object3;
        Issue issue2 = new Issue(mRI3, mRI4, mRI5, mRI6, l, l3, l5, mRI7, instant, instant2, mRI8, mRI9, mRI10, mRI11, string, textDocument, (List)object2, list, mRI12, instant3, localDate, issueTimeTracking, l7, instant4, mRI13, list2, list3, list4, textDocument2, (Set)object4, null, null, null, null, null, null, null, -1073741824, 31, null);
        if (MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getProjectExportContext().getMigrateArchivedIssues())) {
            Long l8 = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l8, (String)"getId(...)");
            issue2 = this.setArchivedFields(dbIssue, issue2, ((Number)l8).longValue(), ctx);
        }
        ProjectExportContext projectExportContext = ctx.getProjectExportContext();
        List list5 = issue2.getCustomFieldValues();
        Intrinsics.checkNotNull((Object)list5);
        projectExportContext.addToCustomFieldsStats(((Collection)list5).size());
        ctx.getProjectExportContext().addToIssueCountStats(1);
        return (IdentifiableEntity)issue2;
    }

    private final Issue setArchivedFields(DBIssue dbIssue, Issue issue2, long projectId, DirectExportContext ctx) {
        if (this.issueExportUtils.getIsArchived(dbIssue, projectId)) {
            log.info("Setting archived issue fields for issue {}", (Object)issue2.getId());
            ctx.getProjectExportContext().addToArchivedIssueCount(1);
            Timestamp timestamp = dbIssue.getArchivedDate();
            return Issue.copy$default((Issue)issue2, null, null, null, null, (long)0L, (long)0L, (long)0L, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Boolean)true, (MRI)this.mapUser(ctx, dbIssue.getArchivedBy()), (Instant)(timestamp != null ? timestamp.toInstant() : null), null, null, (int)-1, (int)24, null);
        }
        return issue2;
    }

    private final String handleSummary(String summary) {
        String string = summary;
        return string != null ? TextSanitizer.sanitizedText$default(TextSanitizer.INSTANCE, string, log, null, 0, 12, null) : BLANK_SUMMARY;
    }

    private final MRI mriForEntity(DBIssue entity) {
        return this.mriForKey(entity.getId());
    }

    private final MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Issue.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @VisibleForTesting
    @NotNull
    public final List<CustomFieldValue> mapCustomFields(@NotNull DirectExportContext ctx, @NotNull com.atlassian.jira.issue.Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        return this.issueCustomFieldValueExportMapper.mapCustomFieldValues(ctx.getProjectExportContext(), issue2);
    }

    private final TextDocument exportTextDocumentProperty(DirectExportContext ctx, long issueId, String source, String truncateMsg, TextDocumentType docType) {
        TextDocument textDocument;
        String string = source;
        if (string != null) {
            String it = string;
            boolean bl = false;
            String newSource = this.migrationFeatures.getEnableConvertBigTextFields() ? this.textFieldConverterService.convertToAttachment(ctx.originalContext(), it, issueId, "Description") : TextSanitizer.sanitizedText$default(TextSanitizer.INSTANCE, it, log, truncateMsg, 0, 8, null);
            String p0 = this.usersExportService.extractUserRefs(ctx.originalContext(), newSource);
            boolean bl2 = false;
            textDocument = docType.createOrNull(p0);
        } else {
            textDocument = null;
        }
        return textDocument;
    }

    static /* synthetic */ TextDocument exportTextDocumentProperty$default(IssueDirectExport issueDirectExport, DirectExportContext directExportContext, long l, String string, String string2, TextDocumentType textDocumentType, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            textDocumentType = TextDocumentType.WIKI;
        }
        return issueDirectExport.exportTextDocumentProperty(directExportContext, l, string, string2, textDocumentType);
    }

    private final String getIssueKey(long issueNum, Project jiraProject) {
        return IssueKey.format((Project)jiraProject, (long)issueNum);
    }

    @VisibleForTesting
    @NotNull
    public final IssueTimeTracking mapTimeTrackingFields(@NotNull DBIssue issue2) {
        Long l;
        Long l2;
        Long truncatedRemainingInSeconds;
        Pair<Long, Long> pair;
        Long remainingInSeconds;
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        MessageEntityIdentifier issueIdentifier = EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, this.mriForEntity(issue2), issue2, null, 4, null);
        Pair<Long, Long> pair2 = this.truncateToMinutes(issue2.getTimeOriginalEstimate());
        Long estimateInSeconds = (Long)pair2.component1();
        Long truncatedEstimateInSeconds = (Long)pair2.component2();
        if (!Intrinsics.areEqual((Object)estimateInSeconds, (Object)truncatedEstimateInSeconds)) {
            log.warn("Original Estimate for issue [" + issueIdentifier + "] got truncated as it had fractional minutes. [original: " + estimateInSeconds + " seconds, truncated: " + truncatedEstimateInSeconds + " seconds]");
        }
        if (!Intrinsics.areEqual((Object)(remainingInSeconds = (Long)(pair = this.truncateToMinutes(issue2.getTimeEstimate())).component1()), (Object)(truncatedRemainingInSeconds = (Long)pair.component2()))) {
            log.warn("Remaining Estimate for issue [" + issueIdentifier + "] got truncated as it had fractional minutes. [original: " + remainingInSeconds + " seconds, truncated: " + truncatedRemainingInSeconds + " seconds]");
        }
        String string = this.exportDurationField(estimateInSeconds);
        String string2 = this.exportDurationField(remainingInSeconds);
        Long l3 = truncatedEstimateInSeconds;
        if (l3 != null) {
            long it = ((Number)l3).longValue();
            boolean bl = false;
            l2 = it / (long)60;
        } else {
            l2 = null;
        }
        Long l4 = l2;
        Long l5 = truncatedRemainingInSeconds;
        if (l5 != null) {
            long it = ((Number)l5).longValue();
            boolean bl = false;
            l = it / (long)60;
        } else {
            l = null;
        }
        Long l6 = l;
        return new IssueTimeTracking(string, l4, string2, l6);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Pair<Long, Long> truncateToMinutes(Long seconds) {
        Object object;
        if (seconds != null) {
            Long l;
            Long l2 = seconds;
            long it = ((Number)l2).longValue();
            boolean bl = false;
            Long l3 = l = it > 0L ? l2 : null;
            if (l != null) {
                long it2 = ((Number)l).longValue();
                boolean bl2 = false;
                l2 = TuplesKt.to((Object)it2, (Object)(TimeUnit.SECONDS.toMinutes(it2) * (long)60));
                if (l2 != null) {
                    object = l2;
                    return object;
                }
            }
        }
        object = TuplesKt.to(null, null);
        return object;
    }

    private final String exportDurationField(Long duration) {
        String string;
        Long l = duration;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            string = this.durationFormatterProvider.getFormatter().shortFormat(Long.valueOf(it), ukLocale);
        } else {
            string = null;
        }
        return string;
    }

    private final MRI mapUser(DirectExportContext ctx, String user) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(user);
        if (userRef != null) {
            UserRef userRef2 = userRef;
            boolean bl = false;
            MRI mri = ctx.getUserMRI(user);
            if (mri == null) {
                MRI userRefMri = this.usersExportService.userRef(ctx.getProjectExportContext(), userRef2);
                String string = user;
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    ctx.trackUser(it, userRefMri);
                }
                mRI = userRefMri;
            } else {
                mRI = mri;
            }
        } else {
            mRI = null;
        }
        return mRI;
    }

    public final void prepareDirectExportContext(long projectId, @NotNull DirectExportContext ctx, boolean migrateArchivedIssues) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List<Long> projectVersionIdsInProject = this.projectVersionDataReader.getProjectVersionIdByProjectId(projectId);
        List<Long> componentIdsInProject = this.componentReader.getAllProjectComponentIdByProjectId(projectId);
        ctx.setFixVersionIssues((Map<Long, Long[]>)this.issueDirectReader.getAllFixVersionsGroupByIssueIds(projectId, migrateArchivedIssues, projectVersionIdsInProject));
        ctx.setAffectedVersionIssues((Map<Long, Long[]>)this.issueDirectReader.getAllAffectedVersionsGroupByIssueIds(projectId, migrateArchivedIssues, projectVersionIdsInProject));
        ctx.setProjectComponentIssues((Map<Long, Long[]>)this.issueDirectReader.getAllProjectComponentGroupByIssueId(projectId, migrateArchivedIssues, componentIdsInProject));
        ctx.setLabels((Map<Long, String[]>)this.issueDirectReader.getAllLabelsGroupByIssueId(projectId, migrateArchivedIssues));
        ctx.setMovedIssueKey((Map<Long, String[]>)this.issueDirectReader.getAllMovedIssueKeyGroupByIssueId(projectId, migrateArchivedIssues));
        ctx.setDefaultPriority(this.defaultPriority(projectId, ctx));
    }

    private final MRI getPriority(DBIssue dbIssue, DirectExportContext ctx) {
        MRI mRI;
        if (dbIssue.getPriority() != null) {
            return ctx.generateMriAndTrack(Priority.Companion.getEntityType(), dbIssue.getPriority());
        }
        String string = ctx.getDefaultPriority();
        if (string != null) {
            String it = string;
            boolean bl = false;
            mRI = ctx.generateMriAndTrack(Priority.Companion.getEntityType(), it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final String defaultPriority(long projectId, DirectExportContext ctx) {
        String priorityId = null;
        Long fieldScheme = this.issueDirectReader.getConfigurationContextForProject(projectId);
        if (fieldScheme == null) {
            return null;
        }
        List<Long> defaultFieldConfiguration = this.issueDirectReader.getDefaultFieldConfiguration(fieldScheme);
        if (defaultFieldConfiguration.isEmpty()) {
            return null;
        }
        long fieldConfig = ((Number)defaultFieldConfiguration.get(0)).longValue();
        String defaultFieldConfigurationValue = this.issueDirectReader.getDefaultConfigurationValue(fieldConfig);
        priorityId = defaultFieldConfigurationValue == null ? this.getOptionPriority(fieldConfig) : this.extractPriority(defaultFieldConfigurationValue);
        if (priorityId != null) {
            String priority = this.issueDirectReader.getPriority(priorityId);
            return priority;
        }
        return null;
    }

    private final String getOptionPriority(long configurationContextFieldScheme) {
        List<String> optionPriorities = this.issueDirectReader.getOptionPriority(configurationContextFieldScheme);
        if (optionPriorities.isEmpty()) {
            return null;
        }
        return optionPriorities.get((int)Math.max((double)((optionPriorities.size() + 1) / 2 - 1), 0.0));
    }

    private final String extractPriority(String priority) {
        Regex regex = new Regex("<string>(.*?)</string>");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)priority, (int)0, (int)2, null);
        MatchResult matchResult2 = matchResult;
        String extractedValue = matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null && (matchResult2 = matchResult2.get(1)) != null ? matchResult2.getValue() : null;
        String string = extractedValue;
        if (string == null) {
            string = "0";
        }
        return string;
    }

    public static final /* synthetic */ MRI access$mriForEntity(IssueDirectExport $this, DBIssue entity) {
        return $this.mriForEntity(entity);
    }

    public static final /* synthetic */ IssueValidator access$getIssueValidator$p(IssueDirectExport $this) {
        return $this.issueValidator;
    }

    public static final /* synthetic */ IssueTypeManager access$getIssueTypeManager$p(IssueDirectExport $this) {
        return $this.issueTypeManager;
    }

    public static final /* synthetic */ EntityIdentifierGenerator access$getEntityIdentifierGenerator$p(IssueDirectExport $this) {
        return $this.entityIdentifierGenerator;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(IssueDirectExport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        ukLocale = new Locale("en_UK");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/export/directexport/IssueDirectExport$Companion;", "", "()V", "BLANK_SUMMARY", "", "log", "Lorg/slf4j/Logger;", "ukLocale", "Ljava/util/Locale;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

