/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.log.ExportMessageFormatter;
import com.atlassian.jira.migration.utils.IssueTypeSchemeManagerCache;
import com.atlassian.migration.base.mri.MRI;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/export/directexport/IssueValidator;", "", "issueTypeSchemeManagerCache", "Lcom/atlassian/jira/migration/utils/IssueTypeSchemeManagerCache;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "(Lcom/atlassian/jira/migration/utils/IssueTypeSchemeManagerCache;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;)V", "issueTypeValidator", "", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "issueType", "Lcom/atlassian/jira/issue/issuetype/IssueType;", "mri", "Lcom/atlassian/migration/base/mri/MRI;", "jira-migration-plugin"})
public final class IssueValidator {
    @NotNull
    private final IssueTypeSchemeManagerCache issueTypeSchemeManagerCache;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;

    @Inject
    public IssueValidator(@NotNull IssueTypeSchemeManagerCache issueTypeSchemeManagerCache, @NotNull EntityIdentifierGenerator identifierGenerator) {
        Intrinsics.checkNotNullParameter((Object)issueTypeSchemeManagerCache, (String)"issueTypeSchemeManagerCache");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        this.issueTypeSchemeManagerCache = issueTypeSchemeManagerCache;
        this.identifierGenerator = identifierGenerator;
    }

    public final void issueTypeValidator(@NotNull DirectExportContext ctx, @Nullable IssueType issueType, @NotNull MRI mri) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
        if (issueType == null) {
            String string = EntityIdentifierGenerator.generate$default(this.identifierGenerator, mri, null, null, 6, null) + " has no issue type";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_ISSUE_HAS_NO_TYPE;
            throw new ExportException(mri, exportErrorCode, string, "Assign an issue type to this issue.", null, null, null, 112, null);
        }
        Collection validIssueTypesInProject = this.issueTypeSchemeManagerCache.getIssueTypesForProject(ctx.getProject());
        if (!issueType.isSubTask() && !validIssueTypesInProject.contains(issueType)) {
            String string = EntityIdentifierGenerator.generate$default(this.identifierGenerator, mri, null, null, 6, null) + " has invalid issue type";
            String string2 = ExportMessageFormatter.INSTANCE.getTroubleshootingExportErrorGuide();
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_MISSING_ISSUETYPE;
            throw new ExportException(mri, exportErrorCode, string, string2, null, null, null, 112, null);
        }
    }
}

