/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.directexport.AbstractCommentExport;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.mapper.DBComment;
import com.atlassian.jira.migration.export.directexport.mapper.ServiceDeskDirectCommentData;
import com.atlassian.jira.migration.export.service.UsersExportService;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.workers.attachments.TextFieldConverterService;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.core.text.TextDocument;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.servicedesk.Comment;
import java.sql.Timestamp;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/export/directexport/JsdCommentDirectExport;", "Lcom/atlassian/jira/migration/export/directexport/AbstractCommentExport;", "jsdExportUtil", "Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "textFieldConverterService", "Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "usersExportService", "Lcom/atlassian/jira/migration/export/service/UsersExportService;", "(Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/service/UsersExportService;)V", "exportComment", "Lcom/atlassian/migration/base/IdentifiableEntity;", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "comment", "Lcom/atlassian/jira/migration/export/directexport/mapper/DBComment;", "exportServiceDeskComments", "sdData", "Lcom/atlassian/jira/migration/export/directexport/mapper/ServiceDeskDirectCommentData;", "isPublic", "", "jira-migration-plugin"})
public final class JsdCommentDirectExport
extends AbstractCommentExport {
    @NotNull
    private final JsdExportUtil jsdExportUtil;

    @Inject
    public JsdCommentDirectExport(@NotNull JsdExportUtil jsdExportUtil, @NotNull TextFieldConverterService textFieldConverterService, @NotNull MigrationFeatures migrationFeatures, @NotNull UsersExportService usersExportService) {
        Intrinsics.checkNotNullParameter((Object)jsdExportUtil, (String)"jsdExportUtil");
        Intrinsics.checkNotNullParameter((Object)textFieldConverterService, (String)"textFieldConverterService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)usersExportService, (String)"usersExportService");
        super(textFieldConverterService, migrationFeatures, usersExportService);
        this.jsdExportUtil = jsdExportUtil;
    }

    @Override
    @NotNull
    public IdentifiableEntity exportComment(@NotNull DirectExportContext ctx, @NotNull DBComment comment) {
        IdentifiableEntity identifiableEntity;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        if (this.jsdExportUtil.isJsdProjectEligibleForMigration(ctx.getProjectExportContext())) {
            boolean isPublic = ctx.getProjectExportContext().isPublicComment(comment.getId());
            ServiceDeskDirectCommentData sdCommentData = new ServiceDeskDirectCommentData(comment, isPublic);
            identifiableEntity = this.exportServiceDeskComments(ctx, sdCommentData, isPublic);
        } else {
            identifiableEntity = this.exportJiraComments(ctx, comment);
        }
        return identifiableEntity;
    }

    private final IdentifiableEntity exportServiceDeskComments(DirectExportContext ctx, ServiceDeskDirectCommentData sdData, boolean isPublic) {
        MRI mRI = ctx.generateMriAndTrack(Comment.Companion.getEntityType(), sdData.getComment().getId());
        MRI mRI2 = ctx.generateMriAndTrack(Issue.Companion.getEntityType(), sdData.getComment().getIssueId());
        TextDocument textDocument = this.mapBody(ctx.getProjectExportContext(), sdData.getComment(), "issue " + sdData.getComment().getIssueId() + " comment " + sdData.getComment().getId());
        MRI mRI3 = this.mapUser(ctx, sdData.getComment().getAuthor());
        MRI mRI4 = this.mapUser(ctx, sdData.getComment().getUpdateAuthor());
        Instant instant = sdData.getComment().getCreated().toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        Timestamp timestamp = sdData.getComment().getUpdated();
        return (IdentifiableEntity)new Comment(mRI, mRI2, textDocument, mRI3, mRI4, instant, timestamp != null ? timestamp.toInstant() : null, this.mapVisibility(ctx, sdData.getComment()), isPublic);
    }
}

