/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.migration.export.core.attachment.AttachmentForMedia;
import com.atlassian.jira.migration.export.core.attachment.AttachmentMetadata;
import com.atlassian.jira.migration.export.directexport.DirectExport;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.db.reader.MediaAttachmentDirectReader;
import com.atlassian.jira.migration.export.directexport.mapper.MediaAttachmentMetaData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.framework.ProjectExportContext;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.UsersExportService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.reports.ProblemType;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIType;
import com.atlassian.migration.core.MigrationCoreMriRegistry;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.attachment.FileAttachment;
import com.atlassian.migration.jira.core.attachment.MediaStoreAttachment;
import com.google.common.net.MediaType;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0019H\u0002J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/export/directexport/MediaAttachmentDirectExport;", "Lcom/atlassian/jira/migration/export/directexport/DirectExport;", "mediaAttachmentDirectReader", "Lcom/atlassian/jira/migration/export/directexport/db/reader/MediaAttachmentDirectReader;", "usersExportService", "Lcom/atlassian/jira/migration/export/service/UsersExportService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/directexport/db/reader/MediaAttachmentDirectReader;Lcom/atlassian/jira/migration/export/service/UsersExportService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "jiraProject", "Lcom/atlassian/jira/project/Project;", "exportMedia", "mediaAttachmentData", "Lcom/atlassian/jira/migration/export/directexport/mapper/MediaAttachmentMetaData;", "fileAttachmentExporter", "attachment", "Lcom/atlassian/jira/migration/export/core/attachment/AttachmentMetadata;", "mapAuthor", "Lcom/atlassian/migration/base/mri/MRI;", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "mediaStoreAttachmentExporter", "Lcom/atlassian/jira/migration/export/core/attachment/AttachmentForMedia;", "toInt", "", "", "(Ljava/lang/Boolean;)Ljava/lang/Integer;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMediaAttachmentDirectExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaAttachmentDirectExport.kt\ncom/atlassian/jira/migration/export/directexport/MediaAttachmentDirectExport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class MediaAttachmentDirectExport
extends DirectExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MediaAttachmentDirectReader mediaAttachmentDirectReader;
    @NotNull
    private final UsersExportService usersExportService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private static final Logger log;

    @Inject
    public MediaAttachmentDirectExport(@NotNull MediaAttachmentDirectReader mediaAttachmentDirectReader, @NotNull UsersExportService usersExportService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)mediaAttachmentDirectReader, (String)"mediaAttachmentDirectReader");
        Intrinsics.checkNotNullParameter((Object)usersExportService, (String)"usersExportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.mediaAttachmentDirectReader = mediaAttachmentDirectReader;
        this.usersExportService = usersExportService;
        this.migrationFeatures = migrationFeatures;
    }

    @Override
    public void export(@NotNull DirectExportContext ctx, @NotNull Project jiraProject) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraProject, (String)"jiraProject");
        log.info("Direct export MediaAttachment started for : " + jiraProject.getKey());
        boolean shouldMigrateArchivedIssues = MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getProjectExportContext().getMigrateArchivedIssues());
        Long l = jiraProject.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        this.mediaAttachmentDirectReader.fetchMediaAttachments(((Number)l).longValue(), shouldMigrateArchivedIssues, (Function1<? super MediaAttachmentMetaData, Unit>)((Function1)new Function1<MediaAttachmentMetaData, Unit>(this, ctx){
            final /* synthetic */ MediaAttachmentDirectExport this$0;
            final /* synthetic */ DirectExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            public final void invoke(@NotNull MediaAttachmentMetaData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MediaAttachmentDirectExport.access$exportMedia(this.this$0, this.$ctx, it);
            }
        }));
        log.info("Direct export MediaAttachment finished for : " + jiraProject.getKey());
    }

    private final void exportMedia(DirectExportContext ctx, MediaAttachmentMetaData mediaAttachmentData) {
        if (mediaAttachmentData.getFileName() == null) {
            ExportContext.handleUnsupported$default(ctx.originalContext(), String.valueOf(mediaAttachmentData.getId()), "Attachment", ProblemType.NULL_FILENAME_ATTACHMENT.toString(), null, null, null, 56, null);
            return;
        }
        long l = mediaAttachmentData.getId();
        Long l2 = mediaAttachmentData.getIssueId();
        Intrinsics.checkNotNull((Object)l2);
        long l3 = l2;
        String string = mediaAttachmentData.getAuthor();
        String string2 = mediaAttachmentData.getMimeType();
        String string3 = mediaAttachmentData.getFileName();
        Timestamp timestamp = mediaAttachmentData.getCreated();
        Long l4 = mediaAttachmentData.getFileSize();
        Intrinsics.checkNotNull((Object)l4);
        AttachmentMetadata attachment = new AttachmentMetadata(l, l3, string, string2, string3, timestamp, l4, mediaAttachmentData.getThumbnailable(), mediaAttachmentData.getZip());
        AttachmentForMedia attachmentForMedia = new AttachmentForMedia(attachment.getId());
        this.fileAttachmentExporter(ctx, attachment);
        this.mediaStoreAttachmentExporter(ctx, attachmentForMedia);
    }

    private final void fileAttachmentExporter(DirectExportContext ctx, AttachmentMetadata attachment) {
        MRI mRI = MriExtensionsKt.mri$default(FileAttachment.Companion.getEntityType(), attachment.getId(), null, 2, null);
        MRI mRI2 = MriExtensionsKt.mri$default(Issue.Companion.getEntityType(), attachment.getIssueId(), null, 2, null);
        MRI mRI3 = this.mapAuthor(ctx.originalContext(), attachment);
        String string = attachment.getMimeType();
        if (string == null) {
            String string2 = MediaType.OCTET_STREAM.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String string3 = string;
        String string4 = attachment.getFilename();
        Comparable<Date> comparable = attachment.getCreated();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.now();
        }
        Comparable<Date> comparable2 = comparable;
        long l = attachment.getFilesize();
        Comparable<Boolean> comparable3 = attachment.getThumbnailable();
        int n = comparable3 != null && (comparable3 = this.toInt((Boolean)comparable3)) != null ? (Integer)comparable3 : 0;
        Comparable<Boolean> comparable4 = attachment.getZip();
        int n2 = comparable4 != null && (comparable4 = this.toInt((Boolean)comparable4)) != null ? (Integer)comparable4 : 0;
        Intrinsics.checkNotNull((Object)comparable2);
        FileAttachment fileAttachment = new FileAttachment(mRI, mRI2, string3, string4, (Instant)comparable2, l, mRI3, Integer.valueOf(n2), Integer.valueOf(n));
        ctx.put(fileAttachment.getId(), (IdentifiableEntity)fileAttachment);
    }

    private final void mediaStoreAttachmentExporter(DirectExportContext ctx, AttachmentForMedia attachment) {
        if (!(ctx.originalContext() instanceof ProjectExportContext)) {
            throw new IllegalArgumentException("MediaStoreAttachmentExporter requires ProjectExportContext to export data");
        }
        String mediaId = (String)ctx.getProjectExportContext().getAttachmentMediaIdResolver().invoke((Object)attachment.getAttachmentId());
        MRI mRI = MriExtensionsKt.mri$default(MediaStoreAttachment.Companion.getEntityType(), attachment.getAttachmentId(), null, 2, null);
        MRI mRI2 = MriExtensionsKt.mri$default(FileAttachment.Companion.getEntityType(), attachment.getAttachmentId(), null, 2, null);
        MediaStoreAttachment.ThumbnailStatus thumbnailStatus = MediaStoreAttachment.ThumbnailStatus.IN_PROGRESS;
        MRI mRI3 = MriExtensionsKt.mri(MigrationCoreMriRegistry.INSTANCE.getMediaFile(), mediaId, MRIType.RESULTING);
        MediaStoreAttachment mediaStoreAttachment = new MediaStoreAttachment(mRI, mRI2, mediaId, mRI3, thumbnailStatus);
        ctx.put(mediaStoreAttachment.getId(), (IdentifiableEntity)mediaStoreAttachment);
    }

    private final Integer toInt(Boolean $this$toInt) {
        Integer n;
        Boolean bl = $this$toInt;
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            n = it ? 1 : 0;
        } else {
            n = null;
        }
        return n;
    }

    private final MRI mapAuthor(ExportContext ctx, AttachmentMetadata attachment) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(attachment.getAuthorKey());
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.usersExportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    public static final /* synthetic */ void access$exportMedia(MediaAttachmentDirectExport $this, DirectExportContext ctx, MediaAttachmentMetaData mediaAttachmentData) {
        $this.exportMedia(ctx, mediaAttachmentData);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(MediaAttachmentDirectExport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/directexport/MediaAttachmentDirectExport$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

