/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.notification.NotificationInstanceData;
import com.atlassian.jira.migration.export.directexport.DirectExport;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.db.reader.NotificationInstanceDirectReader;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.servicedesk.NotificationInstance;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/export/directexport/NotificationInstanceDirectExport;", "Lcom/atlassian/jira/migration/export/directexport/DirectExport;", "jsdExportUtil", "Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "notificationInstanceDirectReader", "Lcom/atlassian/jira/migration/export/directexport/db/reader/NotificationInstanceDirectReader;", "(Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/directexport/db/reader/NotificationInstanceDirectReader;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "jiraProject", "Lcom/atlassian/jira/project/Project;", "exportNotificationInstance", "Lcom/atlassian/migration/base/IdentifiableEntity;", "notificationInstanceData", "Lcom/atlassian/jira/migration/export/db/servicedesk/notification/NotificationInstanceData;", "Companion", "jira-migration-plugin"})
public final class NotificationInstanceDirectExport
extends DirectExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsdExportUtil jsdExportUtil;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final NotificationInstanceDirectReader notificationInstanceDirectReader;
    @NotNull
    private static final Logger log;

    @Inject
    public NotificationInstanceDirectExport(@NotNull JsdExportUtil jsdExportUtil, @NotNull MigrationFeatures migrationFeatures, @NotNull NotificationInstanceDirectReader notificationInstanceDirectReader) {
        Intrinsics.checkNotNullParameter((Object)jsdExportUtil, (String)"jsdExportUtil");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)notificationInstanceDirectReader, (String)"notificationInstanceDirectReader");
        this.jsdExportUtil = jsdExportUtil;
        this.migrationFeatures = migrationFeatures;
        this.notificationInstanceDirectReader = notificationInstanceDirectReader;
    }

    @Override
    public void export(@NotNull DirectExportContext ctx, @NotNull Project jiraProject) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraProject, (String)"jiraProject");
        if (this.jsdExportUtil.isJsdProjectEligibleForMigration(ctx.getProjectExportContext()) && this.migrationFeatures.getEnableNotificationInstancesMigration()) {
            log.info("Direct export Notification instance started for : " + jiraProject.getKey());
            boolean shouldMigrateArchivedIssues = MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getProjectExportContext().getMigrateArchivedIssues());
            Long l = jiraProject.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            this.notificationInstanceDirectReader.fetchNotificationInstances(((Number)l).longValue(), shouldMigrateArchivedIssues, (Function1<? super NotificationInstanceData, Unit>)((Function1)new Function1<NotificationInstanceData, Unit>(this, ctx){
                final /* synthetic */ NotificationInstanceDirectExport this$0;
                final /* synthetic */ DirectExportContext $ctx;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                    super(1);
                }

                public final void invoke(@NotNull NotificationInstanceData it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IdentifiableEntity exportNotificationInstance = NotificationInstanceDirectExport.access$exportNotificationInstance(this.this$0, this.$ctx, it);
                    this.$ctx.put(exportNotificationInstance.getId(), exportNotificationInstance);
                }
            }));
            log.info("Direct export Notification instance finished for : " + jiraProject.getKey());
        }
    }

    private final IdentifiableEntity exportNotificationInstance(DirectExportContext ctx, NotificationInstanceData notificationInstanceData) {
        return (IdentifiableEntity)new NotificationInstance(ctx.generateMri(NotificationInstance.Companion.getEntityType(), notificationInstanceData.getId()), notificationInstanceData.getNotificationType(), ctx.generateMri(Issue.Companion.getEntityType(), notificationInstanceData.getSource()), notificationInstanceData.getEmailAddress(), notificationInstanceData.getMessageId(), null, 32, null);
    }

    public static final /* synthetic */ IdentifiableEntity access$exportNotificationInstance(NotificationInstanceDirectExport $this, DirectExportContext ctx, NotificationInstanceData notificationInstanceData) {
        return $this.exportNotificationInstance(ctx, notificationInstanceData);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(NotificationInstanceDirectExport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/export/directexport/NotificationInstanceDirectExport$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

