/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport;

import com.atlassian.jira.migration.export.directexport.DirectExport;
import com.atlassian.jira.migration.export.directexport.DirectExportContext;
import com.atlassian.jira.migration.export.directexport.db.reader.WorklogDirectReader;
import com.atlassian.jira.migration.export.directexport.mapper.WorklogData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.UsersExportService;
import com.atlassian.jira.migration.export.utils.TextSanitizer;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.jiraservice.JiraGroupManager;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.core.text.TextDocument;
import com.atlassian.migration.jira.classic.worklogs.Worklog;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.projectrole.ProjectRole;
import java.sql.Timestamp;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001cH\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/export/directexport/WorklogDirectExport;", "Lcom/atlassian/jira/migration/export/directexport/DirectExport;", "worklogDirectReader", "Lcom/atlassian/jira/migration/export/directexport/db/reader/WorklogDirectReader;", "usersExportService", "Lcom/atlassian/jira/migration/export/service/UsersExportService;", "jiraGroupManager", "Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;", "projectRoleManager", "Lcom/atlassian/jira/security/roles/ProjectRoleManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/directexport/db/reader/WorklogDirectReader;Lcom/atlassian/jira/migration/export/service/UsersExportService;Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;Lcom/atlassian/jira/security/roles/ProjectRoleManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/directexport/DirectExportContext;", "jiraProject", "Lcom/atlassian/jira/project/Project;", "exportWorklog", "Lcom/atlassian/migration/base/IdentifiableEntity;", "worklogData", "Lcom/atlassian/jira/migration/export/directexport/mapper/WorklogData;", "hasValidVisibility", "", "mapAuthor", "Lcom/atlassian/migration/base/mri/MRI;", "user", "", "mapComment", "Lcom/atlassian/migration/core/text/TextDocument;", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "truncateMessage", "mapVisibility", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nWorklogDirectExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorklogDirectExport.kt\ncom/atlassian/jira/migration/export/directexport/WorklogDirectExport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class WorklogDirectExport
extends DirectExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorklogDirectReader worklogDirectReader;
    @NotNull
    private final UsersExportService usersExportService;
    @NotNull
    private final JiraGroupManager jiraGroupManager;
    @NotNull
    private final ProjectRoleManager projectRoleManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private static final Logger log;

    @Inject
    public WorklogDirectExport(@NotNull WorklogDirectReader worklogDirectReader, @NotNull UsersExportService usersExportService, @NotNull JiraGroupManager jiraGroupManager, @NotNull ProjectRoleManager projectRoleManager, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)worklogDirectReader, (String)"worklogDirectReader");
        Intrinsics.checkNotNullParameter((Object)usersExportService, (String)"usersExportService");
        Intrinsics.checkNotNullParameter((Object)jiraGroupManager, (String)"jiraGroupManager");
        Intrinsics.checkNotNullParameter((Object)projectRoleManager, (String)"projectRoleManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.worklogDirectReader = worklogDirectReader;
        this.usersExportService = usersExportService;
        this.jiraGroupManager = jiraGroupManager;
        this.projectRoleManager = projectRoleManager;
        this.migrationFeatures = migrationFeatures;
    }

    @Override
    public void export(@NotNull DirectExportContext ctx, @NotNull Project jiraProject) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraProject, (String)"jiraProject");
        log.info("Direct export Worklog started for : " + jiraProject.getKey());
        boolean shouldMigrateArchivedIssues = MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssuesAsActiveOrArchived(this.migrationFeatures, ctx.getProjectExportContext().getMigrateArchivedIssues());
        Long l = jiraProject.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        this.worklogDirectReader.fetchWorklogs(((Number)l).longValue(), shouldMigrateArchivedIssues, (Function1<? super WorklogData, Unit>)((Function1)new Function1<WorklogData, Unit>(this, ctx){
            final /* synthetic */ WorklogDirectExport this$0;
            final /* synthetic */ DirectExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            public final void invoke(@NotNull WorklogData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (WorklogDirectExport.access$hasValidVisibility(this.this$0, it)) {
                    IdentifiableEntity exportWorklog = WorklogDirectExport.access$exportWorklog(this.this$0, this.$ctx, it);
                    this.$ctx.put(exportWorklog.getId(), exportWorklog);
                }
            }
        }));
        log.info("Direct export Worklog finished for : " + jiraProject.getKey());
    }

    private final IdentifiableEntity exportWorklog(DirectExportContext ctx, WorklogData worklogData) {
        MRI mRI = ctx.generateMri(Worklog.Companion.getEntityType(), worklogData.getId());
        EntityType entityType = Issue.Companion.getEntityType();
        Long l = worklogData.getIssueId();
        Intrinsics.checkNotNull((Object)l);
        MRI mRI2 = ctx.generateMri(entityType, l);
        MRI mRI3 = this.mapAuthor(ctx, worklogData.getAuthor());
        MRI mRI4 = this.mapAuthor(ctx, worklogData.getUpdateAuthor());
        TextDocument textDocument = this.mapComment(ctx.getProjectExportContext(), worklogData, "worklog " + worklogData.getId() + " comment");
        Instant instant = worklogData.getCreated().toInstant();
        Timestamp timestamp = worklogData.getUpdated();
        Instant instant2 = timestamp != null ? timestamp.toInstant() : null;
        Timestamp timestamp2 = worklogData.getStartDate();
        Instant instant3 = timestamp2 != null ? timestamp2.toInstant() : null;
        Long l2 = worklogData.getTimeWorked();
        Intrinsics.checkNotNull((Object)l2);
        long l3 = l2;
        MRI mRI5 = this.mapVisibility(ctx, worklogData);
        Intrinsics.checkNotNull((Object)instant);
        return (IdentifiableEntity)new Worklog(mRI, mRI2, mRI3, mRI4, textDocument, instant, instant2, mRI5, instant3, l3, null, 1024, null);
    }

    private final MRI mapAuthor(DirectExportContext ctx, String user) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(user);
        if (userRef != null) {
            UserRef userRef2 = userRef;
            boolean bl = false;
            MRI mri = ctx.getUserMRI(user);
            if (mri == null) {
                MRI userRefMri = this.usersExportService.userRef(ctx.getProjectExportContext(), userRef2);
                String string = user;
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    ctx.trackUser(it, userRefMri);
                }
                mRI = userRefMri;
            } else {
                mRI = mri;
            }
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final TextDocument mapComment(ExportContext ctx, WorklogData worklogData, String truncateMessage) {
        String string = worklogData.getWorklogBody();
        if (string == null) {
            string = "";
        }
        String it = TextSanitizer.sanitizedText$default(TextSanitizer.INSTANCE, string, log, truncateMessage, 0, 8, null);
        boolean bl = false;
        this.usersExportService.extractUserRefs(ctx, it);
        return (TextDocument)new TextDocument.Wiki(it);
    }

    static /* synthetic */ TextDocument mapComment$default(WorklogDirectExport worklogDirectExport, ExportContext exportContext, WorklogData worklogData, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return worklogDirectExport.mapComment(exportContext, worklogData, string);
    }

    private final MRI mapVisibility(DirectExportContext ctx, WorklogData worklogData) {
        String string;
        block6: {
            block5: {
                string = worklogData.getGroupLevel();
                if (string == null) break block5;
                String it = string;
                boolean bl = false;
                DirectExportContext.addGroupToExportContext$default(ctx, new GroupRefModel(it, "Jira Worklog ", String.valueOf(worklogData.getId())).getGroupName(), false, 2, null);
                MRI mRI = this.usersExportService.groupRef(new GroupRefModel(it, "Jira Worklog ", String.valueOf(worklogData.getId())));
                string = mRI;
                if (mRI != null) break block6;
            }
            Long l = worklogData.getProjectroleId();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                string = ctx.generateMriAndTrack(ProjectRole.Companion.getEntityType(), worklogData.getProjectroleId());
            } else {
                string = null;
            }
        }
        return string;
    }

    private final boolean hasValidVisibility(WorklogData worklogData) {
        boolean bl;
        String string = worklogData.getGroupLevel();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = this.jiraGroupManager.isValidGroup(it);
        } else {
            Long l = worklogData.getRoleLevelId();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                bl = JiraExtensionsKt.isValidRole(this.projectRoleManager, it);
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasValidVisibility(WorklogDirectExport $this, WorklogData worklogData) {
        return $this.hasValidVisibility(worklogData);
    }

    public static final /* synthetic */ IdentifiableEntity access$exportWorklog(WorklogDirectExport $this, DirectExportContext ctx, WorklogData worklogData) {
        return $this.exportWorklog(ctx, worklogData);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(WorklogDirectExport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/export/directexport/WorklogDirectExport$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

