/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport.db.reader;

import com.atlassian.jira.migration.db.CommentTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.db.JiraIssueTableWithArchivedColumns;
import com.atlassian.jira.migration.db.ProjectRoleTable;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.jira.migration.export.directexport.db.reader.CommentsDirectReader;
import com.atlassian.jira.migration.export.directexport.mapper.DBComment;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.schema.SchemaStateProvider;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.google.common.annotations.VisibleForTesting;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u0015R!\u0010\u0007\u001a\u00020\b8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/directexport/db/reader/CommentsDirectReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "schemaStateProvider", "Lcom/atlassian/pocketknife/api/querydsl/schema/SchemaStateProvider;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/pocketknife/api/querydsl/schema/SchemaStateProvider;)V", "archivedFieldExists", "", "getArchivedFieldExists$annotations", "()V", "getArchivedFieldExists", "()Z", "archivedFieldExists$delegate", "Lkotlin/Lazy;", "fetchComments", "", "projectId", "", "migrateArchivedIssues", "block", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/export/directexport/mapper/DBComment;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCommentsDirectReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentsDirectReader.kt\ncom/atlassian/jira/migration/export/directexport/db/reader/CommentsDirectReader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,88:1\n1313#2,2:89\n*S KotlinDebug\n*F\n+ 1 CommentsDirectReader.kt\ncom/atlassian/jira/migration/export/directexport/db/reader/CommentsDirectReader\n*L\n69#1:89,2\n*E\n"})
public final class CommentsDirectReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final SchemaStateProvider schemaStateProvider;
    @NotNull
    private final Lazy archivedFieldExists$delegate;
    @NotNull
    private static final Logger log;

    @Inject
    public CommentsDirectReader(@NotNull DatabaseAccessor databaseAccessor, @NotNull SchemaStateProvider schemaStateProvider) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)schemaStateProvider, (String)"schemaStateProvider");
        this.databaseAccessor = databaseAccessor;
        this.schemaStateProvider = schemaStateProvider;
        this.archivedFieldExists$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ CommentsDirectReader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return (Boolean)CommentsDirectReader.access$getDatabaseAccessor$p(this.this$0).run(arg_0 -> archivedFieldExists.2.invoke$lambda$1(this.this$0, arg_0), OnRollback.NOOP);
            }

            /*
             * WARNING - void declaration
             */
            private static final Boolean invoke$lambda$1(CommentsDirectReader this$0, DatabaseConnection db) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Set set = CommentsDirectReader.access$getSchemaStateProvider$p(this$0).getSchemaState(db.getJdbcConnection(), (RelationalPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE()).getAddedColumns();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAddedColumns(...)");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    void var11_11 = it;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string2 = var11_11.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    collection.add(string2);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).contains("archived");
            }
        }));
    }

    public final boolean getArchivedFieldExists() {
        Lazy lazy = this.archivedFieldExists$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Boolean)object;
    }

    @VisibleForTesting
    public static /* synthetic */ void getArchivedFieldExists$annotations() {
    }

    public final void fetchComments(long projectId, boolean migrateArchivedIssues, @NotNull Function1<? super DBComment, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        log.info("Executing db query for fetching comments associated with projectId: " + projectId);
        try {
            JiraIssueTable issueTable = this.getArchivedFieldExists() ? (JiraIssueTable)new JiraIssueTableWithArchivedColumns() : JiraIssueTable.Companion.getJIRA_ISSUE_TABLE();
            this.databaseAccessor.run(arg_0 -> CommentsDirectReader.fetchComments$lambda$0(issueTable, projectId, migrateArchivedIssues, block, arg_0), OnRollback.NOOP);
        }
        catch (Exception e) {
            log.error("Failed to fetch comments for project: " + projectId, (Throwable)e);
            throw e;
        }
        log.info("Finished fetching comments for project: " + projectId);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit fetchComments$lambda$0(JiraIssueTable $issueTable, long $projectId, boolean $migrateArchivedIssues, Function1 $block, DatabaseConnection db) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)$issueTable), (String)"$issueTable");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)CommentTable.INSTANCE.all());
        spreadBuilder.addSpread((Object)ProjectRoleTable.INSTANCE.all());
        CloseableIterator closeableIterator = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])spreadBuilder.toArray((Object[])new Expression[spreadBuilder.size()])).from((Expression)CommentTable.INSTANCE)).leftJoin((EntityPath)ProjectRoleTable.INSTANCE)).on((Predicate)ProjectRoleTable.INSTANCE.getID().eq((Expression)CommentTable.INSTANCE.getROLE_LEVEL()))).innerJoin((EntityPath)$issueTable)).on((Predicate)CommentTable.INSTANCE.getISSUE_ID().eq((Expression)$issueTable.getID()))).where((Predicate)JiraIssueReader.Companion.belongsToProject($projectId, $issueTable, $migrateArchivedIssues))).iterate();
        Intrinsics.checkNotNullExpressionValue((Object)closeableIterator, (String)"iterate(...)");
        closeableIterator = SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)((Iterator)closeableIterator)), (Function1)((Function1)new Function1<Tuple, DBComment>((Object)DBComment.Companion){

            @NotNull
            public final DBComment invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DBComment.Companion)this.receiver).buildComments(p0);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            $block.invoke(element$iv);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ DatabaseAccessor access$getDatabaseAccessor$p(CommentsDirectReader $this) {
        return $this.databaseAccessor;
    }

    public static final /* synthetic */ SchemaStateProvider access$getSchemaStateProvider$p(CommentsDirectReader $this) {
        return $this.schemaStateProvider;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(CommentsDirectReader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/directexport/db/reader/CommentsDirectReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

