/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.directexport.utils;

import com.atlassian.jira.migration.export.directexport.mapper.DBIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.opensymphony.module.propertyset.PropertySet;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/export/directexport/utils/IssueExportUtils;", "", "projectPropertiesManager", "Lcom/atlassian/jira/project/ProjectPropertiesManager;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/project/ProjectPropertiesManager;Lcom/atlassian/jira/project/ProjectManager;)V", "getIsArchived", "", "dbIssue", "Lcom/atlassian/jira/migration/export/directexport/mapper/DBIssue;", "projectId", "", "isIssueActiveUnderArchivedProject", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueExportUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueExportUtils.kt\ncom/atlassian/jira/migration/export/directexport/utils/IssueExportUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n1#2:34\n*E\n"})
public final class IssueExportUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectPropertiesManager projectPropertiesManager;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    public static final String IS_ARCHIVED_KEY = "jira.archiving.projects";

    @Inject
    public IssueExportUtils(@NotNull ProjectPropertiesManager projectPropertiesManager, @NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)projectPropertiesManager, (String)"projectPropertiesManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.projectPropertiesManager = projectPropertiesManager;
        this.projectManager = projectManager;
    }

    public final boolean getIsArchived(@NotNull DBIssue dbIssue, long projectId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dbIssue, (String)"dbIssue");
        if (this.isIssueActiveUnderArchivedProject(dbIssue, projectId)) {
            bl = false;
        } else {
            String string = dbIssue.getArchived();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = !Intrinsics.areEqual((Object)it, (Object)"N");
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIssueActiveUnderArchivedProject(DBIssue dbIssue, long projectId) {
        PropertySet propertySet;
        Project projectObject = this.projectManager.getProjectObj(Long.valueOf(projectId));
        PropertySet propertySet2 = this.projectPropertiesManager.getPropertySet(projectObject);
        if (propertySet2 == null) return false;
        PropertySet it = propertySet = propertySet2;
        boolean bl = false;
        if (!it.exists(IS_ARCHIVED_KEY)) return false;
        PropertySet propertySet3 = propertySet;
        PropertySet propertySet4 = propertySet3;
        if (propertySet4 == null) return false;
        boolean bl2 = propertySet4.getBoolean(IS_ARCHIVED_KEY);
        boolean isProjectArchived = bl2;
        if (!isProjectArchived) return false;
        if (dbIssue.getArchivedDate() != null) return false;
        if (dbIssue.getArchivedBy() != null) return false;
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/directexport/utils/IssueExportUtils$Companion;", "", "()V", "IS_ARCHIVED_KEY", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

