/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.framework;

import com.atlassian.jira.migration.export.framework.ExportEventHandler;
import com.atlassian.jira.migration.export.model.ConfigItem;
import com.atlassian.jira.migration.export.model.ConfigItemType;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.jira.advancedroadmaps.Plan;
import com.atlassian.migration.jira.classic.customfield.CustomField;
import com.atlassian.migration.jira.classic.workflow.Workflow;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/framework/ConfigItemsEventHandler;", "Lcom/atlassian/jira/migration/export/framework/ExportEventHandler;", "()V", "entities", "", "Lcom/atlassian/jira/migration/export/model/ConfigItem;", "getEntities", "()Ljava/util/Set;", "exportEntity", "", "entity", "Lcom/atlassian/migration/base/IdentifiableEntity;", "jira-migration-plugin"})
public final class ConfigItemsEventHandler
implements ExportEventHandler {
    @NotNull
    private final Set<ConfigItem> entities;

    public ConfigItemsEventHandler() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.entities = keySetView;
    }

    @NotNull
    public final Set<ConfigItem> getEntities() {
        return this.entities;
    }

    @Override
    public void exportEntity(@NotNull IdentifiableEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        IdentifiableEntity identifiableEntity = entity;
        if (identifiableEntity instanceof Workflow) {
            this.entities.add(new ConfigItem(ConfigItemType.WORKFLOW, ((Workflow)entity).getName(), null));
        } else if (identifiableEntity instanceof CustomField) {
            String id = entity.getId().getEntityType() + '_' + entity.getId().getEntityId();
            this.entities.add(new ConfigItem(ConfigItemType.CUSTOM_FIELD, ((CustomField)entity).getName(), id));
        } else if (identifiableEntity instanceof Plan) {
            String string = ((Plan)entity).getName();
            if (string == null) {
                string = "[This plan has no name]";
            }
            this.entities.add(new ConfigItem(ConfigItemType.ADVANCED_ROADMAPS_PLAN, string, null));
        }
    }

    @Override
    public void exportStart() {
        ExportEventHandler.DefaultImpls.exportStart(this);
    }

    @Override
    public void exportEnd() {
        ExportEventHandler.DefaultImpls.exportEnd(this);
    }
}

