/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.framework;

import com.atlassian.jira.migration.analytics.ExportFailureAnalyticsEventService;
import com.atlassian.jira.migration.analytics.ExportFailureEvent;
import com.atlassian.jira.migration.analytics.ExportFailureEventType;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.ExportExceptionNormalizer;
import com.atlassian.jira.migration.export.framework.ExportFailureContext;
import com.atlassian.jira.migration.export.framework.ExportFailureHandler;
import com.atlassian.jira.migration.export.framework.ExportFailureReporter;
import com.atlassian.jira.migration.log.ExportMessage;
import com.atlassian.jira.migration.log.ExportMessageSeverity;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/export/framework/DefaultExportFailureHandler;", "Lcom/atlassian/jira/migration/export/framework/ExportFailureHandler;", "exceptionNormalizer", "Lcom/atlassian/jira/migration/export/framework/ExportExceptionNormalizer;", "exportFailureAnalyticsEventService", "Lcom/atlassian/jira/migration/analytics/ExportFailureAnalyticsEventService;", "exportFailureReporter", "Lcom/atlassian/jira/migration/export/framework/ExportFailureReporter;", "(Lcom/atlassian/jira/migration/export/framework/ExportExceptionNormalizer;Lcom/atlassian/jira/migration/analytics/ExportFailureAnalyticsEventService;Lcom/atlassian/jira/migration/export/framework/ExportFailureReporter;)V", "getMaskedReason", "", "exportException", "Lcom/atlassian/jira/migration/export/framework/ExportException;", "handle", "", "exportFailureContext", "Lcom/atlassian/jira/migration/export/framework/ExportFailureContext;", "toExportFailureEvent", "Lcom/atlassian/jira/migration/analytics/ExportFailureEvent;", "Companion", "jira-migration-plugin"})
public final class DefaultExportFailureHandler
implements ExportFailureHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportExceptionNormalizer exceptionNormalizer;
    @NotNull
    private final ExportFailureAnalyticsEventService exportFailureAnalyticsEventService;
    @NotNull
    private final ExportFailureReporter exportFailureReporter;
    @NotNull
    private static final Logger log;

    @Inject
    public DefaultExportFailureHandler(@NotNull ExportExceptionNormalizer exceptionNormalizer, @NotNull ExportFailureAnalyticsEventService exportFailureAnalyticsEventService, @NotNull ExportFailureReporter exportFailureReporter) {
        Intrinsics.checkNotNullParameter((Object)exceptionNormalizer, (String)"exceptionNormalizer");
        Intrinsics.checkNotNullParameter((Object)exportFailureAnalyticsEventService, (String)"exportFailureAnalyticsEventService");
        Intrinsics.checkNotNullParameter((Object)exportFailureReporter, (String)"exportFailureReporter");
        this.exceptionNormalizer = exceptionNormalizer;
        this.exportFailureAnalyticsEventService = exportFailureAnalyticsEventService;
        this.exportFailureReporter = exportFailureReporter;
    }

    @Override
    public void handle(@NotNull ExportFailureContext exportFailureContext) {
        Intrinsics.checkNotNullParameter((Object)exportFailureContext, (String)"exportFailureContext");
        ExportFailureContext $this$handle_u24lambda_u240 = exportFailureContext;
        boolean bl = false;
        ExportException exportException = this.exceptionNormalizer.normalize($this$handle_u24lambda_u240.getMigrationTaskMetadata().getStartedUser(), $this$handle_u24lambda_u240.getMri(), $this$handle_u24lambda_u240.getError());
        ExportMessage errorLogMsg = exportException.toMessage($this$handle_u24lambda_u240.getProjectKey());
        $this$handle_u24lambda_u240.getExportLog().putExportMessage(errorLogMsg);
        this.exportFailureReporter.storePreflightStackTrace(exportFailureContext);
        this.exportFailureReporter.storeMigrationStackTrace(exportFailureContext);
        ExportFailureEvent event = this.toExportFailureEvent($this$handle_u24lambda_u240, exportException);
        this.exportFailureAnalyticsEventService.saveExportFailureEvent(event);
        if (!$this$handle_u24lambda_u240.getContinueOnError()) {
            throw $this$handle_u24lambda_u240.getError();
        }
        log.error($this$handle_u24lambda_u240.getMsg(), $this$handle_u24lambda_u240.getError());
    }

    private final ExportFailureEvent toExportFailureEvent(ExportFailureContext $this$toExportFailureEvent, ExportException exportException) {
        String string = $this$toExportFailureEvent.getMri().getNamespace() + ':' + $this$toExportFailureEvent.getMri().getEntityType();
        String string2 = $this$toExportFailureEvent.getMri().value();
        String string3 = $this$toExportFailureEvent.getMigrationTaskMetadata().getMigrationId();
        String string4 = $this$toExportFailureEvent.getProjectKey();
        long l = $this$toExportFailureEvent.getProjectId();
        String string5 = $this$toExportFailureEvent.getMigrationTaskMetadata().getCloudId();
        String string6 = exportException.getErrorCode().getValue();
        String string7 = exportException.getErrorSource();
        if (string7 == null) {
            string7 = "Known source";
        }
        ExportMessageSeverity exportMessageSeverity = exportException.getSeverity();
        return new ExportFailureEvent(string, string2, string3, string4, l, string5, string6, string7, this.getMaskedReason(exportException), $this$toExportFailureEvent.getMigrationTaskMetadata().getStartedUser().getEmailAddress(), (exportMessageSeverity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[exportMessageSeverity.ordinal()]) == 1 ? ExportFailureEventType.WARNING : ExportFailureEventType.ERROR, $this$toExportFailureEvent.getExportMode().name());
    }

    private final String getMaskedReason(ExportException exportException) {
        String string;
        if (exportException.getErrorCode() == ExportErrorCode.GENERIC_ERROR_CODE) {
            CharSequence charSequence = StringsKt.substringAfter$default((String)exportException.getReason(), (String)"Reason:", null, (int)2, null);
            Regex regex = new Regex("\\d+");
            String string2 = "ID-XXX";
            string = regex.replace(charSequence, string2);
        } else {
            string = null;
        }
        return string;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(DefaultExportFailureHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/export/framework/DefaultExportFailureHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExportMessageSeverity.values().length];
            try {
                nArray[ExportMessageSeverity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

