/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.framework;

import com.atlassian.jira.migration.export.framework.EntityTypeCount;
import com.atlassian.jira.migration.export.framework.ExportEventHandler;
import com.atlassian.jira.project.Project;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.base.MigrationEntity;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.advancedroadmaps.Plan;
import com.atlassian.migration.jira.classic.customfield.CustomField;
import com.atlassian.migration.jira.classic.notification.NotificationScheme;
import com.atlassian.migration.jira.classic.permission.PermissionScheme;
import com.atlassian.migration.jira.classic.software.rapidview.RapidView;
import com.atlassian.migration.jira.classic.workflow.Workflow;
import com.atlassian.migration.jira.core.Filter;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.PriorityScheme;
import com.atlassian.migration.jira.core.attachment.FileAttachment;
import com.atlassian.migration.jira.core.portalpage.PortalPage;
import com.atlassian.migration.jira.core.portalpage.PortalPageSharePermission;
import com.atlassian.migration.jira.core.portalpage.PortletConfiguration;
import com.atlassian.migration.jira.core.projectrole.ProjectRole;
import com.atlassian.migration.jira.servicedesk.Calendar;
import com.atlassian.migration.jira.servicedesk.Queue;
import com.atlassian.migration.jira.servicedesk.TimeMetric;
import com.atlassian.migration.jira.servicedesk.automation.AutomationRules;
import com.atlassian.migration.jira.servicedesk.report.Report;
import com.atlassian.migration.jira.servicedesk.requestype.RequestType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020%H\u0016J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010*\u001a\u00020+R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u001e\u0010 \u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u001e\u0010\"\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007\u00a8\u0006-"}, d2={"Lcom/atlassian/jira/migration/export/framework/EntityCountEventHandler;", "Lcom/atlassian/jira/migration/export/framework/ExportEventHandler;", "()V", "<set-?>", "Ljava/util/concurrent/atomic/AtomicLong;", "attachmentCount", "getAttachmentCount", "()Ljava/util/concurrent/atomic/AtomicLong;", "automationRulesCount", "getAutomationRulesCount", "calendarsCount", "getCalendarsCount", "globalMRIs", "", "Lcom/atlassian/migration/base/mri/MRI;", "getGlobalMRIs", "()Ljava/util/Set;", "setGlobalMRIs", "(Ljava/util/Set;)V", "issueCount", "getIssueCount", "jsdEntityTypeCounts", "", "Lcom/atlassian/jira/migration/export/framework/EntityTypeCount;", "getJsdEntityTypeCounts", "()Ljava/util/List;", "projectEntityTypeCounts", "getProjectEntityTypeCounts", "queueCount", "getQueueCount", "reportsCount", "getReportsCount", "requestTypesCount", "getRequestTypesCount", "slaCount", "getSlaCount", "exportEntity", "", "entity", "Lcom/atlassian/migration/base/IdentifiableEntity;", "exportStart", "getEntityTypeCounts", "project", "Lcom/atlassian/jira/project/Project;", "Companion", "jira-migration-plugin"})
public final class EntityCountEventHandler
implements ExportEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AtomicLong issueCount = new AtomicLong(0L);
    @NotNull
    private AtomicLong attachmentCount = new AtomicLong(0L);
    @NotNull
    private AtomicLong slaCount = new AtomicLong(0L);
    @NotNull
    private AtomicLong queueCount = new AtomicLong(0L);
    @NotNull
    private AtomicLong automationRulesCount = new AtomicLong(0L);
    @NotNull
    private AtomicLong calendarsCount = new AtomicLong(0L);
    @NotNull
    private AtomicLong requestTypesCount = new AtomicLong(0L);
    @NotNull
    private AtomicLong reportsCount = new AtomicLong(0L);
    @NotNull
    private Set<MRI> globalMRIs;
    @NotNull
    private static final Set<KClass<? extends MigrationEntity>> globalEntityTypes;

    public EntityCountEventHandler() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.globalMRIs = keySetView;
    }

    @NotNull
    public final AtomicLong getIssueCount() {
        return this.issueCount;
    }

    @NotNull
    public final AtomicLong getAttachmentCount() {
        return this.attachmentCount;
    }

    @NotNull
    public final AtomicLong getSlaCount() {
        return this.slaCount;
    }

    @NotNull
    public final AtomicLong getQueueCount() {
        return this.queueCount;
    }

    @NotNull
    public final AtomicLong getAutomationRulesCount() {
        return this.automationRulesCount;
    }

    @NotNull
    public final AtomicLong getCalendarsCount() {
        return this.calendarsCount;
    }

    @NotNull
    public final AtomicLong getRequestTypesCount() {
        return this.requestTypesCount;
    }

    @NotNull
    public final AtomicLong getReportsCount() {
        return this.reportsCount;
    }

    @NotNull
    public final Set<MRI> getGlobalMRIs() {
        return this.globalMRIs;
    }

    public final void setGlobalMRIs(@NotNull Set<MRI> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.globalMRIs = set;
    }

    @Override
    public void exportStart() {
        this.issueCount = new AtomicLong(0L);
        this.attachmentCount = new AtomicLong(0L);
        this.queueCount = new AtomicLong(0L);
        this.automationRulesCount = new AtomicLong(0L);
        this.slaCount = new AtomicLong(0L);
        this.calendarsCount = new AtomicLong(0L);
        this.requestTypesCount = new AtomicLong(0L);
        this.reportsCount = new AtomicLong(0L);
    }

    @Override
    public void exportEntity(@NotNull IdentifiableEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Issue) {
            this.issueCount.incrementAndGet();
        } else if (entity instanceof FileAttachment) {
            this.attachmentCount.incrementAndGet();
        } else if (entity instanceof Queue) {
            this.queueCount.incrementAndGet();
        } else if (entity instanceof AutomationRules) {
            this.automationRulesCount.incrementAndGet();
        } else if (entity instanceof TimeMetric) {
            this.slaCount.incrementAndGet();
        } else if (entity instanceof Calendar) {
            this.calendarsCount.incrementAndGet();
        } else if (entity instanceof RequestType) {
            this.requestTypesCount.incrementAndGet();
        } else if (entity instanceof Report) {
            this.reportsCount.incrementAndGet();
        } else if (CollectionsKt.contains((Iterable)globalEntityTypes, (Object)Reflection.getOrCreateKotlinClass(entity.getClass()))) {
            this.globalMRIs.add(entity.getId());
        }
    }

    @NotNull
    public final List<EntityTypeCount> getEntityTypeCounts(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)project.getProjectTypeKey().getKey(), (Object)"service_desk")) {
            return CollectionsKt.plus((Collection)this.getProjectEntityTypeCounts(), (Iterable)this.getJsdEntityTypeCounts());
        }
        return this.getProjectEntityTypeCounts();
    }

    private final List<EntityTypeCount> getProjectEntityTypeCounts() {
        Object[] objectArray = new EntityTypeCount[]{new EntityTypeCount(Issue.Companion.getEntityType(), this.issueCount), new EntityTypeCount(FileAttachment.Companion.getEntityType(), this.attachmentCount)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<EntityTypeCount> getJsdEntityTypeCounts() {
        Object[] objectArray = new EntityTypeCount[]{new EntityTypeCount(Queue.Companion.getEntityType(), this.queueCount), new EntityTypeCount(AutomationRules.Companion.getEntityType(), this.automationRulesCount), new EntityTypeCount(TimeMetric.Companion.getEntityType(), this.slaCount), new EntityTypeCount(Calendar.Companion.getEntityType(), this.calendarsCount), new EntityTypeCount(RequestType.Companion.getEntityType(), this.requestTypesCount), new EntityTypeCount(Report.Companion.getEntityType(), this.reportsCount)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void exportEnd() {
        ExportEventHandler.DefaultImpls.exportEnd(this);
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Workflow.class), Reflection.getOrCreateKotlinClass(CustomField.class), Reflection.getOrCreateKotlinClass(PermissionScheme.class), Reflection.getOrCreateKotlinClass(ProjectRole.class), Reflection.getOrCreateKotlinClass(RapidView.class), Reflection.getOrCreateKotlinClass(Plan.class), Reflection.getOrCreateKotlinClass(NotificationScheme.class), Reflection.getOrCreateKotlinClass(PriorityScheme.class), Reflection.getOrCreateKotlinClass(PortalPage.class), Reflection.getOrCreateKotlinClass(PortletConfiguration.class), Reflection.getOrCreateKotlinClass(Filter.class), Reflection.getOrCreateKotlinClass(PortalPageSharePermission.class)};
        globalEntityTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/export/framework/EntityCountEventHandler$Companion;", "", "()V", "globalEntityTypes", "", "Lkotlin/reflect/KClass;", "Lcom/atlassian/migration/base/MigrationEntity;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

