/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.framework;

import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.log.AttachmentExportMessage;
import com.atlassian.jira.migration.log.ExportMessage;
import com.atlassian.jira.migration.log.ExportMessageDetails;
import com.atlassian.jira.migration.log.ExportMessageKt;
import com.atlassian.jira.migration.log.ExportMessageSeverity;
import com.atlassian.jira.migration.log.ExportPhase;
import com.atlassian.jira.migration.log.ProjectExportMessage;
import com.atlassian.migration.base.mri.MRI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/export/framework/ExportException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "entity", "Lcom/atlassian/migration/base/mri/MRI;", "errorCode", "Lcom/atlassian/jira/migration/export/framework/ExportErrorCode;", "reason", "", "resolution", "severity", "Lcom/atlassian/jira/migration/log/ExportMessageSeverity;", "errorSource", "exportPhase", "Lcom/atlassian/jira/migration/log/ExportPhase;", "(Lcom/atlassian/migration/base/mri/MRI;Lcom/atlassian/jira/migration/export/framework/ExportErrorCode;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/jira/migration/log/ExportMessageSeverity;Ljava/lang/String;Lcom/atlassian/jira/migration/log/ExportPhase;)V", "getEntity", "()Lcom/atlassian/migration/base/mri/MRI;", "getErrorCode", "()Lcom/atlassian/jira/migration/export/framework/ExportErrorCode;", "getErrorSource", "()Ljava/lang/String;", "getReason", "getResolution", "getSeverity", "()Lcom/atlassian/jira/migration/log/ExportMessageSeverity;", "toMessage", "Lcom/atlassian/jira/migration/log/ExportMessage;", "projectKey", "jira-migration-plugin"})
public final class ExportException
extends Exception {
    @NotNull
    private final MRI entity;
    @NotNull
    private final ExportErrorCode errorCode;
    @NotNull
    private final String reason;
    @Nullable
    private final String resolution;
    @Nullable
    private final ExportMessageSeverity severity;
    @Nullable
    private final String errorSource;
    @NotNull
    private final ExportPhase exportPhase;

    public ExportException(@NotNull MRI entity, @NotNull ExportErrorCode errorCode, @NotNull String reason, @Nullable String resolution, @Nullable ExportMessageSeverity severity, @Nullable String errorSource, @NotNull ExportPhase exportPhase) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter((Object)((Object)exportPhase), (String)"exportPhase");
        super(reason);
        this.entity = entity;
        this.errorCode = errorCode;
        this.reason = reason;
        this.resolution = resolution;
        this.severity = severity;
        this.errorSource = errorSource;
        this.exportPhase = exportPhase;
    }

    public /* synthetic */ ExportException(MRI mRI, ExportErrorCode exportErrorCode, String string, String string2, ExportMessageSeverity exportMessageSeverity, String string3, ExportPhase exportPhase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            exportMessageSeverity = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        if ((n & 0x40) != 0) {
            exportPhase = ExportPhase.PROJECT_EXPORT;
        }
        this(mRI, exportErrorCode, string, string2, exportMessageSeverity, string3, exportPhase);
    }

    @NotNull
    public final MRI getEntity() {
        return this.entity;
    }

    @NotNull
    public final ExportErrorCode getErrorCode() {
        return this.errorCode;
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    @Nullable
    public final String getResolution() {
        return this.resolution;
    }

    @Nullable
    public final ExportMessageSeverity getSeverity() {
        return this.severity;
    }

    @Nullable
    public final String getErrorSource() {
        return this.errorSource;
    }

    @NotNull
    public final ExportMessage toMessage(@NotNull String projectKey) {
        ExportMessage exportMessage;
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        switch (WhenMappings.$EnumSwitchMapping$0[this.exportPhase.ordinal()]) {
            case 1: {
                ExportMessageDetails exportMessageDetails = new ExportMessageDetails(this.reason, this.errorCode.getValue(), this.resolution, null, 8, null);
                ExportMessageSeverity exportMessageSeverity = this.severity;
                if (exportMessageSeverity == null) {
                    exportMessageSeverity = ExportMessageKt.getSEVERITY_DEFAULT();
                }
                exportMessage = new ProjectExportMessage(this.entity, projectKey, exportMessageDetails, exportMessageSeverity);
                break;
            }
            case 2: {
                ExportMessageDetails exportMessageDetails = new ExportMessageDetails(this.reason, this.errorCode.getValue(), this.resolution, null, 8, null);
                ExportMessageSeverity exportMessageSeverity = this.severity;
                if (exportMessageSeverity == null) {
                    exportMessageSeverity = ExportMessageKt.getSEVERITY_DEFAULT();
                }
                exportMessage = new AttachmentExportMessage(this.entity, projectKey, exportMessageDetails, exportMessageSeverity);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return exportMessage;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExportPhase.values().length];
            try {
                nArray[ExportPhase.PROJECT_EXPORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExportPhase.ATTACHMENT_EXPORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

