/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.framework;

import com.atlassian.jira.migration.export.framework.ErrorCodesKt;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.base.mri.MRI;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001b\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/export/framework/ExportExceptionNormalizer;", "", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "normalize", "Lcom/atlassian/jira/migration/export/framework/ExportException;", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "mri", "Lcom/atlassian/migration/base/mri/MRI;", "err", "", "normalizeStackTrace", "", "errStackTrace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Ljava/lang/String;", "jira-migration-plugin"})
public final class ExportExceptionNormalizer {
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public ExportExceptionNormalizer(@NotNull EntityIdentifierGenerator entityIdentifierGenerator, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final ExportException normalize(@NotNull ApplicationUser user, @NotNull MRI mri, @NotNull Throwable err) {
        ExportException exportException;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        if (err instanceof ExportException) {
            exportException = (ExportException)err;
        } else {
            ExportErrorCode exportErrorCode = ErrorCodesKt.exportErrorCode(err);
            String string = "We couldn't export " + this.entityIdentifierGenerator.generate(mri, null, user) + ". Reason: " + err + '.';
            StackTraceElement[] stackTraceElementArray = err.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            exportException = new ExportException(mri, exportErrorCode, string, null, null, this.normalizeStackTrace(stackTraceElementArray), null, 88, null);
        }
        return exportException;
    }

    private final String normalizeStackTrace(StackTraceElement[] errStackTrace) {
        String string;
        if (this.migrationFeatures.getEnableExportErrorTraceInAnalytics()) {
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
            string = StringsKt.take((String)ArraysKt.joinToString$default((Object[])errStackTrace, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null), (int)4000);
        } else {
            String string3 = errStackTrace[0].toString();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }
}

