/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.framework;

import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorDto;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorRepository;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.export.framework.ExportFailureContext;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/export/framework/ExportFailureReporter;", "", "exportErrorRepository", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "(Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;)V", "getMigrationScopeFromCloudId", "", "cloudId", "isMigrationStoringSkipped", "", "exportFailureContext", "Lcom/atlassian/jira/migration/export/framework/ExportFailureContext;", "isPreflightStoringSkipped", "storeMigrationStackTrace", "", "storePreflightStackTrace", "jira-migration-plugin"})
public final class ExportFailureReporter {
    @NotNull
    private final ExportErrorRepository exportErrorRepository;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;

    @Inject
    public ExportFailureReporter(@NotNull ExportErrorRepository exportErrorRepository, @NotNull MigrationScopeManager migrationScopeManager, @NotNull CloudSiteRepository cloudSiteRepository) {
        Intrinsics.checkNotNullParameter((Object)exportErrorRepository, (String)"exportErrorRepository");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        this.exportErrorRepository = exportErrorRepository;
        this.migrationScopeManager = migrationScopeManager;
        this.cloudSiteRepository = cloudSiteRepository;
    }

    public final void storeMigrationStackTrace(@NotNull ExportFailureContext exportFailureContext) {
        Intrinsics.checkNotNullParameter((Object)exportFailureContext, (String)"exportFailureContext");
        if (this.isMigrationStoringSkipped(exportFailureContext)) {
            return;
        }
        this.exportErrorRepository.save(new ExportErrorDto(Instant.now().toEpochMilli(), exportFailureContext.getMigrationTaskMetadata().getCloudId(), exportFailureContext.getMigrationTaskMetadata().getMigrationId(), null, exportFailureContext.getProjectKey(), ExceptionsKt.stackTraceToString((Throwable)exportFailureContext.getError()), 8, null));
    }

    private final boolean isMigrationStoringSkipped(ExportFailureContext exportFailureContext) {
        boolean performingProjectDataExport = exportFailureContext.getExportMode() == ExportMode.PROJECT_DATA;
        return !performingProjectDataExport;
    }

    public final void storePreflightStackTrace(@NotNull ExportFailureContext exportFailureContext) {
        Intrinsics.checkNotNullParameter((Object)exportFailureContext, (String)"exportFailureContext");
        if (this.isPreflightStoringSkipped(exportFailureContext)) {
            return;
        }
        String migrationScopeId2 = this.getMigrationScopeFromCloudId(exportFailureContext.getMigrationTaskMetadata().getCloudId());
        this.exportErrorRepository.save(new ExportErrorDto(Instant.now().toEpochMilli(), exportFailureContext.getMigrationTaskMetadata().getCloudId(), null, migrationScopeId2, exportFailureContext.getProjectKey(), ExceptionsKt.stackTraceToString((Throwable)exportFailureContext.getError()), 4, null));
    }

    private final boolean isPreflightStoringSkipped(ExportFailureContext exportFailureContext) {
        boolean performingCollectPreflightOrReportData = exportFailureContext.getExportMode() == ExportMode.COLLECT_PREFLIGHT_PROJECT_DATA || exportFailureContext.getExportMode() == ExportMode.COLLECT_REPORT_DATA;
        return !performingCollectPreflightOrReportData;
    }

    private final String getMigrationScopeFromCloudId(String cloudId2) {
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        Intrinsics.checkNotNull((Object)cloudSite2);
        CloudSite cloudSite3 = cloudSite2;
        return this.migrationScopeManager.getMigrationScope(cloudSite3);
    }
}

