/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.global;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.issuestatus.IssueStatus;
import com.atlassian.migration.jira.classic.issuestatus.IssueStatusCategory;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/export/global/IssueStatusExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/status/Status;", "Lcom/atlassian/migration/jira/classic/issuestatus/IssueStatus;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "statusManager", "Lcom/atlassian/jira/config/StatusManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/config/StatusManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "extractServerEntity", "entityKey", "getStatusWithoutTranslation", "Lcom/atlassian/jira/issue/status/SimpleStatusImpl;", "status", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "postConstruct", "", "toCloudIssueStatusCategory", "Lcom/atlassian/migration/jira/classic/issuestatus/IssueStatusCategory;", "source", "jira-migration-plugin"})
public final class IssueStatusExporter
implements Exporter<String, Status, IssueStatus> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;
    @NotNull
    private final StatusManager statusManager;

    @Inject
    public IssueStatusExporter(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator identifierGenerator, @NotNull StatusManager statusManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        this.exportService = exportService;
        this.identifierGenerator = identifierGenerator;
        this.statusManager = statusManager;
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(IssueStatus.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, Status.class);
    }

    @Override
    @Nullable
    public Status extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return this.statusManager.getStatus(entityKey);
    }

    @Override
    @NotNull
    public IssueStatus exportData(@NotNull ExportContext ctx, @NotNull Status entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        SimpleStatusImpl it = this.getStatusWithoutTranslation(entity);
        boolean bl = false;
        MRI mRI = this.mriForEntity(entity);
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = it.getDescription();
        String string3 = it.getStatusCategory().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
        return new IssueStatus(mRI, string, string2, this.toCloudIssueStatusCategory(string3, entity), null, 16, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull Status entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return this.mriForKey(string);
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(IssueStatus.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @VisibleForTesting
    @NotNull
    public final SimpleStatusImpl getStatusWithoutTranslation(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        return new SimpleStatusImpl(status.getId(), status.getName(), status.getDescription(), status.getStatusCategory(), status.getCompleteIconUrl());
    }

    private final IssueStatusCategory toCloudIssueStatusCategory(String source, Status entity) {
        IssueStatusCategory issueStatusCategory;
        switch (source) {
            case "new": {
                issueStatusCategory = IssueStatusCategory.TO_DO;
                break;
            }
            case "indeterminate": {
                issueStatusCategory = IssueStatusCategory.IN_PROGRESS;
                break;
            }
            case "done": {
                issueStatusCategory = IssueStatusCategory.DONE;
                break;
            }
            case "undefined": {
                issueStatusCategory = IssueStatusCategory.UNDEFINED;
                break;
            }
            default: {
                MRI mri = this.mriForEntity(entity);
                String string = "Category: " + source + " for " + EntityIdentifierGenerator.generate$default(this.identifierGenerator, mri, entity, null, 4, null) + " is not supported";
                ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_ISSUE_STATUS_CATEGORY_UNKNOWN;
                throw new ExportException(mri, exportErrorCode, string, null, null, null, null, 120, null);
            }
        }
        return issueStatusCategory;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull Status entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull Status entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

