/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.global;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.Priority;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/export/global/PriorityExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/priority/Priority;", "Lcom/atlassian/migration/jira/core/Priority;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "priorityManager", "Lcom/atlassian/jira/config/PriorityManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/config/PriorityManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "extractServerEntity", "entityKey", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "postConstruct", "", "jira-migration-plugin"})
public final class PriorityExporter
implements Exporter<String, com.atlassian.jira.issue.priority.Priority, Priority> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final PriorityManager priorityManager;

    @Inject
    public PriorityExporter(@NotNull ExportService exportService, @NotNull PriorityManager priorityManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)priorityManager, (String)"priorityManager");
        this.exportService = exportService;
        this.priorityManager = priorityManager;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.jira.issue.priority.Priority.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(Priority.Companion.getEntityType());
    }

    @Override
    @NotNull
    public Priority exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.priority.Priority entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = entity.getDescription();
        String string3 = entity.getIconUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIconUrl(...)");
        String string4 = entity.getStatusColor();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStatusColor(...)");
        return new Priority(mRI, string, string2, string3, string4);
    }

    @Override
    @Nullable
    public com.atlassian.jira.issue.priority.Priority extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return this.priorityManager.getPriority(entityKey);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.jira.issue.priority.Priority entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return this.mriForKey(string);
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(Priority.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.priority.Priority entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.priority.Priority entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

