/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.global;

import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.ProjectCategory;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/export/global/ProjectCategoryExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/project/ProjectCategory;", "Lcom/atlassian/migration/jira/core/ProjectCategory;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/project/ProjectManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "extractServerEntity", "entityKey", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "postConstruct", "", "jira-migration-plugin"})
public final class ProjectCategoryExporter
implements Exporter<Long, com.atlassian.jira.project.ProjectCategory, ProjectCategory> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ProjectManager projectManager;

    @Inject
    public ProjectCategoryExporter(@NotNull ExportService exportService, @NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.exportService = exportService;
        this.projectManager = projectManager;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.jira.project.ProjectCategory.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ProjectCategory.Companion.getEntityType());
    }

    @Override
    @NotNull
    public ProjectCategory exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.project.ProjectCategory entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new ProjectCategory(mRI, string, entity.getDescription());
    }

    @Override
    @Nullable
    public com.atlassian.jira.project.ProjectCategory extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.projectManager.getProjectCategory(Long.valueOf(entityKey));
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.jira.project.ProjectCategory entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(ProjectCategory.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.project.ProjectCategory entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.project.ProjectCategory entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

