/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.global;

import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.projectrole.ProjectRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u0016H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/export/global/ProjectRoleExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/security/roles/ProjectRole;", "Lcom/atlassian/migration/jira/core/projectrole/ProjectRole;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "projectRoleManager", "Lcom/atlassian/jira/security/roles/ProjectRoleManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/security/roles/ProjectRoleManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "extractServerEntity", "entityKey", "mapDefaultRoleActors", "", "Lcom/atlassian/migration/base/mri/MRI;", "mapRoleActorToMri", "roleActor", "Lcom/atlassian/jira/security/roles/RoleActor;", "mriForEntity", "mriForKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectRoleExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectRoleExporter.kt\ncom/atlassian/jira/migration/export/global/ProjectRoleExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n766#2:80\n857#2,2:81\n1603#2,9:83\n1855#2:92\n1856#2:94\n1612#2:95\n1#3:93\n1#3:96\n*S KotlinDebug\n*F\n+ 1 ProjectRoleExporter.kt\ncom/atlassian/jira/migration/export/global/ProjectRoleExporter\n*L\n64#1:80\n64#1:81,2\n65#1:83,9\n65#1:92\n65#1:94\n65#1:95\n65#1:93\n*E\n"})
public final class ProjectRoleExporter
implements Exporter<Long, com.atlassian.jira.security.roles.ProjectRole, ProjectRole> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ProjectRoleManager projectRoleManager;
    private final Logger log;

    @Inject
    public ProjectRoleExporter(@NotNull ExportService exportService, @NotNull ProjectRoleManager projectRoleManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)projectRoleManager, (String)"projectRoleManager");
        this.exportService = exportService;
        this.projectRoleManager = projectRoleManager;
        this.log = LoggerFactory.getLogger(ProjectRoleExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.jira.security.roles.ProjectRole.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ProjectRole.Companion.getEntityType());
    }

    @Override
    @NotNull
    public ProjectRole exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.security.roles.ProjectRole entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new ProjectRole(mRI, string, entity.getDescription(), ctx.getIncludeRoleActors() ? this.mapDefaultRoleActors(ctx, entity) : CollectionsKt.emptyList(), null, 16, null);
    }

    @Override
    @Nullable
    public com.atlassian.jira.security.roles.ProjectRole extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.projectRoleManager.getProjectRole(Long.valueOf(entityKey));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.security.roles.ProjectRole entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (ctx.getIncludeRoleActors()) {
            Object[] objectArray = new Object[]{entity.getId(), entity.getName(), ctx.getMigrationId(), ctx.getExportMode()};
            this.log.debug("Exporting users and groups for jiraProjectRole with id {} and name {} for migration {} under exportMode {}", objectArray);
            this.mapDefaultRoleActors(ctx, entity);
        }
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.jira.security.roles.ProjectRole entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(ProjectRole.Companion.getEntityType(), entityKey, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> mapDefaultRoleActors(ExportContext ctx, com.atlassian.jira.security.roles.ProjectRole entity) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Set set = this.projectRoleManager.getDefaultRoleActors(entity).getRoleActors();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRoleActors(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RoleActor it = (RoleActor)element$iv$iv;
            boolean bl = false;
            if (!StringExtensionsKt.isNotNullOrBlank(it.getParameter())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MRI it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            RoleActor it = (RoleActor)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.mapRoleActorToMri(ctx, it, entity) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MRI mapRoleActorToMri(ExportContext ctx, RoleActor roleActor, com.atlassian.jira.security.roles.ProjectRole entity) {
        MRI mRI;
        String string = roleActor.getType();
        if (Intrinsics.areEqual((Object)string, (Object)"atlassian-group-role-actor")) {
            String string2 = roleActor.getParameter();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParameter(...)");
            GroupRefModel groupRef = new GroupRefModel(string2, "Role [" + entity.getName() + ']', String.valueOf(entity.getId()));
            mRI = this.exportService.groupRefSkipInvalid(ctx, groupRef);
        } else if (Intrinsics.areEqual((Object)string, (Object)"atlassian-user-role-actor")) {
            UserRef userRef = UserRef.Companion.fromString(roleActor.getParameter());
            if (userRef != null) {
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
            } else {
                mRI = null;
            }
        } else {
            this.log.warn("Invalid roleActors have been skipped with entity id " + entity.getId());
            mRI = null;
        }
        return mRI;
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.security.roles.ProjectRole entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

