/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.service;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.framework.PartialExporter;
import com.atlassian.jira.migration.export.framework.UnsupportedExporter;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.service.UsersExportService;
import com.atlassian.jira.migration.export.utils.CustomFieldUtilsKt;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.metrics.MetricsInfo;
import com.atlassian.jira.migration.metrics.TimingMetrics;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.migration.base.IdentifiableEntity;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIType;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.core.JiraCoreMriRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u0088\u00012\u00020\u0001:\u0004\u0087\u0001\u0088\u0001B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!H\u0002J%\u0010\"\u001a\u00020#\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$\u00a2\u0006\u0002\u0010'J)\u0010\"\u001a\u00020#\"\u0004\b\u0000\u0010(2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u0002H(\u00a2\u0006\u0002\u0010,JA\u0010-\u001a\u00020.\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$2\u001a\b\u0002\u0010/\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\b\u0012\u000601j\u0002`2\u0018\u000100\u00a2\u0006\u0002\u00103JE\u0010-\u001a\u00020.\"\u0004\b\u0000\u0010(2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u0002H(2\u001a\b\u0002\u0010/\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\b\u0012\u000601j\u0002`2\u0018\u000100\u00a2\u0006\u0002\u00104JE\u00105\u001a\u00020\u001b\"\b\b\u0000\u0010$*\u00020%2\u0014\u00106\u001a\u0010\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H$\u0012\u0002\b\u00030\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$2\u0006\u00107\u001a\u00020.H\u0002\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020%2\u0006\u00107\u001a\u00020.H\u0002JQ\u0010:\u001a\u00020.\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\u00106\u001a\u0010\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H$\u0012\u0002\b\u00030\u00122\u0006\u0010&\u001a\u0002H$2\b\b\u0002\u0010;\u001a\u00020!2\b\b\u0002\u0010<\u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010=JG\u0010>\u001a\u00020?\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\u00106\u001a\u0010\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H$\u0012\u0002\b\u00030\u00122\u0006\u0010&\u001a\u0002H$2\b\b\u0002\u0010<\u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010@JG\u0010A\u001a\u0004\u0018\u00010.\"\u0004\b\u0000\u0010(\"\b\b\u0001\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u00106\u001a\u0012\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H$\u0012\u0002\b\u00030\u00122\u0006\u0010B\u001a\u0002H(H\u0002\u00a2\u0006\u0002\u0010CJE\u0010D\u001a\u00020.\"\u0004\b\u0000\u0010(2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u0002H(2\u001a\b\u0002\u0010/\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\b\u0012\u000601j\u0002`2\u0018\u000100\u00a2\u0006\u0002\u00104Ja\u0010E\u001a\u00020.\"\u0004\b\u0000\u0010(\"\b\b\u0001\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u00106\u001a\u0012\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H$\u0012\u0002\b\u00030\u00122\u0006\u0010B\u001a\u0002H(2\u001a\b\u0002\u0010/\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\b\u0012\u000601j\u0002`2\u0018\u000100H\u0002\u00a2\u0006\u0002\u0010FJ\u0018\u0010G\u001a\u0004\u0018\u00010.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00107\u001a\u00020.J-\u0010H\u001a\u0004\u0018\u00010.\"\u0004\b\u0000\u0010(2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010I\u001a\u00020\u00142\u0006\u0010+\u001a\u0002H(H\u0002\u00a2\u0006\u0002\u0010JJ\u0016\u0010K\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020\u001fJ\u0018\u0010M\u001a\u0004\u0018\u00010.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00107\u001a\u00020.J\u0018\u0010N\u001a\u0004\u0018\u00010.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020\u001fJG\u0010O\u001a\u00020.\"\b\b\u0000\u0010$*\u00020%\"\b\b\u0001\u0010P*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u00112\b\b\u0002\u0010;\u001a\u00020!\u00a2\u0006\u0002\u0010RJM\u0010S\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010?0T\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$2\u0014\u00106\u001a\u0010\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H$\u0012\u0002\b\u00030\u0012H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bU\u0010VJ=\u0010W\u001a\u0002HX\"\b\b\u0000\u0010$*\u00020%\"\b\b\u0001\u0010X*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$2\f\u0010Y\u001a\b\u0012\u0004\u0012\u0002HX0\u0011\u00a2\u0006\u0002\u0010ZJ-\u0010[\u001a\u00020.\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$2\u0006\u0010\\\u001a\u00020.\u00a2\u0006\u0002\u0010]J'\u0010^\u001a\u0004\u0018\u00010.\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$\u00a2\u0006\u0002\u0010_J+\u0010^\u001a\u0004\u0018\u00010.\"\u0004\b\u0000\u0010(2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u0002H(\u00a2\u0006\u0002\u0010`J/\u0010a\u001a\u00020.\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$2\u0006\u0010;\u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010bJ\u0016\u0010c\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010d\u001a\u00020\u001fJ\u0016\u0010e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010d\u001a\u00020\u001fJ&\u0010f\u001a\u0012\u0012\u0004\u0012\u0002H(\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0012\"\u0004\b\u0000\u0010(2\u0006\u0010)\u001a\u00020*H\u0007J0\u0010f\u001a\u0012\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H$\u0012\u0002\b\u0003\u0018\u00010\u0012\"\b\b\u0000\u0010$*\u00020%2\f\u0010g\u001a\b\u0012\u0004\u0012\u0002H$0\u0011H\u0007J$\u0010h\u001a\u0010\u0012\u0004\u0012\u0002H(\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012\"\u0004\b\u0000\u0010(2\u0006\u0010)\u001a\u00020*H\u0002J.\u0010h\u001a\u0010\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H$\u0012\u0002\b\u00030\u0012\"\b\b\u0000\u0010$*\u00020%2\f\u0010g\u001a\b\u0012\u0004\u0012\u0002H$0\u0011H\u0002J+\u0010i\u001a\u0004\u0018\u00010.\"\u0004\b\u0000\u0010(2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u0002H(\u00a2\u0006\u0002\u0010`J\u0016\u0010j\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010k\u001a\u00020lJ\u0016\u0010j\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010j\u001a\u00020mJ\u0018\u0010n\u001a\u0004\u0018\u00010.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010o\u001a\u0004\u0018\u00010.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010j\u001a\u00020mJ*\u0010p\u001a\u00020\u001b2\u0006\u0010q\u001a\u00020#2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\b\u0012\u000601j\u0002`2\u0018\u000100H\u0002J<\u0010r\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020%0\u00112\u001c\u0010t\u001a\u0018\u0012\u0004\u0012\u00020\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020!0uH\u0002J\u001e\u0010v\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020%0\u0011H\u0002J7\u0010w\u001a\u00020\u001b\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010<\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u0002H$2\u0006\u00107\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010xJ\u001e\u0010y\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020%0\u0011H\u0002J\u0010\u0010z\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020mH\u0002J\u001d\u00107\u001a\u00020.\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010&\u001a\u0002H$\u00a2\u0006\u0002\u0010{J\u000e\u0010|\u001a\u00020.2\u0006\u0010}\u001a\u00020~J0\u0010\u007f\u001a\u00020\u001b2\u0007\u0010\u0080\u0001\u001a\u00020\u00142\u0012\u00106\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00122\u000b\u0010\u0081\u0001\u001a\u0006\u0012\u0002\b\u00030\u0011J\u0019\u0010\u0082\u0001\u001a\u00020!2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0006\u0010j\u001a\u00020mJ\u0018\u0010\u0085\u0001\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0007\u0010}\u001a\u00030\u0086\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0089\u0001"}, d2={"Lcom/atlassian/jira/migration/export/service/ExportService;", "Lcom/atlassian/jira/migration/export/service/ExportOrThrow;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "usersExportService", "Lcom/atlassian/jira/migration/export/service/UsersExportService;", "timingMetrics", "Lcom/atlassian/jira/migration/metrics/TimingMetrics;", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "(Lcom/atlassian/jira/issue/CustomFieldManager;Lcom/atlassian/jira/migration/export/service/UsersExportService;Lcom/atlassian/jira/migration/metrics/TimingMetrics;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/utils/ExportFilters;)V", "exportersByClass", "", "Ljava/lang/Class;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "exportersByKey", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getMigrationFeatures", "()Lcom/atlassian/jira/migration/features/MigrationFeatures;", "nonUserRefExportMode", "", "Lcom/atlassian/jira/migration/export/framework/ExportMode;", "addGroupToExportContext", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "groupName", "", "checkForEmptyName", "", "checkExported", "Lcom/atlassian/jira/migration/export/service/ExportService$CheckExportedResult;", "JiraEntity", "", "jiraEntity", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;)Lcom/atlassian/jira/migration/export/service/ExportService$CheckExportedResult;", "EntityKey", "entityType", "Lcom/atlassian/migration/base/mri/registry/EntityType;", "entityKey", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/migration/base/mri/registry/EntityType;Ljava/lang/Object;)Lcom/atlassian/jira/migration/export/service/ExportService$CheckExportedResult;", "checkExportedOrThrow", "Lcom/atlassian/migration/base/mri/MRI;", "customExceptionSupplier", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lcom/atlassian/migration/base/mri/MRI;", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/migration/base/mri/registry/EntityType;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lcom/atlassian/migration/base/mri/MRI;", "continueWithChildrenActions", "exporter", "mri", "(Lcom/atlassian/jira/migration/export/framework/Exporter;Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;Lcom/atlassian/migration/base/mri/MRI;)V", "convertEntityId", "exportByEntityImpl", "shouldForceChildren", "isGlobal", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/jira/migration/export/framework/Exporter;Ljava/lang/Object;ZZ)Lcom/atlassian/migration/base/mri/MRI;", "exportByEntityObjectImpl", "Lcom/atlassian/migration/base/IdentifiableEntity;", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/jira/migration/export/framework/Exporter;Ljava/lang/Object;Z)Lcom/atlassian/migration/base/IdentifiableEntity;", "exportByIdImpl", "jiraEntityId", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/jira/migration/export/framework/Exporter;Ljava/lang/Object;)Lcom/atlassian/migration/base/mri/MRI;", "exportByIdOrThrow", "exportByIdOrThrowImpl", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/jira/migration/export/framework/Exporter;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lcom/atlassian/migration/base/mri/MRI;", "exportByMri", "exportByMriImpl", "exporterKey", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/jira/migration/export/framework/ExporterKey;Ljava/lang/Object;)Lcom/atlassian/migration/base/mri/MRI;", "exportField", "id", "exportFieldByMri", "exportFieldOrNull", "exportGlobalOrThrow", "GlobalClass", "globalClass", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;Ljava/lang/Class;Z)Lcom/atlassian/migration/base/mri/MRI;", "exportJiraEntity", "Lkotlin/Result;", "exportJiraEntity-0E7RQCE", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;Lcom/atlassian/jira/migration/export/framework/Exporter;)Ljava/lang/Object;", "exportObjectOrThrow", "Entity", "exportedClass", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "exportOrDefault", "defaultMRI", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;Lcom/atlassian/migration/base/mri/MRI;)Lcom/atlassian/migration/base/mri/MRI;", "exportOrNull", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;)Lcom/atlassian/migration/base/mri/MRI;", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Lcom/atlassian/migration/base/mri/registry/EntityType;Ljava/lang/Object;)Lcom/atlassian/migration/base/mri/MRI;", "exportOrThrow", "(Lcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;Z)Lcom/atlassian/migration/base/mri/MRI;", "extractUserRefs", "text", "extractUserRefsForAssetsText", "findExporter", "clz", "findExporterOrThrow", "getExportedOrNull", "groupRef", "group", "Lcom/atlassian/crowd/embedded/api/Group;", "Lcom/atlassian/jira/migration/export/model/GroupRefModel;", "groupRefOrNull", "groupRefSkipInvalid", "handleNotExported", "checkResult", "isFilteredGlobalEntity", "cls", "filter", "Lkotlin/Function2;", "isGlobalEntity", "isGlobalOrThrow", "(ZLcom/atlassian/jira/migration/export/framework/ExportContext;Ljava/lang/Object;Lcom/atlassian/migration/base/mri/MRI;)V", "isPostGlobalEntity", "logSkipInvalidGroupReference", "(Ljava/lang/Object;)Lcom/atlassian/migration/base/mri/MRI;", "projectRef", "ref", "Lcom/atlassian/jira/project/Project;", "registerExporter", "key", "jiraEntityClass", "skipInvalidGroup", "sharePermission", "Lcom/atlassian/jira/sharing/SharePermission;", "userRef", "Lcom/atlassian/jira/migration/export/model/UserRef;", "CheckExportedResult", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportService.kt\ncom/atlassian/jira/migration/export/service/ExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,627:1\n288#2,2:628\n766#2:631\n857#2,2:632\n1747#2,3:634\n1603#2,9:637\n1855#2:646\n1856#2:648\n1612#2:649\n1855#2,2:650\n1#3:630\n1#3:647\n*S KotlinDebug\n*F\n+ 1 ExportService.kt\ncom/atlassian/jira/migration/export/service/ExportService\n*L\n106#1:628,2\n259#1:631\n259#1:632,2\n261#1:634,3\n373#1:637,9\n373#1:646\n373#1:648\n373#1:649\n374#1:650,2\n373#1:647\n*E\n"})
public final class ExportService
implements ExportOrThrow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final UsersExportService usersExportService;
    @NotNull
    private final TimingMetrics timingMetrics;
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final Map<ExporterKey, Exporter<?, ?, ?>> exportersByKey;
    @NotNull
    private final Map<Class<?>, Exporter<?, ?, ?>> exportersByClass;
    @NotNull
    private final Set<ExportMode> nonUserRefExportMode;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Set<Class<?>> GLOBAL_ENTITIES;
    @NotNull
    private static final Set<String> STRING_ENTITY_KEY;

    @Inject
    public ExportService(@NotNull CustomFieldManager customFieldManager, @NotNull UsersExportService usersExportService, @NotNull TimingMetrics timingMetrics, @NotNull EntityIdentifierGenerator entityIdentifierGenerator, @VisibleForTesting @NotNull MigrationFeatures migrationFeatures, @NotNull ExportFilters exportFilters) {
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        Intrinsics.checkNotNullParameter((Object)usersExportService, (String)"usersExportService");
        Intrinsics.checkNotNullParameter((Object)timingMetrics, (String)"timingMetrics");
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        this.customFieldManager = customFieldManager;
        this.usersExportService = usersExportService;
        this.timingMetrics = timingMetrics;
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.migrationFeatures = migrationFeatures;
        this.exportFilters = exportFilters;
        this.exportersByKey = new ConcurrentHashMap();
        this.exportersByClass = new ConcurrentHashMap();
        ExportMode[] exportModeArray = new ExportMode[]{ExportMode.PROJECT_DATA, ExportMode.COLLECT_REPORT_DATA, ExportMode.COLLECT_PREFLIGHT_PROJECT_DATA, ExportMode.COLLECT_CONFIG_ONLY, ExportMode.SHADOW_PROJECT_DATA};
        this.nonUserRefExportMode = SetsKt.setOf((Object[])exportModeArray);
    }

    @NotNull
    public final MigrationFeatures getMigrationFeatures() {
        return this.migrationFeatures;
    }

    public final void registerExporter(@NotNull ExporterKey key, @NotNull Exporter<?, ?, ?> exporter, @NotNull Class<?> jiraEntityClass) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(exporter, (String)"exporter");
        Intrinsics.checkNotNullParameter(jiraEntityClass, (String)"jiraEntityClass");
        if (!(this.exportersByKey.put(key, exporter) == null)) {
            boolean $i$a$-check-ExportService$registerExporter$32 = false;
            String $i$a$-check-ExportService$registerExporter$32 = "exporter with key " + key + " already registered.";
            throw new IllegalStateException($i$a$-check-ExportService$registerExporter$32.toString());
        }
        if (!(this.exportersByClass.put(jiraEntityClass, exporter) == null)) {
            boolean bl = false;
            String string = "exporter for class " + jiraEntityClass.getSimpleName() + " already registered.";
            throw new IllegalStateException(string.toString());
        }
    }

    @VisibleForTesting
    @Nullable
    public final <JiraEntity> Exporter<?, JiraEntity, ?> findExporter(@NotNull Class<JiraEntity> clz) {
        Exporter exporter;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(clz, (String)"clz");
            Iterable $this$firstOrNull$iv = this.exportersByClass.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!((Class)it.getKey()).isAssignableFrom(clz)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry != null) {
            Map.Entry it = entry;
            boolean bl = false;
            Object v = it.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.export.framework.Exporter<*, JiraEntity of com.atlassian.jira.migration.export.service.ExportService.findExporter$lambda$3, *>");
            exporter = (Exporter)v;
        } else {
            exporter = null;
        }
        return exporter;
    }

    @VisibleForTesting
    @Nullable
    public final <EntityKey> Exporter<EntityKey, ?, ?> findExporter(@NotNull EntityType entityType) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        return this.exportersByKey.get(new ExporterKey(entityType));
    }

    private final <JiraEntity> Exporter<?, JiraEntity, ?> findExporterOrThrow(Class<JiraEntity> clz) {
        Exporter<?, JiraEntity, ?> exporter = this.findExporter(clz);
        if (exporter == null) {
            throw new IllegalArgumentException("no exporter for " + clz.getSimpleName());
        }
        return exporter;
    }

    private final <EntityKey> Exporter<EntityKey, ?, ?> findExporterOrThrow(EntityType entityType) {
        Exporter<EntityKey, ?, ?> exporter = this.findExporter(entityType);
        if (exporter == null) {
            throw new IllegalArgumentException("no exporter for " + entityType);
        }
        return exporter;
    }

    @Override
    @NotNull
    public <JiraEntity> MRI exportOrThrow(@NotNull ExportContext ctx, @NotNull JiraEntity jiraEntity, boolean shouldForceChildren) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(jiraEntity, (String)"jiraEntity");
        Exporter<?, ?, ?> exporter = this.findExporterOrThrow(jiraEntity.getClass());
        if (exporter instanceof UnsupportedExporter) {
            ((UnsupportedExporter)exporter).handleUnsupported(ctx, jiraEntity);
            throw new IllegalStateException("attempted to export unsupported entity: " + jiraEntity);
        }
        return ExportService.exportByEntityImpl$default(this, ctx, exporter, jiraEntity, shouldForceChildren, false, 16, null);
    }

    @NotNull
    public final <JiraEntity, Entity> Entity exportObjectOrThrow(@NotNull ExportContext ctx, @NotNull JiraEntity jiraEntity, @NotNull Class<Entity> exportedClass) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(jiraEntity, (String)"jiraEntity");
        Intrinsics.checkNotNullParameter(exportedClass, (String)"exportedClass");
        Exporter<?, ?, ?> exporter = this.findExporterOrThrow(jiraEntity.getClass());
        if (exporter instanceof UnsupportedExporter) {
            ((UnsupportedExporter)exporter).handleUnsupported(ctx, jiraEntity);
            throw new IllegalStateException("attempted to export unsupported entity: " + jiraEntity);
        }
        IdentifiableEntity exportedEntity = ExportService.exportByEntityObjectImpl$default(this, ctx, exporter, jiraEntity, false, 8, null);
        Entity Entity2 = exportedClass.cast(exportedEntity);
        Intrinsics.checkNotNullExpressionValue(Entity2, (String)"cast(...)");
        return Entity2;
    }

    @NotNull
    public final <JiraEntity, GlobalClass> MRI exportGlobalOrThrow(@NotNull ExportContext ctx, @NotNull JiraEntity jiraEntity, @NotNull Class<GlobalClass> globalClass, boolean shouldForceChildren) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(jiraEntity, (String)"jiraEntity");
        Intrinsics.checkNotNullParameter(globalClass, (String)"globalClass");
        ctx.getExportedGlobalClasses().add(globalClass);
        return this.exportByEntityImpl(ctx, this.findExporterOrThrow(jiraEntity.getClass()), jiraEntity, shouldForceChildren, true);
    }

    public static /* synthetic */ MRI exportGlobalOrThrow$default(ExportService exportService, ExportContext exportContext, Object object, Class clazz, boolean bl, int n, Object object2) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return exportService.exportGlobalOrThrow(exportContext, object, clazz, bl);
    }

    @NotNull
    public final <EntityKey> MRI exportByIdOrThrow(@NotNull ExportContext ctx, @NotNull EntityType entityType, EntityKey entityKey, @Nullable Function1<? super MRI, ? extends Exception> customExceptionSupplier) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Exporter<EntityKey, ?, ?> exporter = this.findExporterOrThrow(entityType);
        Intrinsics.checkNotNull(exporter, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.export.framework.Exporter<EntityKey of com.atlassian.jira.migration.export.service.ExportService.exportByIdOrThrow, kotlin.Any, *>");
        return this.exportByIdOrThrowImpl(ctx, exporter, entityKey, customExceptionSupplier);
    }

    public static /* synthetic */ MRI exportByIdOrThrow$default(ExportService exportService, ExportContext exportContext, EntityType entityType, Object object, Function1 function1, int n, Object object2) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        return exportService.exportByIdOrThrow(exportContext, entityType, object, (Function1<? super MRI, ? extends Exception>)function1);
    }

    @Nullable
    public final MRI exportFieldByMri(@NotNull ExportContext ctx, @NotNull MRI mri) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
        return Intrinsics.areEqual((Object)mri.getEntityType(), (Object)"customField") ? this.exportFieldOrNull(ctx, "customfield_" + mri.getEntityId()) : this.exportFieldOrNull(ctx, mri.getEntityId());
    }

    @Nullable
    public final MRI exportByMri(@NotNull ExportContext ctx, @NotNull MRI mri) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
        return this.exportByMriImpl(ctx, new ExporterKey(mri.getNamespace(), mri.getEntityType()), this.convertEntityId(mri));
    }

    private final <EntityKey> MRI exportByMriImpl(ExportContext ctx, ExporterKey exporterKey, EntityKey entityKey) {
        Exporter<?, ?, ?> exporter = this.exportersByKey.get(exporterKey);
        Intrinsics.checkNotNull(exporter, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.export.framework.Exporter<EntityKey of com.atlassian.jira.migration.export.service.ExportService.exportByMriImpl, kotlin.Any, *>");
        Exporter<?, ?, ?> exporter2 = exporter;
        return ExportService.exportByIdOrThrowImpl$default(this, ctx, exporter2, entityKey, null, 8, null);
    }

    private final Object convertEntityId(MRI mri) {
        return STRING_ENTITY_KEY.contains(mri.getEntityType()) ? mri.getEntityId() : Long.valueOf(Long.parseLong(mri.getEntityId()));
    }

    private final <EntityKey, JiraEntity> MRI exportByIdOrThrowImpl(ExportContext ctx, Exporter<EntityKey, JiraEntity, ?> exporter, EntityKey jiraEntityId, Function1<? super MRI, ? extends Exception> customExceptionSupplier) {
        MRI mri = exporter.mriForKey(jiraEntityId);
        if (ctx.contains(mri)) {
            return mri;
        }
        JiraEntity JiraEntity = exporter.extractServerEntity(ctx, jiraEntityId);
        if (JiraEntity == null) {
            if (customExceptionSupplier != null) {
                Function1<? super MRI, ? extends Exception> it = customExceptionSupplier;
                boolean bl = false;
                throw (Throwable)customExceptionSupplier.invoke((Object)mri);
            }
            throw new IllegalArgumentException("Entity with id=" + jiraEntityId + " for exporter " + exporter.getClass() + " not found");
        }
        JiraEntity jiraEntity = JiraEntity;
        if (exporter instanceof UnsupportedExporter) {
            ((UnsupportedExporter)exporter).handleUnsupported(ctx, jiraEntity);
            throw new IllegalStateException("attempted to export unsupported entity: " + EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, mri, jiraEntity, null, 4, null));
        }
        return ExportService.exportByEntityImpl$default(this, ctx, exporter, jiraEntity, false, false, 24, null);
    }

    static /* synthetic */ MRI exportByIdOrThrowImpl$default(ExportService exportService, ExportContext exportContext, Exporter exporter, Object object, Function1 function1, int n, Object object2) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        return exportService.exportByIdOrThrowImpl(exportContext, exporter, object, (Function1<? super MRI, ? extends Exception>)function1);
    }

    private final <EntityKey, JiraEntity> MRI exportByIdImpl(ExportContext ctx, Exporter<EntityKey, JiraEntity, ?> exporter, EntityKey jiraEntityId) {
        MRI mRI;
        MRI mri = exporter.mriForKey(jiraEntityId);
        if (ctx.contains(mri)) {
            return mri;
        }
        JiraEntity jiraEntity = exporter.extractServerEntity(ctx, jiraEntityId);
        if (exporter instanceof UnsupportedExporter) {
            mRI = null;
        } else {
            JiraEntity JiraEntity = jiraEntity;
            if (JiraEntity != null) {
                JiraEntity it = JiraEntity;
                boolean bl = false;
                mRI = ExportService.exportByEntityImpl$default(this, ctx, exporter, it, false, false, 24, null);
            } else {
                mRI = null;
            }
        }
        return mRI;
    }

    private final boolean isGlobalEntity(ExportContext ctx, Class<Object> cls) {
        return this.isFilteredGlobalEntity(ctx, cls, isGlobalEntity.1.INSTANCE);
    }

    private final boolean isPostGlobalEntity(ExportContext ctx, Class<Object> cls) {
        return this.isFilteredGlobalEntity(ctx, cls, isPostGlobalEntity.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isFilteredGlobalEntity(ExportContext ctx, Class<Object> cls, Function2<? super ExportContext, ? super Class<?>, Boolean> filter) {
        boolean bl;
        block4: {
            void $this$any$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = GLOBAL_ENTITIES;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Class it = (Class)element$iv$iv;
                boolean bl2 = false;
                if (!((Boolean)filter.invoke((Object)ctx, (Object)it)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl3 = false;
                    if (!it.isAssignableFrom(cls)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final <JiraEntity> MRI exportByEntityImpl(ExportContext ctx, Exporter<?, JiraEntity, ?> exporter, JiraEntity jiraEntity, boolean shouldForceChildren, boolean isGlobal) {
        MRI mri;
        block4: {
            mri = exporter.mriForEntity(jiraEntity);
            if (ctx.contains(mri)) {
                if (shouldForceChildren || ctx.shouldExportChildren(mri)) {
                    this.continueWithChildrenActions(exporter, ctx, jiraEntity, mri);
                }
                return mri;
            }
            this.isGlobalOrThrow(isGlobal, ctx, jiraEntity, mri);
            if (!ctx.indexAsSeen(mri)) {
                return mri;
            }
            Object exportResult = this.exportJiraEntity-0E7RQCE(ctx, jiraEntity, exporter);
            this.continueWithChildrenActions(exporter, ctx, jiraEntity, mri);
            IdentifiableEntity identifiableEntity = (IdentifiableEntity)(Result.isFailure-impl((Object)exportResult) ? null : exportResult);
            if (identifiableEntity == null) break block4;
            IdentifiableEntity it = identifiableEntity;
            boolean bl = false;
            if (!this.isPostGlobalEntity(ctx, jiraEntity.getClass())) {
                ctx.put(mri, it);
            }
        }
        return mri;
    }

    static /* synthetic */ MRI exportByEntityImpl$default(ExportService exportService, ExportContext exportContext, Exporter exporter, Object object, boolean bl, boolean bl2, int n, Object object2) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return exportService.exportByEntityImpl(exportContext, exporter, object, bl, bl2);
    }

    private final <JiraEntity> IdentifiableEntity exportByEntityObjectImpl(ExportContext ctx, Exporter<?, JiraEntity, ?> exporter, JiraEntity jiraEntity, boolean isGlobal) {
        MRI mri = exporter.mriForEntity(jiraEntity);
        this.isGlobalOrThrow(isGlobal, ctx, jiraEntity, mri);
        ctx.indexAsSeen(mri);
        Object exportResult = this.exportJiraEntity-0E7RQCE(ctx, jiraEntity, exporter);
        this.continueWithChildrenActions(exporter, ctx, jiraEntity, mri);
        Object object = exportResult;
        ResultKt.throwOnFailure((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        return (IdentifiableEntity)object2;
    }

    static /* synthetic */ IdentifiableEntity exportByEntityObjectImpl$default(ExportService exportService, ExportContext exportContext, Exporter exporter, Object object, boolean bl, int n, Object object2) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return exportService.exportByEntityObjectImpl(exportContext, exporter, object, bl);
    }

    private final <JiraEntity> void isGlobalOrThrow(boolean isGlobal, ExportContext ctx, JiraEntity jiraEntity, MRI mri) throws IllegalStateException {
        if (!isGlobal && this.isGlobalEntity(ctx, jiraEntity.getClass())) {
            throw new IllegalStateException("attempted to export global ordered entity by reference from the other one: " + EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, mri, jiraEntity, null, 4, null));
        }
    }

    private final <JiraEntity> Object exportJiraEntity-0E7RQCE(ExportContext ctx, JiraEntity jiraEntity, Exporter<?, JiraEntity, ?> exporter) {
        Object object;
        block6: {
            Object object2;
            MRI mri = exporter.mriForEntity(jiraEntity);
            object = this;
            try {
                IdentifiableEntity identifiableEntity;
                ExportService $this$exportJiraEntity_0E7RQCE_u24lambda_u249 = object;
                boolean bl = false;
                ExportMode exportMode = ctx.getExportMode();
                if (exportMode == ExportMode.BACKGROUND_PREPROCESSING) {
                    String timingKey = "* backgroundPreprocessing " + jiraEntity.getClass().getSimpleName();
                    identifiableEntity = (IdentifiableEntity)$this$exportJiraEntity_0E7RQCE_u24lambda_u249.timingMetrics.time((Map<String, MetricsInfo>)ctx.getMetricsMap(), ctx.getLogTimeMetricsFeatureFlag(), timingKey, (Function0)new Function0<IdentifiableEntity>(exporter, ctx, jiraEntity){
                        final /* synthetic */ Exporter<?, JiraEntity, ?> $exporter;
                        final /* synthetic */ ExportContext $ctx;
                        final /* synthetic */ JiraEntity $jiraEntity;
                        {
                            this.$exporter = $exporter;
                            this.$ctx = $ctx;
                            this.$jiraEntity = $jiraEntity;
                            super(0);
                        }

                        @NotNull
                        public final IdentifiableEntity invoke() {
                            ? exportedEntity = this.$exporter.exportData(this.$ctx, this.$jiraEntity);
                            this.$exporter.exportUsersAndGroups(this.$ctx, this.$jiraEntity);
                            return exportedEntity;
                        }
                    });
                } else if ($this$exportJiraEntity_0E7RQCE_u24lambda_u249.nonUserRefExportMode.contains((Object)exportMode)) {
                    String timingKey = "* exportData " + jiraEntity.getClass().getSimpleName();
                    identifiableEntity = (IdentifiableEntity)$this$exportJiraEntity_0E7RQCE_u24lambda_u249.timingMetrics.time((Map<String, MetricsInfo>)ctx.getMetricsMap(), ctx.getLogTimeMetricsFeatureFlag(), timingKey, (Function0)new Function0<IdentifiableEntity>(exporter, ctx, jiraEntity){
                        final /* synthetic */ Exporter<?, JiraEntity, ?> $exporter;
                        final /* synthetic */ ExportContext $ctx;
                        final /* synthetic */ JiraEntity $jiraEntity;
                        {
                            this.$exporter = $exporter;
                            this.$ctx = $ctx;
                            this.$jiraEntity = $jiraEntity;
                            super(0);
                        }

                        @NotNull
                        public final IdentifiableEntity invoke() {
                            return this.$exporter.exportData(this.$ctx, this.$jiraEntity);
                        }
                    });
                } else {
                    String timingKey = "* exportUsersAndGroups " + jiraEntity.getClass().getSimpleName();
                    $this$exportJiraEntity_0E7RQCE_u24lambda_u249.timingMetrics.time((Map<String, MetricsInfo>)ctx.getMetricsMap(), ctx.getLogTimeMetricsFeatureFlag(), timingKey, (Function0)new Function0<Unit>(exporter, ctx, jiraEntity){
                        final /* synthetic */ Exporter<?, JiraEntity, ?> $exporter;
                        final /* synthetic */ ExportContext $ctx;
                        final /* synthetic */ JiraEntity $jiraEntity;
                        {
                            this.$exporter = $exporter;
                            this.$ctx = $ctx;
                            this.$jiraEntity = $jiraEntity;
                            super(0);
                        }

                        public final void invoke() {
                            this.$exporter.exportUsersAndGroups(this.$ctx, this.$jiraEntity);
                        }
                    });
                    identifiableEntity = new IdentifiableEntity(mri){};
                }
                object2 = Result.constructor-impl((Object)identifiableEntity);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block6;
            Object it = object2 = throwable;
            boolean bl = false;
            ctx.handleExportFailure(mri, (Throwable)it, ctx.getMigrationId() + ": Exporting entity " + EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, mri, jiraEntity, null, 4, null) + " failed");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final <JiraEntity> void continueWithChildrenActions(Exporter<?, JiraEntity, ?> exporter, ExportContext ctx, JiraEntity jiraEntity, MRI mri) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = exporter.childrenActions(ctx, jiraEntity);
        boolean $i$f$mapNotNull = false;
        Iterator iterator2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Throwable it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            Function0 it = (Function0)element$iv$iv;
            boolean bl2 = false;
            try {
                object = Result.constructor-impl((Object)it.invoke());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.exceptionOrNull-impl((Object)object) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Throwable it = (Throwable)element$iv;
            boolean bl = false;
            ctx.handleExportFailure(mri, it, ctx.getMigrationId() + ": Exporting referenced entities by " + EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, mri, jiraEntity, null, 4, null) + " failed");
        }
    }

    @NotNull
    public final <JiraEntity> MRI exportOrDefault(@NotNull ExportContext ctx, @NotNull JiraEntity jiraEntity, @NotNull MRI defaultMRI) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(jiraEntity, (String)"jiraEntity");
        Intrinsics.checkNotNullParameter((Object)defaultMRI, (String)"defaultMRI");
        MRI mRI = this.exportOrNull(ctx, jiraEntity);
        if (mRI == null) {
            mRI = defaultMRI;
        }
        return mRI;
    }

    @Nullable
    public final <JiraEntity> MRI exportOrNull(@NotNull ExportContext ctx, @NotNull JiraEntity jiraEntity) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(jiraEntity, (String)"jiraEntity");
        Exporter<?, ?, ?> exporter = this.findExporter(jiraEntity.getClass());
        if (exporter instanceof UnsupportedExporter) {
            ((UnsupportedExporter)exporter).handleUnsupported(ctx, jiraEntity);
            mRI = null;
        } else if (exporter instanceof PartialExporter && !((PartialExporter)exporter).isEnabled()) {
            mRI = ((PartialExporter)exporter).handleDisabled(ctx, jiraEntity);
        } else {
            Exporter<?, ?, ?> exporter2 = exporter;
            if (exporter2 != null) {
                Exporter<?, ?, ?> exporter3 = exporter2;
                boolean bl = false;
                mRI = ExportService.exportByEntityImpl$default(this, ctx, exporter3, jiraEntity, false, false, 24, null);
            } else {
                mRI = null;
            }
        }
        return mRI;
    }

    @Nullable
    public final <EntityKey> MRI exportOrNull(@NotNull ExportContext ctx, @NotNull EntityType entityType, EntityKey entityKey) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Exporter<EntityKey, ?, ?> exporter = this.findExporter(entityType);
        if (exporter != null) {
            Exporter<EntityKey, ?, ?> exporter2 = exporter;
            boolean bl = false;
            mRI = this.exportByIdImpl(ctx, exporter2, entityKey);
        } else {
            mRI = null;
        }
        return mRI;
    }

    @NotNull
    public final <JiraEntity> CheckExportedResult checkExported(@NotNull ExportContext ctx, @NotNull JiraEntity jiraEntity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(jiraEntity, (String)"jiraEntity");
        MRI it = this.mri(jiraEntity);
        boolean bl = false;
        return new CheckExportedResult(it, ctx.contains(it));
    }

    @NotNull
    public final <EntityKey> CheckExportedResult checkExported(@NotNull ExportContext ctx, @NotNull EntityType entityType, EntityKey entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        MRI it = this.findExporterOrThrow(entityType).mriForKey(entityKey);
        boolean bl = false;
        return new CheckExportedResult(it, ctx.contains(it));
    }

    @NotNull
    public final <JiraEntity> MRI checkExportedOrThrow(@NotNull ExportContext ctx, @NotNull JiraEntity jiraEntity, @Nullable Function1<? super MRI, ? extends Exception> customExceptionSupplier) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(jiraEntity, (String)"jiraEntity");
        CheckExportedResult checkResult = this.checkExported(ctx, jiraEntity);
        boolean bl = false;
        this.handleNotExported(checkResult, customExceptionSupplier);
        return checkResult.getMri();
    }

    public static /* synthetic */ MRI checkExportedOrThrow$default(ExportService exportService, ExportContext exportContext, Object object, Function1 function1, int n, Object object2) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return exportService.checkExportedOrThrow(exportContext, object, (Function1<? super MRI, ? extends Exception>)function1);
    }

    @NotNull
    public final <EntityKey> MRI checkExportedOrThrow(@NotNull ExportContext ctx, @NotNull EntityType entityType, EntityKey entityKey, @Nullable Function1<? super MRI, ? extends Exception> customExceptionSupplier) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        CheckExportedResult checkResult = this.checkExported(ctx, entityType, entityKey);
        boolean bl = false;
        this.handleNotExported(checkResult, customExceptionSupplier);
        return checkResult.getMri();
    }

    public static /* synthetic */ MRI checkExportedOrThrow$default(ExportService exportService, ExportContext exportContext, EntityType entityType, Object object, Function1 function1, int n, Object object2) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        return exportService.checkExportedOrThrow(exportContext, entityType, object, (Function1<? super MRI, ? extends Exception>)function1);
    }

    private final void handleNotExported(CheckExportedResult checkResult, Function1<? super MRI, ? extends Exception> customExceptionSupplier) {
        checkResult.ifNotExported((Function1<? super MRI, Unit>)((Function1)new Function1<MRI, Unit>(customExceptionSupplier){
            final /* synthetic */ Function1<MRI, Exception> $customExceptionSupplier;
            {
                this.$customExceptionSupplier = $customExceptionSupplier;
                super(1);
            }

            public final void invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                Function1<MRI, Exception> function1 = this.$customExceptionSupplier;
                if (function1 != null) {
                    Function1<MRI, Exception> function12 = function1;
                    Function1<MRI, Exception> function13 = this.$customExceptionSupplier;
                    Function1<MRI, Exception> it = function12;
                    boolean bl = false;
                    throw (Throwable)function13.invoke((Object)mri);
                }
                throw new IllegalStateException("Entity " + mri + " is expected to be exported, but it was not");
            }
        }));
    }

    @Nullable
    public final <EntityKey> MRI getExportedOrNull(@NotNull ExportContext ctx, @NotNull EntityType entityType, EntityKey entityKey) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        MRI mRI = this.findExporter(entityType);
        if (mRI != null && (mRI = mRI.mriForKey(entityKey)) != null) {
            MRI mRI2;
            MRI it = mRI;
            boolean bl = false;
            MRI it2 = mRI2 = it;
            boolean bl2 = false;
            object = ctx.contains(it2) ? mRI2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final <JiraEntity> MRI mri(@NotNull JiraEntity jiraEntity) {
        Intrinsics.checkNotNullParameter(jiraEntity, (String)"jiraEntity");
        return this.findExporterOrThrow(jiraEntity.getClass()).mriForEntity(jiraEntity);
    }

    @NotNull
    public final MRI userRef(@NotNull ExportContext ctx, @NotNull UserRef ref) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this.usersExportService.userRef(ctx, ref);
    }

    @NotNull
    public final MRI projectRef(@NotNull Project ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Exporter<?, Project, ?> exporter = this.findExporter(Project.class);
        Intrinsics.checkNotNull(exporter);
        return exporter.mriForEntity(ref);
    }

    @NotNull
    public final String extractUserRefs(@NotNull ExportContext ctx, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.usersExportService.extractUserRefs(ctx, text);
    }

    @NotNull
    public final String extractUserRefsForAssetsText(@NotNull ExportContext ctx, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.usersExportService.extractUserRefsForAssetsText(ctx, text);
    }

    private final void addGroupToExportContext(ExportContext ctx, String groupName, boolean checkForEmptyName) {
        if (ctx.getExportMode() == ExportMode.COLLECT_USER_AND_GROUP_REFS) {
            boolean bl = checkForEmptyName ? !StringsKt.isBlank((CharSequence)groupName) : true;
            if (bl) {
                ctx.getGroupNames().add(groupName);
            }
        }
    }

    static /* synthetic */ void addGroupToExportContext$default(ExportService exportService, ExportContext exportContext, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        exportService.addGroupToExportContext(exportContext, string, bl);
    }

    @NotNull
    public final MRI groupRef(@NotNull ExportContext ctx, @NotNull Group group) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        String string = group.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.addGroupToExportContext(ctx, string, false);
        return this.usersExportService.groupRef(group);
    }

    @NotNull
    public final MRI groupRef(@NotNull ExportContext ctx, @NotNull GroupRefModel groupRef) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)groupRef, (String)"groupRef");
        ExportService.addGroupToExportContext$default(this, ctx, groupRef.getGroupName(), false, 4, null);
        return this.usersExportService.groupRef(groupRef);
    }

    @Nullable
    public final MRI groupRefOrNull(@NotNull ExportContext ctx, @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        ExportService.addGroupToExportContext$default(this, ctx, groupName, false, 4, null);
        return this.usersExportService.groupRefOrNull(groupName);
    }

    @Nullable
    public final MRI groupRefSkipInvalid(@NotNull ExportContext ctx, @NotNull GroupRefModel groupRef) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)groupRef, (String)"groupRef");
        ExportService.addGroupToExportContext$default(this, ctx, groupRef.getGroupName(), false, 4, null);
        MRI group = mRI = this.usersExportService.groupRefOrNull(groupRef.getGroupName());
        boolean bl = false;
        MRI mRI2 = group;
        if (mRI2 == null) {
            this.logSkipInvalidGroupReference(groupRef);
            mRI2 = Unit.INSTANCE;
        }
        return mRI;
    }

    public final boolean skipInvalidGroup(@NotNull SharePermission sharePermission, @NotNull GroupRefModel groupRef) {
        Intrinsics.checkNotNullParameter((Object)sharePermission, (String)"sharePermission");
        Intrinsics.checkNotNullParameter((Object)groupRef, (String)"groupRef");
        if (!Intrinsics.areEqual((Object)sharePermission.getType(), (Object)ShareType.Name.GROUP) || this.usersExportService.groupRefOrNull(sharePermission.getParam1().toString()) != null) {
            return true;
        }
        this.logSkipInvalidGroupReference(groupRef);
        return false;
    }

    @NotNull
    public final MRI exportField(@NotNull ExportContext ctx, @NotNull String id) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (StringsKt.startsWith$default((String)id, (String)"customfield_", (boolean)false, (int)2, null)) {
            CustomField customField = this.customFieldManager.getCustomFieldObject(id);
            if (customField == null) {
                MRI mRI2 = MriExtensionsKt.mri$default(com.atlassian.migration.jira.classic.customfield.CustomField.Companion.getEntityType(), id, null, 2, null);
                String string = "Failed to get custom field with ID: " + id;
                ExportErrorCode exportErrorCode = ExportErrorCode.GENERIC_ERROR_CODE;
                throw new ExportException(mRI2, exportErrorCode, string, "Check that the custom field exists and that related application components are enabled.", null, null, null, 112, null);
            }
            CustomField customField2 = customField;
            mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(this, ctx, customField2, false, 4, null);
        } else {
            mRI = MriExtensionsKt.mri(JiraCoreMriRegistry.INSTANCE.getStandardField(), id, MRIType.RESULTING);
        }
        return mRI;
    }

    @Nullable
    public final MRI exportFieldOrNull(@NotNull ExportContext ctx, @NotNull String id) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        boolean isSupportedField = this.exportFilters.isSupportedFieldById(ctx, id);
        if (StringsKt.startsWith$default((String)id, (String)"customfield_", (boolean)false, (int)2, null)) {
            CustomField customField = this.customFieldManager.getCustomFieldObject(id);
            if (customField == null) {
                return null;
            }
            CustomField customField2 = customField;
            if (isSupportedField) {
                mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(this, ctx, customField2, false, 4, null);
            } else {
                CustomFieldUtilsKt.handleUnsupported(customField2, ctx);
                mRI = null;
            }
        } else {
            mRI = StringsKt.isBlank((CharSequence)id) || !isSupportedField ? null : MriExtensionsKt.mri(JiraCoreMriRegistry.INSTANCE.getStandardField(), id, MRIType.RESULTING);
        }
        return mRI;
    }

    private final void logSkipInvalidGroupReference(GroupRefModel groupRef) {
        log.warn(groupRef.getTitle() + '(' + groupRef.getId() + ") has reference to group " + groupRef.getGroupName() + " which cannot be found in jiraGroupManager. Skipping...");
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(ExportService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        Object[] objectArray = new Class[]{Status.class, Priority.class, Resolution.class, ProjectCategory.class};
        GLOBAL_ENTITIES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"issueStatus", "priority", "resolution", "issueType"};
        STRING_ENTITY_KEY = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u001a\u0010\u0011\u001a\u00020\u00002\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013J\u001a\u0010\u0015\u001a\u00020\u00002\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/service/ExportService$CheckExportedResult;", "", "mri", "Lcom/atlassian/migration/base/mri/MRI;", "isExported", "", "(Lcom/atlassian/migration/base/mri/MRI;Z)V", "()Z", "getMri", "()Lcom/atlassian/migration/base/mri/MRI;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "ifExported", "block", "Lkotlin/Function1;", "", "ifNotExported", "toString", "", "jira-migration-plugin"})
    public static final class CheckExportedResult {
        @NotNull
        private final MRI mri;
        private final boolean isExported;

        public CheckExportedResult(@NotNull MRI mri, boolean isExported) {
            Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
            this.mri = mri;
            this.isExported = isExported;
        }

        @NotNull
        public final MRI getMri() {
            return this.mri;
        }

        public final boolean isExported() {
            return this.isExported;
        }

        @NotNull
        public final CheckExportedResult ifExported(@NotNull Function1<? super MRI, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            if (this.isExported) {
                block.invoke((Object)this.mri);
            }
            return this;
        }

        @NotNull
        public final CheckExportedResult ifNotExported(@NotNull Function1<? super MRI, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            if (!this.isExported) {
                block.invoke((Object)this.mri);
            }
            return this;
        }

        @NotNull
        public final MRI component1() {
            return this.mri;
        }

        public final boolean component2() {
            return this.isExported;
        }

        @NotNull
        public final CheckExportedResult copy(@NotNull MRI mri, boolean isExported) {
            Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
            return new CheckExportedResult(mri, isExported);
        }

        public static /* synthetic */ CheckExportedResult copy$default(CheckExportedResult checkExportedResult, MRI mRI, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                mRI = checkExportedResult.mri;
            }
            if ((n & 2) != 0) {
                bl = checkExportedResult.isExported;
            }
            return checkExportedResult.copy(mRI, bl);
        }

        @NotNull
        public String toString() {
            return "CheckExportedResult(mri=" + this.mri + ", isExported=" + this.isExported + ')';
        }

        public int hashCode() {
            int result2 = this.mri.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isExported);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CheckExportedResult)) {
                return false;
            }
            CheckExportedResult checkExportedResult = (CheckExportedResult)other;
            if (!Intrinsics.areEqual((Object)this.mri, (Object)checkExportedResult.mri)) {
                return false;
            }
            return this.isExported == checkExportedResult.isExported;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/service/ExportService$Companion;", "", "()V", "GLOBAL_ENTITIES", "", "Ljava/lang/Class;", "STRING_ENTITY_KEY", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

