/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.service;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.migration.common.Constants;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.UsersExportService;
import com.atlassian.jira.migration.jiraservice.JiraGroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIType;
import com.atlassian.migration.core.MigrationCoreMriRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\rJ\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/service/UsersExportService;", "", "jiraGroupManager", "Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "(Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;Lcom/atlassian/jira/user/util/UserManager;)V", "collectUserRefs", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "users", "", "", "extractUserRefs", "text", "extractUserRefsForAssetsText", "groupRef", "Lcom/atlassian/migration/base/mri/MRI;", "group", "Lcom/atlassian/crowd/embedded/api/Group;", "Lcom/atlassian/jira/migration/export/model/GroupRefModel;", "groupRefOrNull", "ref", "userRef", "Lcom/atlassian/jira/migration/export/model/UserRef;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUsersExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsersExportService.kt\ncom/atlassian/jira/migration/export/service/UsersExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1603#2,9:148\n1855#2:157\n1856#2:159\n1612#2:160\n1549#2:161\n1620#2,3:162\n1#3:158\n1#3:165\n*S KotlinDebug\n*F\n+ 1 UsersExportService.kt\ncom/atlassian/jira/migration/export/service/UsersExportService\n*L\n50#1:148,9\n50#1:157\n50#1:159\n50#1:160\n50#1:161\n50#1:162,3\n50#1:158\n*E\n"})
public final class UsersExportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraGroupManager jiraGroupManager;
    @NotNull
    private final UserManager userManager;
    @NotNull
    public static final String MRI_USER_KEY_PREFIX = "jira.userkey/";
    @NotNull
    private static final Regex userNameTaggedPattern = new Regex("\\[~([^\\[\\]\\t\\n\\x0B\\f\\r]{1,100})\\]", RegexOption.IGNORE_CASE);
    @NotNull
    private static final Regex userNameTaggedPatternForAssets = new Regex("data-mention-id=\"([^\"]+)\"", RegexOption.IGNORE_CASE);

    @Inject
    public UsersExportService(@NotNull JiraGroupManager jiraGroupManager, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter((Object)jiraGroupManager, (String)"jiraGroupManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        this.jiraGroupManager = jiraGroupManager;
        this.userManager = userManager;
    }

    @NotNull
    public final String extractUserRefs(@NotNull ExportContext ctx, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.collectUserRefs(ctx, UsersExportService.Companion.usersInText(text));
        return text;
    }

    @NotNull
    public final String extractUserRefsForAssetsText(@NotNull ExportContext ctx, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.collectUserRefs(ctx, UsersExportService.Companion.usersInTextForAssets(text));
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final void collectUserRefs(ExportContext ctx, List<String> users2) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = users2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            UserRef it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (UserRef.Companion.fromString(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (UserRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.userRef(ctx, (UserRef)it));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public final MRI userRef(@NotNull ExportContext ctx, @NotNull UserRef userRef) {
        MRI mRI;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)userRef, (String)"userRef");
        String ref = userRef.component1();
        ApplicationUser applicationUser = this.userManager.getUserByKey(ref);
        if (applicationUser == null) {
            applicationUser = this.userManager.getUserByName(ref);
        }
        ApplicationUser appUser = applicationUser;
        if (appUser == null || (charSequence = (CharSequence)appUser.getKey()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            ctx.getDeletedUserKeys().add(ref);
            mRI = UsersExportService.Companion.userKeyMri(ref);
        } else if (Constants.INSTANCE.shouldNotMigrate(appUser)) {
            Set<String> set = ctx.getDeletedUserKeys();
            String string = appUser.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            set.add(string);
            String string2 = appUser.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
            mRI = UsersExportService.Companion.userKeyMri(string2);
        } else {
            ctx.getUsers().add(appUser);
            String string = appUser.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            mRI = UsersExportService.Companion.userKeyMri(string);
        }
        return mRI;
    }

    @NotNull
    public final MRI groupRef(@NotNull GroupRefModel groupRef) {
        Group group;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)groupRef, (String)"groupRef");
                group = this.jiraGroupManager.getGroup(groupRef.getGroupName());
                if (group == null) break block2;
                Group p0 = group;
                boolean bl = false;
                MRI mRI = this.groupRef(p0);
                group = mRI;
                if (mRI != null) break block3;
            }
            MRI mRI = UsersExportService.Companion.groupMri(groupRef.getGroupName());
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_GROUP_REFERENCE_NOT_FOUND;
            String string = "Details: " + groupRef.getTitle() + " with id - [" + groupRef.getId() + "] has missing reference to group - [" + groupRef.getGroupName() + ']';
            throw new ExportException(mRI, exportErrorCode, "Group reference could not be found", string, null, null, null, 112, null);
        }
        return group;
    }

    @Nullable
    public final MRI groupRefOrNull(@NotNull String ref) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Group group = this.jiraGroupManager.getGroup(ref);
        if (group != null) {
            Group p0 = group;
            boolean bl = false;
            mRI = this.groupRef(p0);
        } else {
            mRI = null;
        }
        return mRI;
    }

    @NotNull
    public final MRI groupRef(@NotNull Group group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        try {
            String string = group.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return UsersExportService.Companion.groupMri(string);
        }
        catch (IllegalArgumentException ex) {
            MRI mRI = MriExtensionsKt.dummyMri(MigrationCoreMriRegistry.INSTANCE.getGroup(), MRIType.MISSING);
            String string = "Cannot create MRI for a group named: '" + group.getName() + '\'';
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_GROUP_REFERENCE_EMPTY_NAME;
            String string2 = "Details: Group malformed. " + ex.getMessage();
            throw new ExportException(mRI, exportErrorCode, string, string2, null, null, null, 112, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/service/UsersExportService$Companion;", "", "()V", "MRI_USER_KEY_PREFIX", "", "userNameTaggedPattern", "Lkotlin/text/Regex;", "userNameTaggedPatternForAssets", "groupMri", "Lcom/atlassian/migration/base/mri/MRI;", "groupName", "userKeyMri", "userKey", "usersInText", "", "text", "usersInTextForAssets", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final MRI userKeyMri(String userKey) {
            return MriExtensionsKt.mri$default(MigrationCoreMriRegistry.INSTANCE.getUser(), UsersExportService.MRI_USER_KEY_PREFIX + userKey, null, 2, null);
        }

        private final MRI groupMri(String groupName) {
            return MriExtensionsKt.mri(MigrationCoreMriRegistry.INSTANCE.getGroup(), groupName, MRIType.RESULTING);
        }

        private final List<String> usersInText(String text) {
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)userNameTaggedPattern, (CharSequence)text, (int)0, (int)2, null), (Function1)usersInText.1.INSTANCE));
        }

        private final List<String> usersInTextForAssets(String text) {
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)userNameTaggedPatternForAssets, (CharSequence)text, (int)0, (int)2, null), (Function1)usersInTextForAssets.1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

