/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.ServiceDeskCoreDataReader;
import com.atlassian.jira.migration.db.servicedesk.ServiceDeskProjectData;
import com.atlassian.jira.migration.db.servicedesk.calendar.Calendar;
import com.atlassian.jira.migration.db.servicedesk.calendar.CalendarReader;
import com.atlassian.jira.migration.db.servicedesk.queue.Queue;
import com.atlassian.jira.migration.db.servicedesk.queue.QueueReader;
import com.atlassian.jira.migration.db.servicedesk.requesttype.JiraRequestTypeGroup;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestType;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeGroupReader;
import com.atlassian.jira.migration.db.servicedesk.timemetric.TimeMetricData;
import com.atlassian.jira.migration.export.db.servicedesk.automation.AutomationRunAsConfigReader;
import com.atlassian.jira.migration.export.db.servicedesk.automation.AutomationRunAsConfigSettings;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleSetDetails;
import com.atlassian.jira.migration.export.db.servicedesk.csat.CsatSettingsReader;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.DefaultLanguageAndCreatedTimestamp;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoProjectLanguage;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoTranslationReader;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoTranslationsWrapper;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.ProjectLanguageReader;
import com.atlassian.jira.migration.export.db.servicedesk.notification.CustomerNotificationTemplateReader;
import com.atlassian.jira.migration.export.db.servicedesk.notification.CustomerNotificationTemplateWrapper;
import com.atlassian.jira.migration.export.db.servicedesk.organization.CustomerOrganizationData;
import com.atlassian.jira.migration.export.db.servicedesk.organization.CustomerOrganizationReader;
import com.atlassian.jira.migration.export.db.servicedesk.portalsettings.PortalData;
import com.atlassian.jira.migration.export.db.servicedesk.portalsettings.PortalReader;
import com.atlassian.jira.migration.export.db.servicedesk.report.Report;
import com.atlassian.jira.migration.export.db.servicedesk.report.ReportReader;
import com.atlassian.jira.migration.export.db.servicedesk.report.Series;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.automation.AutomationServiceFacade;
import com.atlassian.jira.migration.export.servicedesk.lingo.LingoEntityExportValidator;
import com.atlassian.jira.migration.export.servicedesk.lingo.ProjectLanguageWrapper;
import com.atlassian.jira.migration.export.servicedesk.organization.CustomerOrganizationProjectAssociationWrapper;
import com.atlassian.jira.migration.export.servicedesk.requesttype.RequestTypeService;
import com.atlassian.jira.migration.export.servicedesk.timemetric.TimeMetricService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.servicedesk.Servicedesk;
import com.atlassian.servicedesk.api.ServiceDesk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 T2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001TB\u008f\u0001\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010!\u001a\u00020\"\u0012\u0006\u0010#\u001a\u00020$\u0012\u0006\u0010%\u001a\u00020&\u00a2\u0006\u0002\u0010'J$\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0-2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0016J\u0015\u00103\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b6J\u001d\u00107\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b8J\u001d\u00109\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b<J\u0016\u0010=\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003J\u0018\u0010>\u001a\u00020\u00042\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0016J\u0015\u0010?\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b@J\u001d\u0010A\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bBJ\u0015\u0010C\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\bDJ\u000e\u0010E\u001a\u00020/2\u0006\u00100\u001a\u000201J\u001d\u0010F\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010G\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bHJ\u0016\u0010I\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003J\u0016\u0010J\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003J\u001d\u0010K\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bLJ\u0018\u0010M\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0016J\u0018\u0010N\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0002J\u0010\u0010O\u001a\u00020P2\u0006\u00102\u001a\u00020\u0003H\u0016J\u0010\u0010Q\u001a\u00020P2\u0006\u0010R\u001a\u00020\u0002H\u0016J\b\u0010S\u001a\u00020/H\u0007R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/ServiceDeskExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/servicedesk/api/ServiceDesk;", "Lcom/atlassian/migration/jira/servicedesk/Servicedesk;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "serviceDeskCoreDataReader", "Lcom/atlassian/jira/migration/db/servicedesk/ServiceDeskCoreDataReader;", "queueReader", "Lcom/atlassian/jira/migration/db/servicedesk/queue/QueueReader;", "requestTypeService", "Lcom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeService;", "requestTypeGroupReader", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeGroupReader;", "portalReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/portalsettings/PortalReader;", "timeMetricService", "Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricService;", "automationService", "Lcom/atlassian/jira/migration/export/servicedesk/automation/AutomationServiceFacade;", "calendarReader", "Lcom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader;", "customerNotificationTemplateReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/notification/CustomerNotificationTemplateReader;", "projectLanguageReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/ProjectLanguageReader;", "lingoTranslationReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationReader;", "csatSettingsReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/csat/CsatSettingsReader;", "reportReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/report/ReportReader;", "automationRunAsConfigReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/automation/AutomationRunAsConfigReader;", "customerOrganizationReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/organization/CustomerOrganizationReader;", "lingoEntityExportValidator", "Lcom/atlassian/jira/migration/export/servicedesk/lingo/LingoEntityExportValidator;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/db/servicedesk/ServiceDeskCoreDataReader;Lcom/atlassian/jira/migration/db/servicedesk/queue/QueueReader;Lcom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeService;Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeGroupReader;Lcom/atlassian/jira/migration/export/db/servicedesk/portalsettings/PortalReader;Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricService;Lcom/atlassian/jira/migration/export/servicedesk/automation/AutomationServiceFacade;Lcom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader;Lcom/atlassian/jira/migration/export/db/servicedesk/notification/CustomerNotificationTemplateReader;Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/ProjectLanguageReader;Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationReader;Lcom/atlassian/jira/migration/export/db/servicedesk/csat/CsatSettingsReader;Lcom/atlassian/jira/migration/export/db/servicedesk/report/ReportReader;Lcom/atlassian/jira/migration/export/db/servicedesk/automation/AutomationRunAsConfigReader;Lcom/atlassian/jira/migration/export/db/servicedesk/organization/CustomerOrganizationReader;Lcom/atlassian/jira/migration/export/servicedesk/lingo/LingoEntityExportValidator;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportAutomation", "exportAutomation$jira_migration_plugin", "exportAutomationRunAsConfigSettings", "exportAutomationRunAsConfigSettings$jira_migration_plugin", "exportCalendars", "exportCalendars$jira_migration_plugin", "exportCsatSettings", "exportCsatSettings$jira_migration_plugin", "exportCustomerNotifications", "exportCustomerNotifications$jira_migration_plugin", "exportCustomerOrganizations", "exportData", "exportLingoTranslations", "exportLingoTranslations$jira_migration_plugin", "exportPortalSettings", "exportPortalSettings$jira_migration_plugin", "exportProjectLanguages", "exportProjectLanguages$jira_migration_plugin", "exportQueues", "exportReport", "serviceDesk", "exportReport$jira_migration_plugin", "exportRequestTypeGroups", "exportRequestTypes", "exportTimeMetric", "exportTimeMetric$jira_migration_plugin", "exportUsersAndGroups", "mapCreatedByUserKey", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServiceDeskExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceDeskExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/ServiceDeskExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,243:1\n1#2:244\n1855#3,2:245\n1855#3,2:247\n1855#3,2:251\n1855#3,2:253\n1549#3:255\n1620#3,3:256\n766#3:259\n857#3,2:260\n1855#3,2:262\n1855#3,2:264\n1855#3,2:266\n1549#3:268\n1620#3,2:269\n766#3:271\n857#3,2:272\n1622#3:274\n1855#3,2:275\n1313#4,2:249\n*S KotlinDebug\n*F\n+ 1 ServiceDeskExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/ServiceDeskExporter\n*L\n128#1:245,2\n145#1:247,2\n155#1:251,2\n161#1:253,2\n166#1:255\n166#1:256,3\n171#1:259\n171#1:260,2\n172#1:262,2\n176#1:264,2\n212#1:266,2\n227#1:268\n227#1:269,2\n228#1:271\n228#1:272,2\n227#1:274\n230#1:275,2\n149#1:249,2\n*E\n"})
public final class ServiceDeskExporter
implements Exporter<Long, ServiceDesk, Servicedesk> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ServiceDeskCoreDataReader serviceDeskCoreDataReader;
    @NotNull
    private final QueueReader queueReader;
    @NotNull
    private final RequestTypeService requestTypeService;
    @NotNull
    private final RequestTypeGroupReader requestTypeGroupReader;
    @NotNull
    private final PortalReader portalReader;
    @NotNull
    private final TimeMetricService timeMetricService;
    @NotNull
    private final AutomationServiceFacade automationService;
    @NotNull
    private final CalendarReader calendarReader;
    @NotNull
    private final CustomerNotificationTemplateReader customerNotificationTemplateReader;
    @NotNull
    private final ProjectLanguageReader projectLanguageReader;
    @NotNull
    private final LingoTranslationReader lingoTranslationReader;
    @NotNull
    private final CsatSettingsReader csatSettingsReader;
    @NotNull
    private final ReportReader reportReader;
    @NotNull
    private final AutomationRunAsConfigReader automationRunAsConfigReader;
    @NotNull
    private final CustomerOrganizationReader customerOrganizationReader;
    @NotNull
    private final LingoEntityExportValidator lingoEntityExportValidator;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskExporter.class);

    @Inject
    public ServiceDeskExporter(@NotNull ExportService exportService, @NotNull ServiceDeskCoreDataReader serviceDeskCoreDataReader, @NotNull QueueReader queueReader, @NotNull RequestTypeService requestTypeService, @NotNull RequestTypeGroupReader requestTypeGroupReader, @NotNull PortalReader portalReader, @NotNull TimeMetricService timeMetricService, @NotNull AutomationServiceFacade automationService, @NotNull CalendarReader calendarReader, @NotNull CustomerNotificationTemplateReader customerNotificationTemplateReader, @NotNull ProjectLanguageReader projectLanguageReader, @NotNull LingoTranslationReader lingoTranslationReader, @NotNull CsatSettingsReader csatSettingsReader, @NotNull ReportReader reportReader, @NotNull AutomationRunAsConfigReader automationRunAsConfigReader, @NotNull CustomerOrganizationReader customerOrganizationReader, @NotNull LingoEntityExportValidator lingoEntityExportValidator) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)serviceDeskCoreDataReader, (String)"serviceDeskCoreDataReader");
        Intrinsics.checkNotNullParameter((Object)queueReader, (String)"queueReader");
        Intrinsics.checkNotNullParameter((Object)requestTypeService, (String)"requestTypeService");
        Intrinsics.checkNotNullParameter((Object)requestTypeGroupReader, (String)"requestTypeGroupReader");
        Intrinsics.checkNotNullParameter((Object)portalReader, (String)"portalReader");
        Intrinsics.checkNotNullParameter((Object)timeMetricService, (String)"timeMetricService");
        Intrinsics.checkNotNullParameter((Object)automationService, (String)"automationService");
        Intrinsics.checkNotNullParameter((Object)calendarReader, (String)"calendarReader");
        Intrinsics.checkNotNullParameter((Object)customerNotificationTemplateReader, (String)"customerNotificationTemplateReader");
        Intrinsics.checkNotNullParameter((Object)projectLanguageReader, (String)"projectLanguageReader");
        Intrinsics.checkNotNullParameter((Object)lingoTranslationReader, (String)"lingoTranslationReader");
        Intrinsics.checkNotNullParameter((Object)csatSettingsReader, (String)"csatSettingsReader");
        Intrinsics.checkNotNullParameter((Object)reportReader, (String)"reportReader");
        Intrinsics.checkNotNullParameter((Object)automationRunAsConfigReader, (String)"automationRunAsConfigReader");
        Intrinsics.checkNotNullParameter((Object)customerOrganizationReader, (String)"customerOrganizationReader");
        Intrinsics.checkNotNullParameter((Object)lingoEntityExportValidator, (String)"lingoEntityExportValidator");
        this.exportService = exportService;
        this.serviceDeskCoreDataReader = serviceDeskCoreDataReader;
        this.queueReader = queueReader;
        this.requestTypeService = requestTypeService;
        this.requestTypeGroupReader = requestTypeGroupReader;
        this.portalReader = portalReader;
        this.timeMetricService = timeMetricService;
        this.automationService = automationService;
        this.calendarReader = calendarReader;
        this.customerNotificationTemplateReader = customerNotificationTemplateReader;
        this.projectLanguageReader = projectLanguageReader;
        this.lingoTranslationReader = lingoTranslationReader;
        this.csatSettingsReader = csatSettingsReader;
        this.reportReader = reportReader;
        this.automationRunAsConfigReader = automationRunAsConfigReader;
        this.customerOrganizationReader = customerOrganizationReader;
        this.lingoEntityExportValidator = lingoEntityExportValidator;
        this.key = new ExporterKey(Servicedesk.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ServiceDesk.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Servicedesk.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public Servicedesk exportData(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Date date;
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        log.info(StringsKt.trimIndent((String)("\n            Exporting Service Desk entity \" " + entity.getId() + ", \"for project \", " + entity.getProjectName() + ") for migration to Cloud as " + ctx.getStartedBy() + "\n            ")));
        ServiceDeskProjectData serviceDeskEntityData = this.serviceDeskCoreDataReader.getServiceDeskProjectDataByProjectId(entity.getProjectId());
        MRI entityMri = this.mriForEntity(entity);
        MRI mRI = this.exportService.checkExportedOrThrow(ctx, ctx.getProject(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, ctx){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entityMri = $entityMri;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "Service Desk with MRI - " + this.$entityMri + " has missing Project with MRI - " + mri + '.';
                String string2 = "Verify if Project with id " + this.$ctx.getProject().getId() + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        }));
        ServiceDeskProjectData serviceDeskProjectData = serviceDeskEntityData;
        if (serviceDeskProjectData != null) {
            ServiceDeskProjectData it = serviceDeskProjectData;
            boolean bl2 = false;
            Boolean bl3 = serviceDeskEntityData.getCreatedWithEmptyProject();
            bl = bl3 != null ? bl3 : true;
        } else {
            bl = null;
        }
        Boolean bl4 = bl;
        ServiceDeskProjectData serviceDeskProjectData2 = serviceDeskEntityData;
        Boolean bl5 = serviceDeskProjectData2 != null ? serviceDeskProjectData2.getOpenCustomerAccess() : null;
        ServiceDeskProjectData serviceDeskProjectData3 = serviceDeskEntityData;
        String string = serviceDeskProjectData3 != null ? serviceDeskProjectData3.getVersionCreatedAt() : null;
        ServiceDeskProjectData serviceDeskProjectData4 = serviceDeskEntityData;
        if (serviceDeskProjectData4 != null) {
            ServiceDeskProjectData it = serviceDeskProjectData4;
            boolean bl6 = false;
            date = serviceDeskEntityData.getCreatedDate();
            if (date == null) {
                date = new Date();
            }
        } else {
            date = null;
        }
        Date date2 = date;
        ServiceDeskProjectData serviceDeskProjectData5 = serviceDeskEntityData;
        String string2 = serviceDeskProjectData5 != null ? serviceDeskProjectData5.getCreatedByUserKey() : null;
        return new Servicedesk(entityMri, mRI, bl4, bl5, string2, string, date2, null, 128, null);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Function0[]{new Function0<Unit>(this, ctx){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportQueues(this.$ctx);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ServiceDesk $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportRequestTypeGroups(this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ServiceDesk $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportRequestTypes(this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ServiceDesk $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportCustomerOrganizations(this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ServiceDesk $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportTimeMetric$jira_migration_plugin(this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ServiceDesk $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportPortalSettings$jira_migration_plugin(this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportAutomation$jira_migration_plugin(this.$ctx);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ServiceDesk $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportCalendars$jira_migration_plugin(this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportCustomerNotifications$jira_migration_plugin(this.$ctx);
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportProjectLanguages$jira_migration_plugin(this.$ctx);
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportLingoTranslations$jira_migration_plugin(this.$ctx);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ServiceDesk $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportCsatSettings$jira_migration_plugin(this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ServiceDesk $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportReport$jira_migration_plugin(this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx){
            final /* synthetic */ ServiceDeskExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportAutomationRunAsConfigSettings$jira_migration_plugin(this.$ctx);
            }
        }};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    public final void exportRequestTypeGroups(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        List<JiraRequestTypeGroup> allGroups2 = this.requestTypeGroupReader.getRequestTypeGroupsForProject(entity.getId());
        Iterable $this$forEach$iv = allGroups2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JiraRequestTypeGroup it = (JiraRequestTypeGroup)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        log.debug("Exporting users and groups for service desk {} for migration {} under exportMode {}", objectArray);
        this.mapCreatedByUserKey(ctx, entity);
    }

    private final void mapCreatedByUserKey(ExportContext ctx, ServiceDesk entity) {
        block0: {
            ServiceDeskProjectData serviceDeskEntityData;
            ServiceDeskProjectData serviceDeskProjectData = serviceDeskEntityData = this.serviceDeskCoreDataReader.getServiceDeskProjectDataByProjectId(entity.getProjectId());
            UserRef userRef = UserRef.Companion.fromString(serviceDeskProjectData != null ? serviceDeskProjectData.getCreatedByUserKey() : null);
            if (userRef == null) break block0;
            UserRef it = userRef;
            boolean bl = false;
            this.exportService.userRef(ctx, it);
        }
    }

    public final void exportQueues(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Long l = ctx.getProject().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        Iterable $this$forEach$iv = this.queueReader.getQueuesForProject(((Number)l).longValue());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Queue it = (Queue)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    public final void exportRequestTypes(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Sequence<RequestType> $this$forEach$iv = this.requestTypeService.getRequestTypesForServiceDeskProject(entity);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RequestType it = (RequestType)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    public final void exportCustomerOrganizations(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = ctx.getProject().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        Iterable $this$forEach$iv = this.customerOrganizationReader.getCustomerOrganizations(((Number)l).longValue());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CustomerOrganizationData it = (CustomerOrganizationData)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, new CustomerOrganizationProjectAssociationWrapper(entity, it), false, 4, null);
        }
    }

    public final void exportTimeMetric$jira_migration_plugin(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Iterable $this$forEach$iv = this.timeMetricService.getTimeMetricByServiceDeskId(entity.getId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimeMetricData it = (TimeMetricData)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void exportAutomation$jira_migration_plugin(@NotNull ExportContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Long l = ctx.getProject().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        Iterable $this$map$iv = this.automationService.getAllRuleSetDetails(((Number)l).longValue());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RuleSetDetails ruleSetDetails = (RuleSetDetails)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void exportCalendars$jira_migration_plugin(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Iterable $this$filter$iv = this.calendarReader.getAllCalendars();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Calendar it = (Calendar)element$iv$iv;
            boolean bl = false;
            if (!(it.getServiceDeskId() == entity.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Calendar it = (Calendar)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    public final void exportPortalSettings$jira_migration_plugin(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Iterable $this$forEach$iv = this.portalReader.getPortalDataForProject(entity);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PortalData it = (PortalData)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    public final void exportProjectLanguages$jira_migration_plugin(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        DefaultLanguageAndCreatedTimestamp defaultLanguageAndCreatedTimestamp = this.projectLanguageReader.getDefaultLanguageAndTimestampForProject(ctx.getProject());
        if (defaultLanguageAndCreatedTimestamp != null) {
            List<LingoProjectLanguage> languages = this.projectLanguageReader.getAllLanguagesForProject(ctx.getProject());
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, new ProjectLanguageWrapper(defaultLanguageAndCreatedTimestamp.getDefaultLanguage(), languages, defaultLanguageAndCreatedTimestamp.getCreatedTimestamp()), false, 4, null);
        } else {
            log.info("Could not find default language or created timestamp, or both for project [" + ctx.getProject().getId() + ']');
        }
    }

    public final void exportCustomerNotifications$jira_migration_plugin(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        CustomerNotificationTemplateWrapper it = this.customerNotificationTemplateReader.getCustomerNotificationTemplateWrapper(ctx);
        boolean bl = false;
        ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
    }

    public final void exportLingoTranslations$jira_migration_plugin(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List<LingoTranslationsWrapper> projectLingoTranslations = this.lingoTranslationReader.getLingoTranslationForProject(ctx.getProject());
        Long l = ctx.getProject().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        List<LingoTranslationsWrapper> filteredProjectLingoTranslations = this.lingoEntityExportValidator.filterEntitiesNotEligibleForExport(((Number)l).longValue(), projectLingoTranslations);
        Iterable $this$forEach$iv = filteredProjectLingoTranslations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LingoTranslationsWrapper it = (LingoTranslationsWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    public final void exportCsatSettings$jira_migration_plugin(@NotNull ExportContext ctx, @NotNull ServiceDesk entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, this.csatSettingsReader.getCsatSettingsForServiceDesk(entity.getId()), false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void exportReport$jira_migration_plugin(@NotNull ExportContext ctx, @NotNull ServiceDesk serviceDesk) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)serviceDesk, (String)"serviceDesk");
        List<Report> reportsWithoutSeries = this.reportReader.getAllReportsWithoutSeriesForServicedesk(serviceDesk);
        List<Series> allSeries = this.reportReader.getAllSeriesForReportBatch(reportsWithoutSeries);
        Iterable $this$map$iv = reportsWithoutSeries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void report;
            void var15_16;
            Report report2 = (Report)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$exportReport_u24lambda_u2416_u24lambda_u2415 = var15_16 = report;
            boolean bl2 = false;
            Iterable iterable2 = allSeries;
            void var19_20 = $this$exportReport_u24lambda_u2416_u24lambda_u2415;
            boolean $i$f$filter = false;
            void var21_22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Series it = (Series)element$iv$iv;
                boolean bl3 = false;
                if (!($this$exportReport_u24lambda_u2416_u24lambda_u2415.getId() == it.getReportId())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            var19_20.setSeries((List)destination$iv$iv2);
            collection.add(var15_16);
        }
        List reports = (List)destination$iv$iv;
        Iterable $this$forEach$iv = reports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Report it = (Report)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    public final void exportAutomationRunAsConfigSettings$jira_migration_plugin(@NotNull ExportContext ctx) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Long l = ctx.getProject().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            AutomationRunAsConfigSettings automationRunAsConfigSettings = this.automationRunAsConfigReader.getAutomationRunAsConfigSettings(((Number)l).longValue());
            if (automationRunAsConfigSettings == null) break block0;
            AutomationRunAsConfigSettings it = automationRunAsConfigSettings;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    @Override
    @Nullable
    public ServiceDesk extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/ServiceDeskExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

