/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.approval;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApprovalData;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApprovalReader;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApproverConfigurationData;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApproverDecisionData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.servicedesk.approval.Approval;
import com.atlassian.migration.jira.servicedesk.approval.ApprovalCondition;
import com.atlassian.migration.jira.servicedesk.approval.ApprovalDecision;
import com.atlassian.migration.jira.servicedesk.approval.Approver;
import com.atlassian.migration.jira.servicedesk.approval.ApproverConfigurationType;
import com.atlassian.migration.jira.servicedesk.approval.ApproverDecision;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 42\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u00014B/\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u001c\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010,\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J \u0010.\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u001bH\u0002J\u0010\u00100\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u0002H\u0016J\b\u00103\u001a\u00020\u001dH\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/approval/ApprovalExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalData;", "Lcom/atlassian/migration/jira/servicedesk/approval/Approval;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "statusManager", "Lcom/atlassian/jira/config/StatusManager;", "approvalReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalReader;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/config/StatusManager;Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalReader;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportSupportedFieldOrNull", "Lcom/atlassian/migration/base/mri/MRI;", "id", "", "exportUsersAndGroups", "", "getApproverConfigurations", "", "Lcom/atlassian/migration/jira/servicedesk/approval/Approver;", "getApproverDecisions", "Lcom/atlassian/migration/jira/servicedesk/approval/ApproverDecision;", "invalidApproverConfigurationTypeException", "Lcom/atlassian/jira/migration/export/framework/ExportException;", "entityMri", "customFieldId", "mapApprovalCondition", "Lcom/atlassian/migration/jira/servicedesk/approval/ApprovalCondition;", "approval", "mapApprovalDecision", "Lcom/atlassian/migration/jira/servicedesk/approval/ApprovalDecision;", "decision", "mapDecisionMakers", "mapUser", "userKey", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nApprovalExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApprovalExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/approval/ApprovalExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1549#2:183\n1620#2,3:184\n1549#2:187\n1620#2,3:188\n1549#2:191\n1620#2,3:192\n1#3:195\n*S KotlinDebug\n*F\n+ 1 ApprovalExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/approval/ApprovalExporter\n*L\n91#1:183\n91#1:184,3\n102#1:187\n102#1:188,3\n142#1:191\n142#1:192,3\n*E\n"})
public final class ApprovalExporter
implements Exporter<Long, ApprovalData, Approval> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final StatusManager statusManager;
    @NotNull
    private final ApprovalReader approvalReader;
    private static final Logger log = LoggerFactory.getLogger(ApprovalExporter.class);

    @Inject
    public ApprovalExporter(@NotNull ExportService exportService, @NotNull ExportFilters exportFilters, @NotNull IssueManager issueManager, @NotNull StatusManager statusManager, @NotNull ApprovalReader approvalReader) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)approvalReader, (String)"approvalReader");
        this.exportService = exportService;
        this.exportFilters = exportFilters;
        this.issueManager = issueManager;
        this.statusManager = statusManager;
        this.approvalReader = approvalReader;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ApprovalData.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(Approval.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Approval.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ApprovalData entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public Approval exportData(@NotNull ExportContext ctx, @NotNull ApprovalData entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI entityMri = this.mriForEntity(entity);
        MutableIssue issue2 = this.issueManager.getIssueObject(Long.valueOf(entity.getIssueId()));
        Status status = this.statusManager.getStatus(String.valueOf(entity.getStatusId()));
        MRI mRI = this.exportService.exportOrNull(ctx, issue2);
        if (mRI == null) {
            String string = "Approval with MRI - " + entityMri + " failed to export Issue with id - " + entity.getIssueId() + '.';
            String string2 = "Verify if Issue with id " + entity.getIssueId() + " is valid";
            ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_EXPORT_FAILED;
            throw new ExportException(entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
        }
        MRI mRI2 = this.exportService.exportOrNull(ctx, status);
        if (mRI2 == null) {
            String string = "Approval with MRI - " + entityMri + " has missing Issue status with id - " + entity.getStatusId() + '.';
            String string3 = "Verify if Issue status with id " + entity.getStatusId() + " is valid";
            ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
            throw new ExportException(entityMri, exportErrorCode, string, string3, null, null, null, 112, null);
        }
        return new Approval(entityMri, mRI, entity.getName(), mRI2, this.mapApprovalCondition(entity), entity.getSystemDecided(), entity.getCreatedDate(), entity.getCompletedDate(), this.mapApprovalDecision(entity, entity.getDecision()), this.getApproverConfigurations(ctx, entity), this.getApproverDecisions(ctx, entity), null, 2048, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ApprovalData entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), entity.getIssueId(), ctx.getMigrationId(), ctx.getExportMode()};
        log.debug("Exporting users and groups for approval data {} having issueId {} for migration {} under exportMode {}", objectArray);
        this.mapDecisionMakers(ctx, entity);
    }

    /*
     * WARNING - void declaration
     */
    private final void mapDecisionMakers(ExportContext ctx, ApprovalData entity) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.approvalReader.getApproverDecisionsForApproval(entity.getId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApproverDecisionData approverDecisionData = (ApproverDecisionData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapUser(ctx, entity, it.getUserKey()));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final ApprovalCondition mapApprovalCondition(ApprovalData approval) {
        return new ApprovalCondition(approval.getApproveConditionType(), approval.getApproveConditionValue());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Approver> getApproverConfigurations(ExportContext ctx, ApprovalData entity) {
        void $this$mapTo$iv$iv;
        List<ApproverConfigurationData> results2 = this.approvalReader.getApproverConfigurationsForApproval(entity.getId());
        Iterable $this$map$iv = results2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApproverConfigurationData approverConfigurationData = (ApproverConfigurationData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"custom_field")) {
                log.warn("Approval configuration type - " + it.getType() + " not supported");
                return CollectionsKt.emptyList();
            }
            ApproverConfigurationType configType = ApproverConfigurationType.custom_field;
            String customField = it.getValue();
            try {
                if (!StringsKt.startsWith$default((String)customField, (String)"customfield_", (boolean)false, (int)2, null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            catch (IllegalArgumentException ex) {
                log.error("Invalid approverConfigurationType. Must start with customfield_");
                throw this.invalidApproverConfigurationTypeException(this.mriForEntity(entity), customField);
            }
            collection.add(new Approver(configType, null, this.exportSupportedFieldOrNull(ctx, customField), 2, null));
        }
        return (List)destination$iv$iv;
    }

    private final MRI exportSupportedFieldOrNull(ExportContext ctx, String id) {
        return this.exportFilters.isSupportedFieldById(ctx, id) ? this.exportService.exportFieldOrNull(ctx, id) : null;
    }

    private final ExportException invalidApproverConfigurationTypeException(MRI entityMri, String customFieldId) {
        return new ExportException(entityMri, ExportErrorCode.JSD_APPROVAL_CONFIGURATION_TYPE_UNSUPPORTED, "Approver configuration type is invalid, fieldId should start with 'customfield_' but was: [" + customFieldId + ']', null, null, null, null, 120, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ApproverDecision> getApproverDecisions(ExportContext ctx, ApprovalData entity) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.approvalReader.getApproverDecisionsForApproval(entity.getId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApproverDecisionData approverDecisionData = (ApproverDecisionData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Instant instant = it.getSentDate();
            MRI mRI = this.mapUser(ctx, entity, it.getUserKey());
            ApprovalDecision approvalDecision = this.mapApprovalDecision(entity, it.getDecision());
            Intrinsics.checkNotNull((Object)approvalDecision);
            collection.add(new ApproverDecision(instant, mRI, approvalDecision));
        }
        return (List)destination$iv$iv;
    }

    private final ApprovalDecision mapApprovalDecision(ApprovalData entity, String decision) {
        ApprovalDecision approvalDecision;
        MRI entityMri = this.mriForEntity(entity);
        if (decision == null) {
            approvalDecision = null;
        } else {
            String string = decision;
            if (Intrinsics.areEqual((Object)string, (Object)"approved")) {
                approvalDecision = ApprovalDecision.approved;
            } else if (Intrinsics.areEqual((Object)string, (Object)"rejected")) {
                approvalDecision = ApprovalDecision.rejected;
            } else {
                String string2 = "Approval decision " + decision + " not supported";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_APPROVAL_DECISION_TYPE_UNSUPPORTED;
                throw new ExportException(entityMri, exportErrorCode, string2, null, null, null, null, 120, null);
            }
        }
        return approvalDecision;
    }

    private final MRI mapUser(ExportContext ctx, ApprovalData entity, String userKey) {
        MRI mRI;
        block3: {
            block2: {
                UserRef userRef = UserRef.Companion.fromString(userKey);
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
                if (mRI != null) break block3;
            }
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.JSD_USER_REFERENCE_ERROR, "Unable to get MRI for userkey '" + userKey + '\'', null, null, null, null, 120, null);
        }
        return mRI;
    }

    @Override
    @Nullable
    public ApprovalData extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ApprovalData entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/approval/ApprovalExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

