/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.approval;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApprovalData;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApprovalReader;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/approval/ApprovalService;", "", "approvalReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalReader;", "workflowManager", "Lcom/atlassian/jira/workflow/WorkflowManager;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "(Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalReader;Lcom/atlassian/jira/workflow/WorkflowManager;Lcom/atlassian/jira/issue/IssueManager;)V", "getApprovalsByIssueId", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/approval/ApprovalData;", "issueId", "", "getValidApprovals", "allApprovals", "isApprovalActiveForStatus", "", "step", "Lcom/opensymphony/workflow/loader/StepDescriptor;", "isValidApproval", "approval", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nApprovalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApprovalService.kt\ncom/atlassian/jira/migration/export/servicedesk/approval/ApprovalService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n766#2:43\n857#2,2:44\n*S KotlinDebug\n*F\n+ 1 ApprovalService.kt\ncom/atlassian/jira/migration/export/servicedesk/approval/ApprovalService\n*L\n27#1:43\n27#1:44,2\n*E\n"})
public final class ApprovalService {
    @NotNull
    private final ApprovalReader approvalReader;
    @NotNull
    private final WorkflowManager workflowManager;
    @NotNull
    private final IssueManager issueManager;

    @Inject
    public ApprovalService(@NotNull ApprovalReader approvalReader, @NotNull WorkflowManager workflowManager, @NotNull IssueManager issueManager) {
        Intrinsics.checkNotNullParameter((Object)approvalReader, (String)"approvalReader");
        Intrinsics.checkNotNullParameter((Object)workflowManager, (String)"workflowManager");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        this.approvalReader = approvalReader;
        this.workflowManager = workflowManager;
        this.issueManager = issueManager;
    }

    @NotNull
    public final Set<ApprovalData> getApprovalsByIssueId(long issueId) {
        Set<ApprovalData> allApprovals = this.approvalReader.getAllApprovalsByIssueId(issueId);
        return allApprovals.isEmpty() ? allApprovals : this.getValidApprovals(issueId, allApprovals);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ApprovalData> getValidApprovals(long issueId, Set<ApprovalData> allApprovals) {
        void $this$filterTo$iv$iv;
        MutableIssue issue2 = this.issueManager.getIssueObject(Long.valueOf(issueId));
        JiraWorkflow jiraWorkflow = this.workflowManager.getWorkflow((Issue)issue2);
        StepDescriptor step = jiraWorkflow != null ? jiraWorkflow.getLinkedStep(issue2.getStatus()) : null;
        boolean isApprovalActiveForStatus = this.isApprovalActiveForStatus(step);
        Iterable $this$filter$iv = allApprovals;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApprovalData it = (ApprovalData)element$iv$iv;
            boolean bl = false;
            if (!this.isValidApproval(it, isApprovalActiveForStatus)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final boolean isValidApproval(ApprovalData approval, boolean isApprovalActiveForStatus) {
        return approval.getDecision() != null || isApprovalActiveForStatus;
    }

    private final boolean isApprovalActiveForStatus(StepDescriptor step) {
        Object object = step;
        return Boolean.parseBoolean(object != null && (object = object.getMetaAttributes()) != null ? object.get("approval.active") : null);
    }
}

