/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.automation;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.automation.IfThenRequestDetails;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleComponentRequestDetails;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleRequestDetails;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleSetDetails;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.automation.ConfigurationDataSanitizer;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.servicedesk.automation.AutomationRules;
import com.atlassian.migration.jira.servicedesk.automation.IfRequest;
import com.atlassian.migration.jira.servicedesk.automation.IfThenRequest;
import com.atlassian.migration.jira.servicedesk.automation.MetadataRequest;
import com.atlassian.migration.jira.servicedesk.automation.ProjectContextRequest;
import com.atlassian.migration.jira.servicedesk.automation.RuleComponentRequest;
import com.atlassian.migration.jira.servicedesk.automation.RuleRequest;
import com.atlassian.migration.jira.servicedesk.automation.RuleSetRequest;
import com.atlassian.migration.jira.servicedesk.automation.RunAsUserContextConfigRequest;
import com.atlassian.migration.jira.servicedesk.automation.ThenRequest;
import com.atlassian.migration.jira.servicedesk.automation.UserContextConfigRequest;
import com.atlassian.migration.jira.servicedesk.automation.WhenRequest;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J \u0010'\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010-\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020\u0002H\u0016J\b\u00100\u001a\u00020\u0016H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/AutomationExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/automation/RuleSetDetails;", "Lcom/atlassian/migration/jira/servicedesk/automation/AutomationRules;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "configurationDataSanitizer", "Lcom/atlassian/jira/migration/export/servicedesk/automation/ConfigurationDataSanitizer;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/servicedesk/automation/ConfigurationDataSanitizer;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapIfThenRequests", "", "Lcom/atlassian/migration/jira/servicedesk/automation/IfThenRequest;", "Lcom/atlassian/jira/migration/export/db/servicedesk/automation/RuleRequestDetails;", "mapMetadataRequest", "Lcom/atlassian/migration/jira/servicedesk/automation/MetadataRequest;", "mapRuleComponentRequests", "Lcom/atlassian/migration/jira/servicedesk/automation/RuleComponentRequest;", "entities", "Lcom/atlassian/jira/migration/export/db/servicedesk/automation/RuleComponentRequestDetails;", "mapRuleRequests", "Lcom/atlassian/migration/jira/servicedesk/automation/RuleRequest;", "mapRuleSetRequest", "Lcom/atlassian/migration/jira/servicedesk/automation/RuleSetRequest;", "mapRunAsUserContextRequest", "Lcom/atlassian/migration/jira/servicedesk/automation/RunAsUserContextConfigRequest;", "mapUser", "Lcom/atlassian/migration/base/mri/MRI;", "userKey", "", "mapUserContextConfigRequest", "Lcom/atlassian/migration/jira/servicedesk/automation/UserContextConfigRequest;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAutomationExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomationExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/AutomationExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1#2:153\n1549#3:154\n1620#3,3:155\n1549#3:158\n1620#3,3:159\n1549#3:162\n1620#3,3:163\n*S KotlinDebug\n*F\n+ 1 AutomationExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/AutomationExporter\n*L\n85#1:154\n85#1:155,3\n126#1:158\n126#1:159,3\n135#1:162\n135#1:163,3\n*E\n"})
public final class AutomationExporter
implements Exporter<Long, RuleSetDetails, AutomationRules> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ConfigurationDataSanitizer configurationDataSanitizer;
    private final Logger log;

    @Inject
    public AutomationExporter(@NotNull ExportService exportService, @NotNull ConfigurationDataSanitizer configurationDataSanitizer) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)configurationDataSanitizer, (String)"configurationDataSanitizer");
        this.exportService = exportService;
        this.configurationDataSanitizer = configurationDataSanitizer;
        this.log = LoggerFactory.getLogger(AutomationExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, RuleSetDetails.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(AutomationRules.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(AutomationRules.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull RuleSetDetails entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public AutomationRules exportData(@NotNull ExportContext ctx, @NotNull RuleSetDetails entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return new AutomationRules(this.mriForEntity(entity), this.mapRuleSetRequest(ctx, entity), entity.getSystemRuleSet(), this.mapUser(ctx, entity, entity.getCreatedBy()), entity.getCreatedAt());
    }

    private final MRI mapUser(ExportContext ctx, RuleSetDetails entity, String userKey) {
        MRI mRI;
        block3: {
            block2: {
                UserRef userRef = UserRef.Companion.fromString(userKey);
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
                if (mRI != null) break block3;
            }
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.JSD_USER_REFERENCE_ERROR, "Unable to get MRI for userkey '" + userKey + '\'', null, null, null, null, 120, null);
        }
        return mRI;
    }

    private final RuleSetRequest mapRuleSetRequest(ExportContext ctx, RuleSetDetails entity) {
        return new RuleSetRequest(this.mapRuleRequests(ctx, entity), this.mapMetadataRequest(ctx, entity), entity.getName(), entity.getDescription());
    }

    /*
     * WARNING - void declaration
     */
    private final List<RuleRequest> mapRuleRequests(ExportContext ctx, RuleSetDetails entity) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entity.getRuleRequests();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RuleRequestDetails ruleRequestDetails = (RuleRequestDetails)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RuleRequest(new WhenRequest(this.mapRuleComponentRequests(ctx, it.getWhenRequests())), this.mapIfThenRequests(ctx, (RuleRequestDetails)it), Boolean.valueOf(it.getEnabled())));
        }
        return (List)destination$iv$iv;
    }

    private final MetadataRequest mapMetadataRequest(ExportContext ctx, RuleSetDetails entity) {
        MRI entityMri = this.mriForEntity(entity);
        return new MetadataRequest(this.mapRunAsUserContextRequest(ctx, entity), new ProjectContextRequest(this.exportService.checkExportedOrThrow(ctx, ctx.getProject(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, ctx){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entityMri = $entityMri;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "Automation Rule with MRI - " + this.$entityMri + " has missing Project with MRI - " + mri + '.';
                String string2 = "Verify if Project with id " + this.$ctx.getProject().getId() + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        }))), entity.getTriggerFrmOtrRules());
    }

    private final RunAsUserContextConfigRequest mapRunAsUserContextRequest(ExportContext ctx, RuleSetDetails entity) {
        String string = entity.getRunAsUsrCtxType();
        if (string == null) {
            return null;
        }
        String userContextType = string;
        return new RunAsUserContextConfigRequest(userContextType, this.mapUserContextConfigRequest(ctx, entity));
    }

    private final UserContextConfigRequest mapUserContextConfigRequest(ExportContext ctx, RuleSetDetails entity) {
        String string = entity.getRunAsUsrCtxUsrKey();
        if (string == null) {
            return null;
        }
        String userKey = string;
        return new UserContextConfigRequest(this.mapUser(ctx, entity, userKey));
    }

    /*
     * WARNING - void declaration
     */
    private final List<RuleComponentRequest> mapRuleComponentRequests(ExportContext ctx, List<RuleComponentRequestDetails> entities) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RuleComponentRequestDetails ruleComponentRequestDetails = (RuleComponentRequestDetails)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ImmutableMap<String, String> immutableMap = it.getConfigData();
            collection.add(new RuleComponentRequest(it.getModuleKey(), this.configurationDataSanitizer.sanitiseConfigMap(ctx, it.getModuleKey(), immutableMap != null ? (Map)immutableMap : MapsKt.emptyMap())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IfThenRequest> mapIfThenRequests(ExportContext ctx, RuleRequestDetails entity) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entity.getIfThenRequests();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IfThenRequestDetails ifThenRequestDetails = (IfThenRequestDetails)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IfThenRequest(new IfRequest(this.mapRuleComponentRequests(ctx, it.getIfConditions())), new ThenRequest(this.mapRuleComponentRequests(ctx, it.getThenConditions()))));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull RuleSetDetails entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), entity.getProjectId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for ruleSetDetails with id {} for project {} under migrationId {} under exportMode {}", objectArray);
        this.mapUser(ctx, entity, entity.getCreatedBy());
        this.mapRunAsUserContextRequest(ctx, entity);
        this.mapRuleRequests(ctx, entity);
    }

    @Override
    @Nullable
    public RuleSetDetails extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull RuleSetDetails entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

