/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.automation;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.automation.AutomationRunAsConfigSettings;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.migration.jira.servicedesk.automation.AutomationRunAsConfig;
import com.atlassian.migration.jira.servicedesk.automation.RunAsUserContextConfigRequest;
import com.atlassian.migration.jira.servicedesk.automation.UserContextConfigRequest;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/AutomationRunAsConfigExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/automation/AutomationRunAsConfigSettings;", "Lcom/atlassian/migration/jira/servicedesk/automation/AutomationRunAsConfig;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapUser", "Lcom/atlassian/migration/base/mri/MRI;", "userKey", "", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAutomationRunAsConfigExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomationRunAsConfigExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/AutomationRunAsConfigExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class AutomationRunAsConfigExporter
implements Exporter<Long, AutomationRunAsConfigSettings, AutomationRunAsConfig> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;

    @Inject
    public AutomationRunAsConfigExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(AutomationRunAsConfigExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, AutomationRunAsConfigSettings.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(AutomationRunAsConfig.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(AutomationRunAsConfig.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull AutomationRunAsConfigSettings entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public AutomationRunAsConfig exportData(@NotNull ExportContext ctx, @NotNull AutomationRunAsConfigSettings entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI entityMri = this.mriForEntity(entity);
        return new AutomationRunAsConfig(entityMri, this.exportService.checkExportedOrThrow(ctx, Project.Companion.getEntityType(), entity.getProjectId(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, ctx){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entityMri = $entityMri;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "AutomationRunAsConfig with MRI - " + this.$entityMri + " has missing Project with MRI - " + mri + '.';
                String string2 = "Verify if Project with id " + this.$ctx.getProject().getId() + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        })), new RunAsUserContextConfigRequest(entity.getRunAsUsrCtxType(), new UserContextConfigRequest(this.mapUser(ctx, entity, entity.getRunAsUsrCtxUsrKey()))));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull AutomationRunAsConfigSettings entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), entity.getProjectId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for automationRunAsConfigSettings {} for project {} for migration {} under exportMode {}", objectArray);
        this.mapUser(ctx, entity, entity.getRunAsUsrCtxUsrKey());
    }

    private final MRI mapUser(ExportContext ctx, AutomationRunAsConfigSettings entity, String userKey) {
        UserRef userRef;
        block3: {
            block2: {
                userRef = UserRef.Companion.fromString(userKey);
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                MRI mRI = this.exportService.userRef(ctx, it);
                userRef = mRI;
                if (mRI != null) break block3;
            }
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.JSD_USER_REFERENCE_ERROR, "Unable to get MRI for userkey '" + userKey + '\'', null, null, null, null, 120, null);
        }
        return userRef;
    }

    @Override
    @Nullable
    public AutomationRunAsConfigSettings extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull AutomationRunAsConfigSettings entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

