/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.automation;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleSetDetails;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleSetReader;
import com.atlassian.jira.migration.export.servicedesk.automation.UnsupportedAutomationRuleVerifier;
import com.atlassian.jira.migration.export.servicedesk.automation.filters.CloudIncompatibleFilter;
import com.atlassian.jira.migration.export.servicedesk.automation.filters.IfConditionInvalidEntityReferenceFilter;
import com.atlassian.jira.migration.export.servicedesk.automation.filters.NotImplementedFilter;
import com.atlassian.jira.migration.export.servicedesk.automation.filters.RuleSetFilter;
import com.atlassian.jira.migration.export.servicedesk.automation.filters.ThenConditionInvalidEntityReferenceFilter;
import com.atlassian.jira.migration.export.servicedesk.automation.filters.WhenConditionInvalidReferenceFilter;
import com.atlassian.jira.project.ProjectManager;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/AutomationServiceFacade;", "", "ruleSetReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/automation/RuleSetReader;", "unsupportedAutomationRuleVerifier", "Lcom/atlassian/jira/migration/export/servicedesk/automation/UnsupportedAutomationRuleVerifier;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "thenConditionInvalidEntityReferenceFilter", "Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/ThenConditionInvalidEntityReferenceFilter;", "whenConditionInvalidReferenceFilter", "Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/WhenConditionInvalidReferenceFilter;", "ifConditionInvalidEntityReferenceFilter", "Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/IfConditionInvalidEntityReferenceFilter;", "(Lcom/atlassian/jira/migration/export/db/servicedesk/automation/RuleSetReader;Lcom/atlassian/jira/migration/export/servicedesk/automation/UnsupportedAutomationRuleVerifier;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/ThenConditionInvalidEntityReferenceFilter;Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/WhenConditionInvalidReferenceFilter;Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/IfConditionInvalidEntityReferenceFilter;)V", "ruleSetFilters", "", "Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/RuleSetFilter;", "getAllActiveRSetIdsByProject", "Lkotlin/sequences/Sequence;", "", "projectId", "limitPerPage", "", "getAllRuleSetDetails", "Lcom/atlassian/jira/migration/export/db/servicedesk/automation/RuleSetDetails;", "getRuleSetCountByProjectKey", "projectKey", "", "getRuleSetDetails", "ruleSetId", "jira-migration-plugin"})
public final class AutomationServiceFacade {
    @NotNull
    private final RuleSetReader ruleSetReader;
    @NotNull
    private final UnsupportedAutomationRuleVerifier unsupportedAutomationRuleVerifier;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final List<RuleSetFilter> ruleSetFilters;

    @Inject
    public AutomationServiceFacade(@NotNull RuleSetReader ruleSetReader, @NotNull UnsupportedAutomationRuleVerifier unsupportedAutomationRuleVerifier, @NotNull ProjectManager projectManager, @NotNull ThenConditionInvalidEntityReferenceFilter thenConditionInvalidEntityReferenceFilter, @NotNull WhenConditionInvalidReferenceFilter whenConditionInvalidReferenceFilter, @NotNull IfConditionInvalidEntityReferenceFilter ifConditionInvalidEntityReferenceFilter) {
        Intrinsics.checkNotNullParameter((Object)ruleSetReader, (String)"ruleSetReader");
        Intrinsics.checkNotNullParameter((Object)unsupportedAutomationRuleVerifier, (String)"unsupportedAutomationRuleVerifier");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)thenConditionInvalidEntityReferenceFilter, (String)"thenConditionInvalidEntityReferenceFilter");
        Intrinsics.checkNotNullParameter((Object)whenConditionInvalidReferenceFilter, (String)"whenConditionInvalidReferenceFilter");
        Intrinsics.checkNotNullParameter((Object)ifConditionInvalidEntityReferenceFilter, (String)"ifConditionInvalidEntityReferenceFilter");
        this.ruleSetReader = ruleSetReader;
        this.unsupportedAutomationRuleVerifier = unsupportedAutomationRuleVerifier;
        this.projectManager = projectManager;
        Object[] objectArray = new RuleSetFilter[]{new CloudIncompatibleFilter(), new NotImplementedFilter(), thenConditionInvalidEntityReferenceFilter, whenConditionInvalidReferenceFilter, ifConditionInvalidEntityReferenceFilter};
        this.ruleSetFilters = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<RuleSetDetails> getAllRuleSetDetails(long projectId) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)AutomationServiceFacade.getAllActiveRSetIdsByProject$default(this, projectId, 0, 2, null), (Function1)((Function1)new Function1<Long, RuleSetDetails>(this){
            final /* synthetic */ AutomationServiceFacade this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final RuleSetDetails invoke(long it) {
                return this.this$0.getRuleSetDetails(it);
            }
        })), (Function1)((Function1)new Function1<RuleSetDetails, Boolean>(this){
            final /* synthetic */ AutomationServiceFacade this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RuleSetDetails ruleSetDetails) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)ruleSetDetails, (String)"ruleSetDetails");
                    Iterable $this$all$iv = AutomationServiceFacade.access$getRuleSetFilters$p(this.this$0);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            RuleSetFilter filter = (RuleSetFilter)element$iv;
                            boolean bl2 = false;
                            if (filter.toExport(ruleSetDetails)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        })), (Function1)((Function1)new Function1<RuleSetDetails, Boolean>(this){
            final /* synthetic */ AutomationServiceFacade this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RuleSetDetails ruleSetDetails) {
                Intrinsics.checkNotNullParameter((Object)ruleSetDetails, (String)"ruleSetDetails");
                return AutomationServiceFacade.access$getUnsupportedAutomationRuleVerifier$p(this.this$0).shouldExport(ruleSetDetails);
            }
        })));
    }

    public final int getRuleSetCountByProjectKey(@NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Long projectId = this.projectManager.getProjectObjByKey(projectKey).getId();
        Intrinsics.checkNotNull((Object)projectId);
        return ((Collection)this.getAllRuleSetDetails(projectId)).size();
    }

    @NotNull
    public final Sequence<Long> getAllActiveRSetIdsByProject(long projectId, int limitPerPage) {
        return this.ruleSetReader.getAllActiveRSetIdsByProject(projectId, limitPerPage);
    }

    public static /* synthetic */ Sequence getAllActiveRSetIdsByProject$default(AutomationServiceFacade automationServiceFacade, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        return automationServiceFacade.getAllActiveRSetIdsByProject(l, n);
    }

    @NotNull
    public final RuleSetDetails getRuleSetDetails(long ruleSetId) {
        return this.ruleSetReader.getRuleSetDetails(ruleSetId);
    }

    public static final /* synthetic */ List access$getRuleSetFilters$p(AutomationServiceFacade $this) {
        return $this.ruleSetFilters;
    }

    public static final /* synthetic */ UnsupportedAutomationRuleVerifier access$getUnsupportedAutomationRuleVerifier$p(AutomationServiceFacade $this) {
        return $this.unsupportedAutomationRuleVerifier;
    }
}

