/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.automation.configurationdata;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.automation.configurationdata.AutomationConfigModule;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.migration.jira.servicedesk.automation.ParameterValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0016J0\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/configurationdata/SendNotificationAction;", "Lcom/atlassian/jira/migration/export/servicedesk/automation/configurationdata/AutomationConfigModule;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "keysOfDataValue", "", "", "fallbackToCurrentProjectMRI", "Lcom/atlassian/migration/base/mri/MRI;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "moduleKey", "sanitizeConfig", "", "Lcom/atlassian/migration/jira/servicedesk/automation/ParameterValue;", "configData", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSendNotificationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendNotificationAction.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/configurationdata/SendNotificationAction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n135#2,9:61\n215#2:70\n216#2:72\n144#2:73\n1#3:71\n*S KotlinDebug\n*F\n+ 1 SendNotificationAction.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/configurationdata/SendNotificationAction\n*L\n25#1:61,9\n25#1:70\n25#1:72\n25#1:73\n25#1:71\n*E\n"})
public final class SendNotificationAction
implements AutomationConfigModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final Set<String> keysOfDataValue;
    @NotNull
    public static final String projectid = "projectid";
    @NotNull
    public static final String lingo = "lingo";
    private static final Logger log = LoggerFactory.getLogger(SendNotificationAction.class);

    @Inject
    public SendNotificationAction(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        Object[] objectArray = new String[]{"recipients", "content", "excludeinitiator", "isdefaultrule"};
        this.keysOfDataValue = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String moduleKey() {
        return "com.atlassian.servicedesk.servicedesk-notifications-plugin:servicedesk-send-notification-action";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, ParameterValue> sanitizeConfig(@NotNull ExportContext ctx, @NotNull Map<String, String> configData) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(configData, (String)"configData");
        Map<String, String> $this$mapNotNull$iv = configData;
        boolean $i$f$mapNotNull = false;
        Map<String, String> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String configKey = (String)entry.getKey();
            String configValue = (String)entry.getValue();
            String string = configKey;
            if (Intrinsics.areEqual((Object)string, (Object)projectid)) {
                MRI mRI = this.exportService.getExportedOrNull(ctx, Project.Companion.getEntityType(), Long.parseLong(configValue));
                if (mRI == null) {
                    mRI = this.fallbackToCurrentProjectMRI(ctx);
                }
                MRI projectId = mRI;
                pair = TuplesKt.to((Object)configKey, (Object)new ParameterValue.Reference(projectId));
            } else if (this.keysOfDataValue.contains(string)) {
                pair = TuplesKt.to((Object)configKey, (Object)new ParameterValue.Data(configValue));
            } else if (Intrinsics.areEqual((Object)string, (Object)lingo)) {
                pair = null;
            } else {
                log.warn("Found unknown configuration-data-key: " + configKey + " for: " + this.moduleKey());
                pair = TuplesKt.to((Object)configKey, (Object)new ParameterValue.Data(configValue));
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final MRI fallbackToCurrentProjectMRI(ExportContext ctx) {
        log.warn("Automation rule config contains invalid project id, trying fallback to the current project id");
        return this.exportService.checkExportedOrThrow(ctx, Project.Companion.getEntityType(), ctx.getProject().getId(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(ctx){
            final /* synthetic */ ExportContext $ctx;
            {
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "Automation Rule has missing Project with MRI - " + mri + '.';
                String string2 = "Verify if configuration contains valid project id " + this.$ctx.getProject().getId();
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(mri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/configurationdata/SendNotificationAction$Companion;", "", "()V", "lingo", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "projectid", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

