/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.automation.filters;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.automation.IfThenRequestDetails;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleComponentRequestDetails;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleRequestDetails;
import com.atlassian.jira.migration.export.db.servicedesk.automation.RuleSetDetails;
import com.atlassian.jira.migration.export.servicedesk.automation.configurationdata.SdCommentActionKt;
import com.atlassian.jira.migration.export.servicedesk.automation.filters.RuleSetFilter;
import com.atlassian.jira.migration.export.servicedesk.automation.validators.RequestTypeValidator;
import com.atlassian.jira.migration.export.servicedesk.automation.validators.WebhookUrlValidator;
import com.atlassian.jira.migration.export.servicedesk.automation.validators.WorkFlowActionValidator;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/ThenConditionInvalidEntityReferenceFilter;", "Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/RuleSetFilter;", "workFlowActionValidator", "Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/WorkFlowActionValidator;", "requestTypeValidator", "Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/RequestTypeValidator;", "webhookUrlValidator", "Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/WebhookUrlValidator;", "(Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/WorkFlowActionValidator;Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/RequestTypeValidator;Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/WebhookUrlValidator;)V", "toExport", "", "ruleSetDetails", "Lcom/atlassian/jira/migration/export/db/servicedesk/automation/RuleSetDetails;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nThenConditionInvalidEntityReferenceFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThenConditionInvalidEntityReferenceFilter.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/filters/ThenConditionInvalidEntityReferenceFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1360#2:67\n1446#2,5:68\n1360#2:73\n1446#2,5:74\n1855#2:79\n1855#2,2:80\n1856#2:82\n*S KotlinDebug\n*F\n+ 1 ThenConditionInvalidEntityReferenceFilter.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/filters/ThenConditionInvalidEntityReferenceFilter\n*L\n24#1:67\n24#1:68,5\n25#1:73\n25#1:74,5\n26#1:79\n27#1:80,2\n26#1:82\n*E\n"})
public final class ThenConditionInvalidEntityReferenceFilter
implements RuleSetFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkFlowActionValidator workFlowActionValidator;
    @NotNull
    private final RequestTypeValidator requestTypeValidator;
    @NotNull
    private final WebhookUrlValidator webhookUrlValidator;
    private static final Logger log = LoggerFactory.getLogger(ThenConditionInvalidEntityReferenceFilter.class);

    @Inject
    public ThenConditionInvalidEntityReferenceFilter(@NotNull WorkFlowActionValidator workFlowActionValidator, @NotNull RequestTypeValidator requestTypeValidator, @NotNull WebhookUrlValidator webhookUrlValidator) {
        Intrinsics.checkNotNullParameter((Object)workFlowActionValidator, (String)"workFlowActionValidator");
        Intrinsics.checkNotNullParameter((Object)requestTypeValidator, (String)"requestTypeValidator");
        Intrinsics.checkNotNullParameter((Object)webhookUrlValidator, (String)"webhookUrlValidator");
        this.workFlowActionValidator = workFlowActionValidator;
        this.requestTypeValidator = requestTypeValidator;
        this.webhookUrlValidator = webhookUrlValidator;
    }

    @Override
    public boolean toExport(@NotNull RuleSetDetails ruleSetDetails) {
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ruleSetDetails, (String)"ruleSetDetails");
        Iterable $this$flatMap$iv = ruleSetDetails.getRuleRequests();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (RuleRequestDetails)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((RuleRequestDetails)it).getIfThenRequests();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IfThenRequestDetails)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((IfThenRequestDetails)it).getThenConditions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ImmutableSet immutableSet;
            RuleComponentRequestDetails thenCondition = (RuleComponentRequestDetails)element$iv;
            boolean bl = false;
            ImmutableSet immutableSet2 = thenCondition.getConfigData();
            if (immutableSet2 == null || (immutableSet2 = (immutableSet = (ImmutableSet)immutableSet2.keySet())) == null) continue;
            Intrinsics.checkNotNull((Object)immutableSet2);
            Iterable $this$forEach$iv2 = (Iterable)immutableSet;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String warningText;
                boolean isValid;
                block23: {
                    String it2 = (String)element$iv2;
                    boolean bl2 = false;
                    String configDataObj = (String)thenCondition.getConfigData().get((Object)it2);
                    isValid = true;
                    warningText = "Skip Export - Automation rule with ID " + ruleSetDetails.getId() + ". ";
                    String string = it2;
                    if (string == null) break block23;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1150097001: {
                            if (string.equals("requestType")) {
                                n = 1;
                            }
                            break;
                        }
                        case 2103552569: {
                            if (string.equals("commentType")) {
                                n = 2;
                            }
                            break;
                        }
                        case 950398559: {
                            if (string.equals("comment")) {
                                n = 3;
                            }
                            break;
                        }
                        case 167327445: {
                            if (string.equals("workflowAction")) {
                                n = 4;
                            }
                            break;
                        }
                        case 116079: {
                            if (string.equals("url")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 4: {
                            isValid = this.workFlowActionValidator.validateWorkFlowAction(ruleSetDetails.getProjectId(), configDataObj);
                            warningText = warningText + "Reason - module key " + thenCondition.getModuleKey() + " has reference to invalid WorkFlowAction - " + configDataObj + '.';
                            break;
                        }
                        case 1: {
                            isValid = this.requestTypeValidator.validateRequestType(ruleSetDetails.getProjectId(), configDataObj);
                            warningText = warningText + "Reason - module key " + thenCondition.getModuleKey() + " has reference to invalid RequestType with id - " + configDataObj + '.';
                            break;
                        }
                        case 5: {
                            isValid = this.webhookUrlValidator.validateUrl(configDataObj);
                            warningText = warningText + "Reason - module key " + thenCondition.getModuleKey() + " has reference to invalid URL.";
                            break;
                        }
                        case 2: {
                            isValid = CollectionsKt.contains((Iterable)SdCommentActionKt.getVALID_COMMENT_TYPES(), (Object)configDataObj);
                            warningText = warningText + "Reason - module key " + thenCondition.getModuleKey() + " has invalid comment type";
                            break;
                        }
                        case 3: {
                            String string2 = configDataObj;
                            Intrinsics.checkNotNull((Object)string2);
                            isValid = !StringsKt.isBlank((CharSequence)string2);
                            warningText = warningText + "Reason - module key " + thenCondition.getModuleKey() + " has invalid comment";
                        }
                    }
                }
                if (isValid) continue;
                log.warn(warningText);
                return false;
            }
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/filters/ThenConditionInvalidEntityReferenceFilter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

