/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.automation.validators;

import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.jiraservice.JiraSearchService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.query.Query;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/JqlQueryValidator;", "", "jiraSearchService", "Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;", "jqlQueryParser", "Lcom/atlassian/jira/jql/parser/JqlQueryParser;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "(Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;Lcom/atlassian/jira/jql/parser/JqlQueryParser;Lcom/atlassian/jira/user/util/UserManager;)V", "validateJqlQuery", "", "userKey", "", "jql", "jira-migration-plugin"})
public final class JqlQueryValidator {
    @NotNull
    private final JiraSearchService jiraSearchService;
    @NotNull
    private final JqlQueryParser jqlQueryParser;
    @NotNull
    private final UserManager userManager;

    @Inject
    public JqlQueryValidator(@NotNull JiraSearchService jiraSearchService, @NotNull JqlQueryParser jqlQueryParser, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter((Object)jiraSearchService, (String)"jiraSearchService");
        Intrinsics.checkNotNullParameter((Object)jqlQueryParser, (String)"jqlQueryParser");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        this.jiraSearchService = jiraSearchService;
        this.jqlQueryParser = jqlQueryParser;
        this.userManager = userManager;
    }

    public final boolean validateJqlQuery(@NotNull String userKey, @NotNull String jql) {
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Intrinsics.checkNotNullParameter((Object)jql, (String)"jql");
        Query jqlQuery = null;
        ApplicationUser applicationUser = this.userManager.getUserByKey(userKey);
        if (applicationUser == null) {
            return true;
        }
        ApplicationUser user = applicationUser;
        try {
            Query query = this.jqlQueryParser.parseQuery(jql);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"parseQuery(...)");
            jqlQuery = query;
        }
        catch (JqlParseException e) {
            return false;
        }
        return this.jiraSearchService.validateJqlQuery(user, jqlQuery);
    }
}

