/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.automation.validators;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Locale;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/WebhookUrlValidator;", "", "()V", "isPortValid", "", "uri", "Ljava/net/URI;", "isProtocolValid", "validateUrl", "url", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nWebhookUrlValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookUrlValidator.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/validators/WebhookUrlValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class WebhookUrlValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final ImmutableList<String> ALLOWED_SCHEMES = ImmutableList.of((Object)"HTTP", (Object)"HTTPS");
    private static final ImmutableMap<String, Integer> ALLOWED_CLOUD_SCHEMES = ImmutableMap.of((Object)"HTTP", (Object)80, (Object)"HTTPS", (Object)443);

    public final boolean validateUrl(@Nullable String url) {
        URI uRI;
        String string = url;
        if (string != null) {
            String it = string;
            boolean bl = false;
            uRI = URI.create(url);
        } else {
            uRI = null;
        }
        if (uRI == null) {
            return false;
        }
        URI uri = uRI;
        return this.isProtocolValid(uri) && this.isPortValid(uri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProtocolValid(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) return false;
        String string = scheme;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (!ALLOWED_SCHEMES.contains((Object)string2)) return false;
        return true;
    }

    private final boolean isPortValid(URI uri) {
        int port;
        String uriScheme = uri.getScheme() != null ? uri.getScheme() : "";
        Intrinsics.checkNotNull((Object)uriScheme);
        String string = uriScheme;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        Integer portForScheme = (Integer)ALLOWED_CLOUD_SCHEMES.get((Object)string2);
        Integer n = portForScheme;
        return n != null && (port = uri.getPort()) == n || port == -1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/WebhookUrlValidator$Companion;", "", "()V", "ALLOWED_CLOUD_SCHEMES", "Lcom/google/common/collect/ImmutableMap;", "", "kotlin.jvm.PlatformType", "", "ALLOWED_SCHEMES", "Lcom/google/common/collect/ImmutableList;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

