/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.automation.validators;

import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u000eH\u0002J\u0014\u0010\u0017\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/automation/validators/WorkFlowActionValidator;", "", "workFlowSchemeManager", "Lcom/atlassian/jira/workflow/WorkflowSchemeManager;", "workflowManager", "Lcom/atlassian/jira/workflow/WorkflowManager;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/workflow/WorkflowSchemeManager;Lcom/atlassian/jira/workflow/WorkflowManager;Lcom/atlassian/jira/project/ProjectManager;)V", "hasValidToStep", "", "action", "Lcom/opensymphony/workflow/loader/ActionDescriptor;", "workflow", "Lcom/atlassian/jira/workflow/JiraWorkflow;", "validateWorkFlowAction", "projectId", "", "workFlowAction", "", "getAllValidSteps", "", "Lcom/opensymphony/workflow/loader/StepDescriptor;", "isValidStep", "stepId", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nWorkFlowActionValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkFlowActionValidator.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/validators/WorkFlowActionValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1549#2:51\n1620#2,3:52\n1549#2:55\n1620#2,2:56\n766#2:58\n857#2,2:59\n1622#2:61\n1360#2:62\n1446#2,5:63\n1549#2:68\n1620#2,3:69\n1747#2,3:73\n1603#2,9:76\n1855#2:85\n1856#2:87\n1612#2:88\n1655#2,8:89\n1#3:72\n1#3:86\n*S KotlinDebug\n*F\n+ 1 WorkFlowActionValidator.kt\ncom/atlassian/jira/migration/export/servicedesk/automation/validators/WorkFlowActionValidator\n*L\n25#1:51\n25#1:52,3\n26#1:55\n26#1:56,2\n28#1:58\n28#1:59,2\n26#1:61\n30#1:62\n30#1:63,5\n31#1:68\n31#1:69,3\n43#1:73,3\n47#1:76,9\n47#1:85\n47#1:87\n47#1:88\n48#1:89,8\n47#1:86\n*E\n"})
public final class WorkFlowActionValidator {
    @NotNull
    private final WorkflowSchemeManager workFlowSchemeManager;
    @NotNull
    private final WorkflowManager workflowManager;
    @NotNull
    private final ProjectManager projectManager;

    @Inject
    public WorkFlowActionValidator(@NotNull WorkflowSchemeManager workFlowSchemeManager, @NotNull WorkflowManager workflowManager, @NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)workFlowSchemeManager, (String)"workFlowSchemeManager");
        Intrinsics.checkNotNullParameter((Object)workflowManager, (String)"workflowManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.workFlowSchemeManager = workFlowSchemeManager;
        this.workflowManager = workflowManager;
        this.projectManager = projectManager;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean validateWorkFlowAction(long projectId, @Nullable String workFlowAction) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
        Collection workflowNames = this.workFlowSchemeManager.getWorkflowMap(project).values();
        Iterable iterable = workflowNames;
        boolean $i$f$map = false;
        void var9_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.workflowManager.getWorkflow((String)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            it = (JiraWorkflow)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JiraWorkflow jiraWorkflow = it;
            Collection collection2 = it.getAllActions();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getAllActions(...)");
            Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)collection2);
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ActionDescriptor it2 = (ActionDescriptor)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)jiraWorkflow);
                if (!this.hasValidToStep(it2, jiraWorkflow)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            collection.add((List)destination$iv$iv2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = CollectionsKt.toList((Iterable)((Iterable)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ActionDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set workFlowActionNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return workFlowActionNames.contains(workFlowAction);
    }

    private final boolean hasValidToStep(ActionDescriptor action, JiraWorkflow workflow) {
        boolean bl;
        ResultDescriptor resultDescriptor = action.getUnconditionalResult();
        if (resultDescriptor != null) {
            ResultDescriptor it = resultDescriptor;
            boolean bl2 = false;
            bl = this.isValidStep(workflow, it.getStep());
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isValidStep(JiraWorkflow $this$isValidStep, int stepId) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getAllValidSteps($this$isValidStep);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StepDescriptor it = (StepDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!(it.getId() == stepId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StepDescriptor> getAllValidSteps(JiraWorkflow $this$getAllValidSteps) {
        void $this$mapNotNullTo$iv$iv;
        List list = $this$getAllValidSteps.getLinkedStatusObjects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLinkedStatusObjects(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            StepDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Status p0 = (Status)element$iv$iv;
            boolean bl2 = false;
            if ($this$getAllValidSteps.getLinkedStep(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            StepDescriptor it = (StepDescriptor)e$iv;
            boolean bl = false;
            Integer key$iv = it.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }
}

