/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.calendar;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.calendar.CalendarReader;
import com.atlassian.jira.migration.db.servicedesk.calendar.Holiday;
import com.atlassian.jira.migration.db.servicedesk.calendar.WorkingTime;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.calendar.CalendarUtil;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.servicedesk.Calendar;
import com.atlassian.migration.jira.servicedesk.Servicedesk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001 B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/calendar/CalendarExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/db/servicedesk/calendar/Calendar;", "Lcom/atlassian/migration/jira/servicedesk/Calendar;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "calendarReader", "Lcom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader;", "calendarUtil", "Lcom/atlassian/jira/migration/export/servicedesk/calendar/CalendarUtil;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader;Lcom/atlassian/jira/migration/export/servicedesk/calendar/CalendarUtil;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "getHolidays", "", "Lcom/atlassian/migration/jira/servicedesk/Calendar$Holiday;", "calendar", "getWorkingTimes", "Lcom/atlassian/migration/jira/servicedesk/Calendar$WorkingTime;", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCalendarExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendarExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/calendar/CalendarExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n1549#2:81\n1620#2,3:82\n*S KotlinDebug\n*F\n+ 1 CalendarExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/calendar/CalendarExporter\n*L\n64#1:77\n64#1:78,3\n69#1:81\n69#1:82,3\n*E\n"})
public final class CalendarExporter
implements Exporter<Integer, com.atlassian.jira.migration.db.servicedesk.calendar.Calendar, Calendar> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final CalendarReader calendarReader;
    @NotNull
    private final CalendarUtil calendarUtil;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(CalendarExporter.class);

    @Inject
    public CalendarExporter(@NotNull ExportService exportService, @NotNull CalendarReader calendarReader, @NotNull CalendarUtil calendarUtil) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)calendarReader, (String)"calendarReader");
        Intrinsics.checkNotNullParameter((Object)calendarUtil, (String)"calendarUtil");
        this.exportService = exportService;
        this.calendarReader = calendarReader;
        this.calendarUtil = calendarUtil;
        this.key = new ExporterKey(Calendar.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.jira.migration.db.servicedesk.calendar.Calendar.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(Calendar.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.jira.migration.db.servicedesk.calendar.Calendar entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public Calendar exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.migration.db.servicedesk.calendar.Calendar entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        log.info("Exporting calendar entity [" + entity.getId() + "] for project [" + ctx.getProject() + "] as user [" + ctx.getStartedBy() + ']');
        int serviceDeskId = entity.getServiceDeskId();
        MRI entityMri = this.mriForEntity(entity);
        MRI serviceDeskMri2 = this.exportService.checkExportedOrThrow(ctx, Servicedesk.Companion.getEntityType(), serviceDeskId, (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, serviceDeskId){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ int $serviceDeskId;
            {
                this.$entityMri = $entityMri;
                this.$serviceDeskId = $serviceDeskId;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "Calendar with MRI - " + this.$entityMri + " has missing Service Desk with MRI - " + mri + '.';
                String string2 = "Verify if Service Desk with id " + this.$serviceDeskId + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        }));
        return new Calendar(entityMri, serviceDeskMri2, this.calendarUtil.trimName(entity.getName(), 62), entity.getTimezone(), entity.getContext(), this.getHolidays(ctx, entity), this.getWorkingTimes(ctx, entity));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Calendar.Holiday> getHolidays(ExportContext ctx, com.atlassian.jira.migration.db.servicedesk.calendar.Calendar calendar) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.calendarReader.getHolidaysForCalendar(calendar);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Holiday holiday = (Holiday)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportService.exportObjectOrThrow(ctx, it, Calendar.Holiday.class));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Calendar.WorkingTime> getWorkingTimes(ExportContext ctx, com.atlassian.jira.migration.db.servicedesk.calendar.Calendar calendar) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.calendarReader.getWorkingTimesForCalendar(calendar);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WorkingTime workingTime = (WorkingTime)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportService.exportObjectOrThrow(ctx, it, Calendar.WorkingTime.class));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.migration.db.servicedesk.calendar.Calendar entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public com.atlassian.jira.migration.db.servicedesk.calendar.Calendar extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.migration.db.servicedesk.calendar.Calendar entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/calendar/CalendarExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

